/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.transport;

import com.amazon.opendistroforelasticsearch.alerting.action.IndexDestinationAction;
import com.amazon.opendistroforelasticsearch.alerting.action.IndexDestinationRequest;
import com.amazon.opendistroforelasticsearch.alerting.action.IndexDestinationResponse;
import com.amazon.opendistroforelasticsearch.alerting.core.ScheduledJobIndices;
import com.amazon.opendistroforelasticsearch.alerting.model.destination.Destination;
import com.amazon.opendistroforelasticsearch.alerting.settings.AlertingSettings;
import com.amazon.opendistroforelasticsearch.alerting.settings.DestinationSettings;
import com.amazon.opendistroforelasticsearch.alerting.transport.TransportIndexDestinationActionKt;
import com.amazon.opendistroforelasticsearch.alerting.transport.TransportIndexDestinationActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0;
import com.amazon.opendistroforelasticsearch.alerting.util.AlertingException;
import com.amazon.opendistroforelasticsearch.alerting.util.AlertingUtilsKt;
import com.amazon.opendistroforelasticsearch.alerting.util.DestinationType;
import com.amazon.opendistroforelasticsearch.alerting.util.IndexUtils;
import com.amazon.opendistroforelasticsearch.commons.authuser.User;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001+B?\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J&\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00022\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030*H\u0014R\"\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0015 \u0016*\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0016\u0010\u001e\u001a\n \u0016*\u0004\u0018\u00010\u001f0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006,"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportIndexDestinationAction;", "Lorg/elasticsearch/action/support/HandledTransportAction;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexDestinationRequest;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexDestinationResponse;", "transportService", "Lorg/elasticsearch/transport/TransportService;", "client", "Lorg/elasticsearch/client/Client;", "actionFilters", "Lorg/elasticsearch/action/support/ActionFilters;", "scheduledJobIndices", "Lcom/amazon/opendistroforelasticsearch/alerting/core/ScheduledJobIndices;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "settings", "Lorg/elasticsearch/common/settings/Settings;", "xContentRegistry", "Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "(Lorg/elasticsearch/transport/TransportService;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/action/support/ActionFilters;Lcom/amazon/opendistroforelasticsearch/alerting/core/ScheduledJobIndices;Lorg/elasticsearch/cluster/service/ClusterService;Lorg/elasticsearch/common/settings/Settings;Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;)V", "allowList", "", "", "kotlin.jvm.PlatformType", "getClient", "()Lorg/elasticsearch/client/Client;", "getClusterService", "()Lorg/elasticsearch/cluster/service/ClusterService;", "filterByEnabled", "", "Ljava/lang/Boolean;", "indexTimeout", "Lorg/elasticsearch/common/unit/TimeValue;", "getScheduledJobIndices", "()Lcom/amazon/opendistroforelasticsearch/alerting/core/ScheduledJobIndices;", "getXContentRegistry", "()Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/elasticsearch/tasks/Task;", "request", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "IndexDestinationHandler", "opendistro-alerting"})
public final class TransportIndexDestinationAction
extends HandledTransportAction<IndexDestinationRequest, IndexDestinationResponse> {
    private volatile TimeValue indexTimeout;
    private volatile List<String> allowList;
    private volatile Boolean filterByEnabled;
    @NotNull
    private final Client client;
    @NotNull
    private final ScheduledJobIndices scheduledJobIndices;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull IndexDestinationRequest request, @NotNull ActionListener<IndexDestinationResponse> actionListener) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        ThreadPool threadPool = this.client.threadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadPool, (String)"client.threadPool()");
        String userStr = (String)threadPool.getThreadContext().getTransient("_opendistro_security_user_info");
        TransportIndexDestinationActionKt.access$getLog$p().debug("User and roles string from thread context: " + userStr);
        User user = User.parse((String)userStr);
        Boolean bl = this.filterByEnabled;
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"filterByEnabled");
        if (!AlertingUtilsKt.checkFilterByUserBackendRoles(bl, user, actionListener)) {
            return;
        }
        ThreadPool threadPool2 = this.client.threadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadPool2, (String)"client.threadPool()");
        AutoCloseable autoCloseable = (AutoCloseable)threadPool2.getThreadContext().stashContext();
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl3 = false;
            new IndexDestinationHandler(this.client, actionListener, request, user).resolveUserAndStart();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ScheduledJobIndices getScheduledJobIndices() {
        return this.scheduledJobIndices;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Inject
    public TransportIndexDestinationAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull ScheduledJobIndices scheduledJobIndices, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)transportService, (String)"transportService");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkParameterIsNotNull((Object)scheduledJobIndices, (String)"scheduledJobIndices");
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)xContentRegistry, (String)"xContentRegistry");
        String string = IndexDestinationAction.Companion.getNAME();
        Object object = 1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new TransportIndexDestinationActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0(function1);
        }
        super(string, transportService, actionFilters, (Writeable.Reader)object);
        this.client = client;
        this.scheduledJobIndices = scheduledJobIndices;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.indexTimeout = (TimeValue)AlertingSettings.Companion.getINDEX_TIMEOUT().get(settings);
        this.allowList = (List)DestinationSettings.Companion.getALLOW_LIST().get(settings);
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getINDEX_TIMEOUT(), (Consumer)new Consumer<TimeValue>(){

            @Override
            public final void accept(TimeValue it) {
                indexTimeout = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DestinationSettings.Companion.getALLOW_LIST(), (Consumer)new Consumer<List<? extends String>>(){

            @Override
            public final void accept(List<String> it) {
                allowList = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES(), (Consumer)new Consumer<Boolean>(){

            @Override
            public final void accept(Boolean it) {
                filterByEnabled = it;
            }
        });
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\u0006\u0010\u0019\u001a\u00020\u0011J\u0006\u0010\u001a\u001a\u00020\u0011J\b\u0010\u001b\u001a\u00020\u0011H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportIndexDestinationAction$IndexDestinationHandler;", "", "client", "Lorg/elasticsearch/client/Client;", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexDestinationResponse;", "request", "Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexDestinationRequest;", "user", "Lcom/amazon/opendistroforelasticsearch/commons/authuser/User;", "(Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportIndexDestinationAction;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/action/ActionListener;Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexDestinationRequest;Lcom/amazon/opendistroforelasticsearch/commons/authuser/User;)V", "checkShardsFailure", "", "response", "Lorg/elasticsearch/action/index/IndexResponse;", "onCreateMappingsResponse", "", "Lorg/elasticsearch/action/admin/indices/create/CreateIndexResponse;", "onGetResponse", "destination", "Lcom/amazon/opendistroforelasticsearch/alerting/model/destination/Destination;", "onUpdateMappingsResponse", "Lorg/elasticsearch/action/support/master/AcknowledgedResponse;", "prepareDestinationIndexing", "resolveUserAndStart", "start", "updateDestination", "opendistro-alerting"})
    public final class IndexDestinationHandler {
        private final Client client;
        private final ActionListener<IndexDestinationResponse> actionListener;
        private final IndexDestinationRequest request;
        private final User user;

        public final void resolveUserAndStart() {
            if (this.user == null) {
                List list;
                String string = "";
                String string2 = null;
                DestinationType destinationType = null;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                long l = 0L;
                String string3 = null;
                Destination destination = this.request.getDestination();
                IndexDestinationRequest indexDestinationRequest = this.request;
                boolean bl = false;
                List list2 = CollectionsKt.emptyList();
                bl = false;
                List list3 = CollectionsKt.emptyList();
                bl = false;
                List list4 = list = CollectionsKt.emptyList();
                List list5 = list3;
                List list6 = list2;
                String string4 = string;
                indexDestinationRequest.setDestination(Destination.copy$default(destination, string3, l, n3, n2, n, destinationType, string2, new User(string4, list6, list5, list4), null, null, null, null, null, 8063, null));
                this.start();
            } else {
                try {
                    this.request.setDestination(Destination.copy$default(this.request.getDestination(), null, 0L, 0, 0, 0, null, null, new User(this.user.getName(), this.user.getBackendRoles(), this.user.getRoles(), this.user.getCustomAttNames()), null, null, null, null, null, 8063, null));
                    this.start();
                }
                catch (IOException ex) {
                    this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(ex));
                }
            }
        }

        public final void start() {
            if (!TransportIndexDestinationAction.this.getScheduledJobIndices().scheduledJobIndexExists()) {
                TransportIndexDestinationAction.this.getScheduledJobIndices().initScheduledJobIndex((ActionListener)new ActionListener<CreateIndexResponse>(this){
                    final /* synthetic */ IndexDestinationHandler this$0;

                    public void onResponse(@NotNull CreateIndexResponse response2) {
                        Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                        IndexDestinationHandler.access$onCreateMappingsResponse(this.this$0, response2);
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                        IndexDestinationHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                    {
                        this.this$0 = $outer;
                    }
                });
            } else if (!IndexUtils.Companion.getScheduledJobIndexUpdated()) {
                String string = ScheduledJobIndices.Companion.scheduledJobMappings();
                ClusterState clusterState = TransportIndexDestinationAction.this.getClusterService().state();
                Intrinsics.checkExpressionValueIsNotNull((Object)clusterState, (String)"clusterService.state()");
                IndicesAdminClient indicesAdminClient = this.client.admin().indices();
                Intrinsics.checkExpressionValueIsNotNull((Object)indicesAdminClient, (String)"client.admin().indices()");
                IndexUtils.Companion.updateIndexMapping(".opendistro-alerting-config", "_doc", string, clusterState, indicesAdminClient, (ActionListener<AcknowledgedResponse>)((ActionListener)new ActionListener<AcknowledgedResponse>(this){
                    final /* synthetic */ IndexDestinationHandler this$0;

                    public void onResponse(@NotNull AcknowledgedResponse response2) {
                        Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                        IndexDestinationHandler.access$onUpdateMappingsResponse(this.this$0, response2);
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                        IndexDestinationHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                    {
                        this.this$0 = $outer;
                    }
                }));
            } else {
                this.prepareDestinationIndexing();
            }
        }

        private final void prepareDestinationIndexing() {
            String destinationType = this.request.getDestination().getType().getValue();
            if (!TransportIndexDestinationAction.this.allowList.contains(destinationType)) {
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("Destination type is not allowed: " + destinationType, RestStatus.FORBIDDEN, new Object[0])));
                return;
            }
            if (this.request.getMethod() == RestRequest.Method.PUT) {
                this.updateDestination();
            } else {
                Destination destination = Destination.copy$default(this.request.getDestination(), null, 0L, IndexUtils.Companion.getScheduledJobIndexSchemaVersion(), 0, 0, null, null, null, null, null, null, null, null, 8187, null);
                IndexRequest indexRequest = (IndexRequest)new IndexRequest(".opendistro-alerting-config").setRefreshPolicy(this.request.getRefreshPolicy());
                XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
                Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"jsonBuilder()");
                IndexRequest indexRequest2 = (IndexRequest)indexRequest.source(destination.toXContent(xContentBuilder, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))))).setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm()).timeout(TransportIndexDestinationAction.this.indexTimeout);
                this.client.index(indexRequest2, (ActionListener)new ActionListener<IndexResponse>(this, destination){
                    final /* synthetic */ IndexDestinationHandler this$0;
                    final /* synthetic */ Destination $destination;

                    public void onResponse(@NotNull IndexResponse response2) {
                        Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                        String failureReasons = IndexDestinationHandler.access$checkShardsFailure(this.this$0, response2);
                        if (failureReasons != null) {
                            IndexDestinationHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException(failureReasons.toString(), response2.status(), new Object[0])));
                            return;
                        }
                        ActionListener actionListener = IndexDestinationHandler.access$getActionListener$p(this.this$0);
                        String string = response2.getId();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.id");
                        actionListener.onResponse((Object)((Object)new IndexDestinationResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), RestStatus.CREATED, this.$destination)));
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                        IndexDestinationHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                    {
                        this.this$0 = $outer;
                        this.$destination = $captured_local_variable$1;
                    }
                });
            }
        }

        private final void onCreateMappingsResponse(CreateIndexResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexDestinationActionKt.access$getLog$p().info("Created .opendistro-alerting-config with mappings.");
                this.prepareDestinationIndexing();
                IndexUtils.Companion.scheduledJobIndexUpdated();
            } else {
                TransportIndexDestinationActionKt.access$getLog$p().error("Create .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("Create .opendistro-alerting-config mappings call not acknowledged", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void onUpdateMappingsResponse(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexDestinationActionKt.access$getLog$p().info("Updated  .opendistro-alerting-config with mappings.");
                IndexUtils.Companion.scheduledJobIndexUpdated();
                this.prepareDestinationIndexing();
            } else {
                TransportIndexDestinationActionKt.access$getLog$p().error("Update .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("Updated .opendistro-alerting-config mappings call not acknowledged.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void updateDestination() {
            GetRequest getRequest = new GetRequest(".opendistro-alerting-config", this.request.getDestinationId());
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(this){
                final /* synthetic */ IndexDestinationHandler this$0;

                public void onResponse(@NotNull GetResponse response2) {
                    Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        IndexDestinationHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("Destination with " + IndexDestinationHandler.access$getRequest$p(this.this$0).getDestinationId() + " is not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    String id = response2.getId();
                    long version = response2.getVersion();
                    int seqNo = (int)response2.getSeqNo();
                    int primaryTerm = (int)response2.getPrimaryTerm();
                    XContentParser xcp = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(this.this$0.TransportIndexDestinationAction.this.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response2.getSourceAsString());
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                    XContentParser xContentParser = xcp;
                    Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"xcp");
                    String string = id;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
                    Destination dest = Destination.Companion.parse(xContentParser, string, version, seqNo, primaryTerm);
                    IndexDestinationHandler.access$onGetResponse(this.this$0, dest);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    IndexDestinationHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        private final void onGetResponse(Destination destination) {
            Boolean bl = TransportIndexDestinationAction.this.filterByEnabled;
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"filterByEnabled");
            if (!AlertingUtilsKt.checkUserFilterByPermissions(bl, this.user, destination.getUser(), this.actionListener, "destination", this.request.getDestinationId())) {
                return;
            }
            Destination indexDestination = Destination.copy$default(this.request.getDestination(), null, 0L, IndexUtils.Companion.getScheduledJobIndexSchemaVersion(), 0, 0, null, null, null, null, null, null, null, null, 8187, null);
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(".opendistro-alerting-config").setRefreshPolicy(this.request.getRefreshPolicy());
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"jsonBuilder()");
            IndexRequest indexRequest2 = (IndexRequest)indexRequest.source(indexDestination.toXContent(xContentBuilder, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))))).id(this.request.getDestinationId()).setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm()).timeout(TransportIndexDestinationAction.this.indexTimeout);
            this.client.index(indexRequest2, (ActionListener)new ActionListener<IndexResponse>(this, indexDestination){
                final /* synthetic */ IndexDestinationHandler this$0;
                final /* synthetic */ Destination $indexDestination;

                public void onResponse(@NotNull IndexResponse response2) {
                    Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                    String failureReasons = IndexDestinationHandler.access$checkShardsFailure(this.this$0, response2);
                    if (failureReasons != null) {
                        IndexDestinationHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException(failureReasons.toString(), response2.status(), new Object[0])));
                        return;
                    }
                    ActionListener actionListener = IndexDestinationHandler.access$getActionListener$p(this.this$0);
                    String string = response2.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.id");
                    actionListener.onResponse((Object)((Object)new IndexDestinationResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), RestStatus.CREATED, this.$indexDestination)));
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    IndexDestinationHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
                {
                    this.this$0 = $outer;
                    this.$indexDestination = $captured_local_variable$1;
                }
            });
        }

        private final String checkShardsFailure(IndexResponse response2) {
            StringBuilder failureReasons = new StringBuilder();
            ReplicationResponse.ShardInfo shardInfo = response2.getShardInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)shardInfo, (String)"response.shardInfo");
            if (shardInfo.getFailed() > 0) {
                ReplicationResponse.ShardInfo shardInfo2 = response2.getShardInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)shardInfo2, (String)"response.shardInfo");
                ReplicationResponse.ShardInfo.Failure[] failureArray = shardInfo2.getFailures();
                Intrinsics.checkExpressionValueIsNotNull((Object)failureArray, (String)"response.shardInfo.failures");
                ReplicationResponse.ShardInfo.Failure[] $this$forEach$iv = failureArray;
                boolean $i$f$forEach = false;
                ReplicationResponse.ShardInfo.Failure[] failureArray2 = $this$forEach$iv;
                int n = failureArray2.length;
                for (int i = 0; i < n; ++i) {
                    ReplicationResponse.ShardInfo.Failure element$iv;
                    ReplicationResponse.ShardInfo.Failure entry = element$iv = failureArray2[i];
                    boolean bl = false;
                    failureReasons.append(entry.reason());
                }
                return failureReasons.toString();
            }
            return null;
        }

        public IndexDestinationHandler(@NotNull Client client, @NotNull ActionListener<IndexDestinationResponse> actionListener, @Nullable IndexDestinationRequest request, User user) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
            Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
        }

        public static final /* synthetic */ void access$onCreateMappingsResponse(IndexDestinationHandler $this, CreateIndexResponse response2) {
            $this.onCreateMappingsResponse(response2);
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(IndexDestinationHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ void access$onUpdateMappingsResponse(IndexDestinationHandler $this, AcknowledgedResponse response2) {
            $this.onUpdateMappingsResponse(response2);
        }

        public static final /* synthetic */ String access$checkShardsFailure(IndexDestinationHandler $this, IndexResponse response2) {
            return $this.checkShardsFailure(response2);
        }

        public static final /* synthetic */ IndexDestinationRequest access$getRequest$p(IndexDestinationHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ void access$onGetResponse(IndexDestinationHandler $this, Destination destination) {
            $this.onGetResponse(destination);
        }
    }
}

