/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.transport;

import com.amazon.opendistroforelasticsearch.alerting.action.GetDestinationsAction;
import com.amazon.opendistroforelasticsearch.alerting.action.GetDestinationsRequest;
import com.amazon.opendistroforelasticsearch.alerting.action.GetDestinationsResponse;
import com.amazon.opendistroforelasticsearch.alerting.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.alerting.model.Table;
import com.amazon.opendistroforelasticsearch.alerting.model.destination.Destination;
import com.amazon.opendistroforelasticsearch.alerting.settings.AlertingSettings;
import com.amazon.opendistroforelasticsearch.alerting.transport.TransportGetDestinationsActionKt;
import com.amazon.opendistroforelasticsearch.alerting.transport.TransportGetDestinationsActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0;
import com.amazon.opendistroforelasticsearch.alerting.util.AlertingException;
import com.amazon.opendistroforelasticsearch.commons.authuser.User;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B7\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!H\u0014J&\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!2\b\u0010%\u001a\u0004\u0018\u00010&J\u001c\u0010'\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006("}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportGetDestinationsAction;", "Lorg/elasticsearch/action/support/HandledTransportAction;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/GetDestinationsRequest;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/GetDestinationsResponse;", "transportService", "Lorg/elasticsearch/transport/TransportService;", "client", "Lorg/elasticsearch/client/Client;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "actionFilters", "Lorg/elasticsearch/action/support/ActionFilters;", "settings", "Lorg/elasticsearch/common/settings/Settings;", "xContentRegistry", "Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "(Lorg/elasticsearch/transport/TransportService;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/cluster/service/ClusterService;Lorg/elasticsearch/action/support/ActionFilters;Lorg/elasticsearch/common/settings/Settings;Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/elasticsearch/client/Client;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "getSettings", "()Lorg/elasticsearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/elasticsearch/tasks/Task;", "getDestinationsRequest", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "resolve", "searchSourceBuilder", "Lorg/elasticsearch/search/builder/SearchSourceBuilder;", "user", "Lcom/amazon/opendistroforelasticsearch/commons/authuser/User;", "search", "opendistro-alerting"})
public final class TransportGetDestinationsAction
extends HandledTransportAction<GetDestinationsRequest, GetDestinationsResponse> {
    private volatile Boolean filterByEnabled;
    @NotNull
    private final Client client;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull GetDestinationsRequest getDestinationsRequest, @NotNull ActionListener<GetDestinationsResponse> actionListener) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)((Object)getDestinationsRequest), (String)"getDestinationsRequest");
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        ThreadPool threadPool = this.client.threadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadPool, (String)"client.threadPool()");
        String userStr = (String)threadPool.getThreadContext().getTransient("_opendistro_security_user_info");
        TransportGetDestinationsActionKt.access$getLog$p().debug("User and roles string from thread context: " + userStr);
        User user = User.parse((String)userStr);
        Table tableProp = getDestinationsRequest.getTable();
        FieldSortBuilder sortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)tableProp.getSortString()).order(SortOrder.fromString((String)tableProp.getSortOrder()));
        CharSequence charSequence = tableProp.getMissing();
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            sortBuilder.missing((Object)tableProp.getMissing());
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().sort((SortBuilder)sortBuilder).size(tableProp.getSize()).from(tableProp.getStartIndex()).fetchSource(new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY)).seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true));
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"destination"));
        Object object = getDestinationsRequest.getDestinationId();
        boolean bl3 = false;
        boolean bl4 = false;
        if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
            queryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)getDestinationsRequest.getDestinationId()));
        }
        if (Intrinsics.areEqual((Object)getDestinationsRequest.getDestinationType(), (Object)"ALL") ^ true) {
            queryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"destination.type", (String)getDestinationsRequest.getDestinationType()));
        }
        object = tableProp.getSearchString();
        bl3 = false;
        bl4 = false;
        if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
            queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)tableProp.getSearchString()).defaultOperator(Operator.AND).field("destination.type").field("destination.name"));
        }
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        ThreadPool threadPool2 = this.client.threadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadPool2, (String)"client.threadPool()");
        object = (AutoCloseable)threadPool2.getThreadContext().stashContext();
        bl3 = false;
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)object;
            boolean bl5 = false;
            SearchSourceBuilder searchSourceBuilder2 = searchSourceBuilder;
            Intrinsics.checkExpressionValueIsNotNull((Object)searchSourceBuilder2, (String)"searchSourceBuilder");
            this.resolve(searchSourceBuilder2, actionListener, user);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
    }

    public final void resolve(@NotNull SearchSourceBuilder searchSourceBuilder, @NotNull ActionListener<GetDestinationsResponse> actionListener, @Nullable User user) {
        Intrinsics.checkParameterIsNotNull((Object)searchSourceBuilder, (String)"searchSourceBuilder");
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        if (user == null) {
            this.search(searchSourceBuilder, actionListener);
        } else if (!this.filterByEnabled.booleanValue()) {
            this.search(searchSourceBuilder, actionListener);
        } else {
            try {
                TransportGetDestinationsActionKt.access$getLog$p().info("Filtering result by: " + user.getBackendRoles());
                ElasticExtensionsKt.addFilter((User)user, (SearchSourceBuilder)searchSourceBuilder, (String)"destination.user.backend_roles.keyword");
                this.search(searchSourceBuilder, actionListener);
            }
            catch (IOException ex) {
                actionListener.onFailure((Exception)AlertingException.Companion.wrap(ex));
            }
        }
    }

    public final void search(@NotNull SearchSourceBuilder searchSourceBuilder, @NotNull ActionListener<GetDestinationsResponse> actionListener) {
        Intrinsics.checkParameterIsNotNull((Object)searchSourceBuilder, (String)"searchSourceBuilder");
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{".opendistro-alerting-config"});
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this, actionListener){
            final /* synthetic */ TransportGetDestinationsAction this$0;
            final /* synthetic */ ActionListener $actionListener;

            public void onResponse(@NotNull SearchResponse response2) {
                Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                SearchHits searchHits = response2.getHits();
                Intrinsics.checkExpressionValueIsNotNull((Object)searchHits, (String)"response.hits");
                TotalHits totalHits = searchHits.getTotalHits();
                Integer totalDestinationCount = totalHits != null ? Integer.valueOf((int)totalHits.value) : null;
                boolean bl = false;
                List destinations = new ArrayList<E>();
                Iterator iterator = response2.getHits().iterator();
                while (iterator.hasNext()) {
                    SearchHit hit;
                    SearchHit searchHit = hit = (SearchHit)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)searchHit, (String)"hit");
                    String id = searchHit.getId();
                    long version = hit.getVersion();
                    int seqNo = (int)hit.getSeqNo();
                    int primaryTerm = (int)hit.getPrimaryTerm();
                    XContentParser xcp = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(this.this$0.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                    XContentParser xContentParser = xcp;
                    Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"xcp");
                    String string = id;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
                    destinations.add(Destination.Companion.parse(xContentParser, string, version, seqNo, primaryTerm));
                }
                this.$actionListener.onResponse((Object)((Object)new GetDestinationsResponse(RestStatus.OK, totalDestinationCount, destinations)));
            }

            public void onFailure(@NotNull Exception t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
            }
            {
                this.this$0 = $outer;
                this.$actionListener = $captured_local_variable$1;
            }
        });
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Inject
    public TransportGetDestinationsAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull ActionFilters actionFilters, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)transportService, (String)"transportService");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        Intrinsics.checkParameterIsNotNull((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)xContentRegistry, (String)"xContentRegistry");
        String string = GetDestinationsAction.Companion.getNAME();
        Object object = 1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new TransportGetDestinationsActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0(function1);
        }
        super(string, transportService, actionFilters, (Writeable.Reader)object);
        this.client = client;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES(), (Consumer)new Consumer<Boolean>(){

            @Override
            public final void accept(Boolean it) {
                filterByEnabled = it;
            }
        });
    }

    public static final /* synthetic */ Boolean access$getFilterByEnabled$p(TransportGetDestinationsAction $this) {
        return $this.filterByEnabled;
    }
}

