/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.transport;

import com.amazon.opendistroforelasticsearch.alerting.action.DeleteMonitorAction;
import com.amazon.opendistroforelasticsearch.alerting.action.DeleteMonitorRequest;
import com.amazon.opendistroforelasticsearch.alerting.core.model.ScheduledJob;
import com.amazon.opendistroforelasticsearch.alerting.model.Monitor;
import com.amazon.opendistroforelasticsearch.alerting.settings.AlertingSettings;
import com.amazon.opendistroforelasticsearch.alerting.transport.TransportDeleteMonitorActionKt;
import com.amazon.opendistroforelasticsearch.alerting.transport.TransportDeleteMonitorActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0;
import com.amazon.opendistroforelasticsearch.alerting.util.AlertingException;
import com.amazon.opendistroforelasticsearch.alerting.util.AlertingUtilsKt;
import com.amazon.opendistroforelasticsearch.commons.authuser.User;
import java.io.IOException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\"B7\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportDeleteMonitorAction;", "Lorg/elasticsearch/action/support/HandledTransportAction;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/DeleteMonitorRequest;", "Lorg/elasticsearch/action/delete/DeleteResponse;", "transportService", "Lorg/elasticsearch/transport/TransportService;", "client", "Lorg/elasticsearch/client/Client;", "actionFilters", "Lorg/elasticsearch/action/support/ActionFilters;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "settings", "Lorg/elasticsearch/common/settings/Settings;", "xContentRegistry", "Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "(Lorg/elasticsearch/transport/TransportService;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/action/support/ActionFilters;Lorg/elasticsearch/cluster/service/ClusterService;Lorg/elasticsearch/common/settings/Settings;Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/elasticsearch/client/Client;", "getClusterService", "()Lorg/elasticsearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "getXContentRegistry", "()Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/elasticsearch/tasks/Task;", "request", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "DeleteMonitorHandler", "opendistro-alerting"})
public final class TransportDeleteMonitorAction
extends HandledTransportAction<DeleteMonitorRequest, DeleteResponse> {
    private volatile Boolean filterByEnabled;
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull DeleteMonitorRequest request, @NotNull ActionListener<DeleteResponse> actionListener) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        ThreadPool threadPool = this.client.threadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadPool, (String)"client.threadPool()");
        String userStr = (String)threadPool.getThreadContext().getTransient("_opendistro_security_user_info");
        TransportDeleteMonitorActionKt.access$getLog$p().debug("User and roles string from thread context: " + userStr);
        User user = User.parse((String)userStr);
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".opendistro-alerting-config", request.getMonitorId()).setRefreshPolicy(request.getRefreshPolicy());
        Boolean bl = this.filterByEnabled;
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"filterByEnabled");
        if (!AlertingUtilsKt.checkFilterByUserBackendRoles(bl, user, actionListener)) {
            return;
        }
        ThreadPool threadPool2 = this.client.threadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadPool2, (String)"client.threadPool()");
        AutoCloseable autoCloseable = (AutoCloseable)threadPool2.getThreadContext().stashContext();
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl3 = false;
            DeleteRequest deleteRequest2 = deleteRequest;
            Intrinsics.checkExpressionValueIsNotNull((Object)deleteRequest2, (String)"deleteRequest");
            new DeleteMonitorHandler(this.client, actionListener, deleteRequest2, user, request.getMonitorId()).resolveUserAndStart();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Inject
    public TransportDeleteMonitorAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)transportService, (String)"transportService");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)xContentRegistry, (String)"xContentRegistry");
        String string = DeleteMonitorAction.Companion.getNAME();
        Object object = 1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new TransportDeleteMonitorActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0(function1);
        }
        super(string, transportService, actionFilters, (Writeable.Reader)object);
        this.client = client;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES(), (Consumer)new Consumer<Boolean>(){

            @Override
            public final void accept(Boolean it) {
                filterByEnabled = it;
            }
        });
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u000fJ\u0006\u0010\u0014\u001a\u00020\u000fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportDeleteMonitorAction$DeleteMonitorHandler;", "", "client", "Lorg/elasticsearch/client/Client;", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "Lorg/elasticsearch/action/delete/DeleteResponse;", "deleteRequest", "Lorg/elasticsearch/action/delete/DeleteRequest;", "user", "Lcom/amazon/opendistroforelasticsearch/commons/authuser/User;", "monitorId", "", "(Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportDeleteMonitorAction;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/action/ActionListener;Lorg/elasticsearch/action/delete/DeleteRequest;Lcom/amazon/opendistroforelasticsearch/commons/authuser/User;Ljava/lang/String;)V", "deleteMonitor", "", "onGetResponse", "monitor", "Lcom/amazon/opendistroforelasticsearch/alerting/model/Monitor;", "resolveUserAndStart", "start", "opendistro-alerting"})
    public final class DeleteMonitorHandler {
        private final Client client;
        private final ActionListener<DeleteResponse> actionListener;
        private final DeleteRequest deleteRequest;
        private final User user;
        private final String monitorId;

        public final void resolveUserAndStart() {
            if (this.user == null) {
                this.deleteMonitor();
            } else if (!TransportDeleteMonitorAction.this.filterByEnabled.booleanValue()) {
                this.deleteMonitor();
            } else {
                try {
                    this.start();
                }
                catch (IOException ex) {
                    this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(ex));
                }
            }
        }

        public final void start() {
            GetRequest getRequest = new GetRequest(".opendistro-alerting-config", this.monitorId);
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(this){
                final /* synthetic */ DeleteMonitorHandler this$0;

                public void onResponse(@NotNull GetResponse response2) {
                    XContentParser xcp;
                    Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        DeleteMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new ElasticsearchStatusException("Monitor with " + DeleteMonitorHandler.access$getMonitorId$p(this.this$0) + " is not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    XContentParser xContentParser = xcp = XContentHelper.createParser((NamedXContentRegistry)this.this$0.TransportDeleteMonitorAction.this.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (XContentType)XContentType.JSON);
                    Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"xcp");
                    String string = response2.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.id");
                    ScheduledJob scheduledJob = ScheduledJob.Companion.parse(xContentParser, string, response2.getVersion());
                    if (scheduledJob == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.amazon.opendistroforelasticsearch.alerting.model.Monitor");
                    }
                    Monitor monitor = (Monitor)scheduledJob;
                    DeleteMonitorHandler.access$onGetResponse(this.this$0, monitor);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    DeleteMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        private final void onGetResponse(Monitor monitor) {
            Boolean bl = TransportDeleteMonitorAction.this.filterByEnabled;
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"filterByEnabled");
            if (!AlertingUtilsKt.checkUserFilterByPermissions(bl, this.user, monitor.getUser(), this.actionListener, "monitor", this.monitorId)) {
                return;
            }
            this.deleteMonitor();
        }

        private final void deleteMonitor() {
            this.client.delete(this.deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(this){
                final /* synthetic */ DeleteMonitorHandler this$0;

                public void onResponse(@NotNull DeleteResponse response2) {
                    Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                    DeleteMonitorHandler.access$getActionListener$p(this.this$0).onResponse((Object)response2);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    DeleteMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        public DeleteMonitorHandler(@NotNull Client client, @NotNull ActionListener<DeleteResponse> actionListener, @Nullable DeleteRequest deleteRequest, @NotNull User user, String monitorId) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
            Intrinsics.checkParameterIsNotNull((Object)deleteRequest, (String)"deleteRequest");
            Intrinsics.checkParameterIsNotNull((Object)monitorId, (String)"monitorId");
            this.client = client;
            this.actionListener = actionListener;
            this.deleteRequest = deleteRequest;
            this.user = user;
            this.monitorId = monitorId;
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(DeleteMonitorHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ String access$getMonitorId$p(DeleteMonitorHandler $this) {
            return $this.monitorId;
        }

        public static final /* synthetic */ void access$onGetResponse(DeleteMonitorHandler $this, Monitor monitor) {
            $this.onGetResponse(monitor);
        }
    }
}

