/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.transport;

import com.amazon.opendistroforelasticsearch.alerting.action.AcknowledgeAlertAction;
import com.amazon.opendistroforelasticsearch.alerting.action.AcknowledgeAlertRequest;
import com.amazon.opendistroforelasticsearch.alerting.action.AcknowledgeAlertResponse;
import com.amazon.opendistroforelasticsearch.alerting.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.alerting.model.Alert;
import com.amazon.opendistroforelasticsearch.alerting.transport.TransportAcknowledgeAlertActionKt;
import com.amazon.opendistroforelasticsearch.alerting.transport.TransportAcknowledgeAlertActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0;
import com.amazon.opendistroforelasticsearch.alerting.util.AlertingException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0018B'\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportAcknowledgeAlertAction;", "Lorg/elasticsearch/action/support/HandledTransportAction;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/AcknowledgeAlertRequest;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/AcknowledgeAlertResponse;", "transportService", "Lorg/elasticsearch/transport/TransportService;", "client", "Lorg/elasticsearch/client/Client;", "actionFilters", "Lorg/elasticsearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "(Lorg/elasticsearch/transport/TransportService;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/action/support/ActionFilters;Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/elasticsearch/client/Client;", "getXContentRegistry", "()Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/elasticsearch/tasks/Task;", "request", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "AcknowledgeHandler", "opendistro-alerting"})
public final class TransportAcknowledgeAlertAction
extends HandledTransportAction<AcknowledgeAlertRequest, AcknowledgeAlertResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull AcknowledgeAlertRequest request, @NotNull ActionListener<AcknowledgeAlertResponse> actionListener) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        ThreadPool threadPool = this.client.threadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadPool, (String)"client.threadPool()");
        AutoCloseable autoCloseable = (AutoCloseable)threadPool.getThreadContext().stashContext();
        boolean bl = false;
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl2 = false;
            new AcknowledgeHandler(this.client, actionListener, request).start();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Inject
    public TransportAcknowledgeAlertAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)transportService, (String)"transportService");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkParameterIsNotNull((Object)xContentRegistry, (String)"xContentRegistry");
        String string = AcknowledgeAlertAction.Companion.getNAME();
        Object object = 1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new TransportAcknowledgeAlertActionKt$sam$org_elasticsearch_common_io_stream_Writeable_Reader$0(function1);
        }
        super(string, transportService, actionFilters, (Writeable.Reader)object);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportAcknowledgeAlertAction$AcknowledgeHandler;", "", "client", "Lorg/elasticsearch/client/Client;", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/AcknowledgeAlertResponse;", "request", "Lcom/amazon/opendistroforelasticsearch/alerting/action/AcknowledgeAlertRequest;", "(Lcom/amazon/opendistroforelasticsearch/alerting/transport/TransportAcknowledgeAlertAction;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/action/ActionListener;Lcom/amazon/opendistroforelasticsearch/alerting/action/AcknowledgeAlertRequest;)V", "alerts", "", "", "Lcom/amazon/opendistroforelasticsearch/alerting/model/Alert;", "getAlerts", "()Ljava/util/Map;", "findActiveAlerts", "", "onBulkResponse", "response", "Lorg/elasticsearch/action/bulk/BulkResponse;", "onSearchResponse", "Lorg/elasticsearch/action/search/SearchResponse;", "start", "opendistro-alerting"})
    public final class AcknowledgeHandler {
        @NotNull
        private final Map<String, Alert> alerts;
        private final Client client;
        private final ActionListener<AcknowledgeAlertResponse> actionListener;
        private final AcknowledgeAlertRequest request;

        @NotNull
        public final Map<String, Alert> getAlerts() {
            return this.alerts;
        }

        public final void start() {
            this.findActiveAlerts();
        }

        private final void findActiveAlerts() {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"monitor_id", (String)this.request.getMonitorId())).filter((QueryBuilder)QueryBuilders.termsQuery((String)"_id", (Collection)this.request.getAlertIds()));
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{".opendistro-alerting-alerts"}).routing(this.request.getMonitorId()).source(new SearchSourceBuilder().query((QueryBuilder)queryBuilder).version(Boolean.valueOf(true)).seqNoAndPrimaryTerm(Boolean.valueOf(true)));
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){
                final /* synthetic */ AcknowledgeHandler this$0;

                public void onResponse(@NotNull SearchResponse response2) {
                    Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                    AcknowledgeHandler.access$onSearchResponse(this.this$0, response2);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    AcknowledgeHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void onSearchResponse(SearchResponse response2) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object list$iv$iv;
            void $this$flatMapTo$iv$iv;
            SearchHits searchHits = response2.getHits();
            Intrinsics.checkExpressionValueIsNotNull((Object)searchHits, (String)"response.hits");
            Iterable $this$flatMap$iv = (Iterable)searchHits;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list;
                SearchHit hit = (SearchHit)element$iv$iv;
                boolean bl = false;
                NamedXContentRegistry namedXContentRegistry = TransportAcknowledgeAlertAction.this.getXContentRegistry();
                DeprecationHandler deprecationHandler = (DeprecationHandler)LoggingDeprecationHandler.INSTANCE;
                SearchHit searchHit = hit;
                Intrinsics.checkExpressionValueIsNotNull((Object)searchHit, (String)"hit");
                XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)namedXContentRegistry, (DeprecationHandler)deprecationHandler, (BytesReference)searchHit.getSourceRef(), (XContentType)XContentType.JSON);
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                XContentParser xContentParser = xcp;
                Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"xcp");
                String string = hit.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hit.id");
                Alert alert = Alert.Companion.parse(xContentParser, string, hit.getVersion());
                this.alerts.put(alert.getId(), alert);
                if (alert.getState() == Alert.State.ACTIVE) {
                    UpdateRequest updateRequest = new UpdateRequest(".opendistro-alerting-alerts", hit.getId()).routing(this.request.getMonitorId()).setIfSeqNo(hit.getSeqNo()).setIfPrimaryTerm(hit.getPrimaryTerm());
                    XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject().field("state", Alert.State.ACKNOWLEDGED.toString());
                    Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"XContentFactory.jsonBuil\u2026.ACKNOWLEDGED.toString())");
                    list = CollectionsKt.listOf((Object)updateRequest.doc(ElasticExtensionsKt.optionalTimeField((XContentBuilder)xContentBuilder, (String)"acknowledged_time", (Instant)Instant.now()).endObject()));
                } else {
                    list = CollectionsKt.emptyList();
                }
                list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List updateRequests = (List)destination$iv$iv;
            $this$flatMap$iv = updateRequests;
            StringBuilder stringBuilder = new StringBuilder().append("Acknowledging monitor: ").append((Object)this.request).append(".monitorId, alerts: ");
            Logger logger = TransportAcknowledgeAlertActionKt.access$getLog$p();
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                list$iv$iv = (UpdateRequest)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = it.id();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            logger.info(stringBuilder.append(collection).toString());
            BulkRequest bulkRequest = new BulkRequest().add((Iterable)updateRequests).setRefreshPolicy(this.request.getRefreshPolicy());
            this.client.bulk(bulkRequest, (ActionListener)new ActionListener<BulkResponse>(this){
                final /* synthetic */ AcknowledgeHandler this$0;

                public void onResponse(@NotNull BulkResponse response2) {
                    Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                    AcknowledgeHandler.access$onBulkResponse(this.this$0, response2);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    AcknowledgeHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        private final void onBulkResponse(BulkResponse response2) {
            Set missing = CollectionsKt.toMutableSet((Iterable)this.request.getAlertIds());
            boolean bl = false;
            List acknowledged = new ArrayList();
            boolean bl2 = false;
            List failed = new ArrayList();
            BulkItemResponse[] $this$forEach$iv = (BulkItemResponse[])this.alerts.values();
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                Alert it = (Alert)t;
                boolean bl3 = false;
                if (it.getState() == Alert.State.ACTIVE) continue;
                missing.remove(it.getId());
                failed.add(it);
            }
            BulkItemResponse[] bulkItemResponseArray = response2.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)bulkItemResponseArray, (String)"response.items");
            $this$forEach$iv = bulkItemResponseArray;
            $i$f$forEach = false;
            BulkItemResponse[] bulkItemResponseArray2 = $this$forEach$iv;
            int n = bulkItemResponseArray2.length;
            for (int i = 0; i < n; ++i) {
                BulkItemResponse element$iv;
                BulkItemResponse item = element$iv = bulkItemResponseArray2[i];
                boolean bl4 = false;
                BulkItemResponse bulkItemResponse = item;
                Intrinsics.checkExpressionValueIsNotNull((Object)bulkItemResponse, (String)"item");
                missing.remove(bulkItemResponse.getId());
                if (item.isFailed()) {
                    Alert alert = this.alerts.get(item.getId());
                    if (alert == null) {
                        Intrinsics.throwNpe();
                    }
                    failed.add(alert);
                    continue;
                }
                Alert alert = this.alerts.get(item.getId());
                if (alert == null) {
                    Intrinsics.throwNpe();
                }
                acknowledged.add(alert);
            }
            this.actionListener.onResponse((Object)new AcknowledgeAlertResponse(CollectionsKt.toList((Iterable)acknowledged), CollectionsKt.toList((Iterable)failed), CollectionsKt.toList((Iterable)missing)));
        }

        public AcknowledgeHandler(@NotNull Client client, @NotNull ActionListener<AcknowledgeAlertResponse> actionListener, AcknowledgeAlertRequest request) {
            Map map;
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
            Intrinsics.checkParameterIsNotNull((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            AcknowledgeHandler acknowledgeHandler = this;
            boolean bl = false;
            acknowledgeHandler.alerts = map = (Map)new LinkedHashMap();
        }

        public static final /* synthetic */ void access$onSearchResponse(AcknowledgeHandler $this, SearchResponse response2) {
            $this.onSearchResponse(response2);
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(AcknowledgeHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ void access$onBulkResponse(AcknowledgeHandler $this, BulkResponse response2) {
            $this.onBulkResponse(response2);
        }
    }
}

