/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.settings;

import com.amazon.opendistroforelasticsearch.alerting.settings.DestinationSettings;
import com.amazon.opendistroforelasticsearch.alerting.util.DestinationType;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/settings/DestinationSettings;", "", "()V", "Companion", "opendistro-alerting"})
public final class DestinationSettings {
    @NotNull
    public static final String DESTINATION_SETTING_PREFIX = "opendistro.alerting.destination.";
    @NotNull
    public static final String EMAIL_DESTINATION_SETTING_PREFIX = "opendistro.alerting.destination.email.";
    @NotNull
    private static final List<String> ALLOW_LIST_ALL;
    @NotNull
    private static final List<String> ALLOW_LIST_NONE;
    @NotNull
    private static final Setting<List<String>> ALLOW_LIST;
    @NotNull
    private static final Setting.AffixSetting<SecureString> EMAIL_USERNAME;
    @NotNull
    private static final Setting.AffixSetting<SecureString> EMAIL_PASSWORD;
    @NotNull
    private static final Setting<List<String>> HOST_DENY_LIST;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$map$iv = ArraysKt.toList((Object[])DestinationType.values());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DestinationType destinationType = (DestinationType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getValue();
            collection.add(string);
        }
        ALLOW_LIST_ALL = (List)var3_3;
        ALLOW_LIST_NONE = CollectionsKt.emptyList();
        Setting setting = Setting.listSetting((String)"opendistro.alerting.destination.allow_list", ALLOW_LIST_ALL, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        Intrinsics.checkExpressionValueIsNotNull((Object)setting, (String)"Setting.listSetting(\n   \u2026roperty.Dynamic\n        )");
        ALLOW_LIST = setting;
        Setting.AffixSetting affixSetting = Setting.affixKeySetting((String)EMAIL_DESTINATION_SETTING_PREFIX, (String)"username", (Function)Companion.EMAIL_USERNAME.1.INSTANCE, (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)affixSetting, (String)"Setting.affixKeySetting(\u2026ng(key, null) }\n        )");
        EMAIL_USERNAME = affixSetting;
        Setting.AffixSetting affixSetting2 = Setting.affixKeySetting((String)EMAIL_DESTINATION_SETTING_PREFIX, (String)"password", (Function)Companion.EMAIL_PASSWORD.1.INSTANCE, (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)affixSetting2, (String)"Setting.affixKeySetting(\u2026ng(key, null) }\n        )");
        EMAIL_PASSWORD = affixSetting2;
        Setting setting2 = Setting.listSetting((String)"opendistro.destination.host.deny_list", (List)CollectionsKt.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final});
        Intrinsics.checkExpressionValueIsNotNull((Object)setting2, (String)"Setting.listSetting(\n   \u2026.Property.Final\n        )");
        HOST_DENY_LIST = setting2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u0011H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020!0#2\u0006\u0010\u001b\u001a\u00020\u001cR\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u001d\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\b\u00a8\u0006%"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/settings/DestinationSettings$Companion;", "", "()V", "ALLOW_LIST", "Lorg/elasticsearch/common/settings/Setting;", "", "", "getALLOW_LIST", "()Lorg/elasticsearch/common/settings/Setting;", "ALLOW_LIST_ALL", "getALLOW_LIST_ALL", "()Ljava/util/List;", "ALLOW_LIST_NONE", "getALLOW_LIST_NONE", "DESTINATION_SETTING_PREFIX", "EMAIL_DESTINATION_SETTING_PREFIX", "EMAIL_PASSWORD", "Lorg/elasticsearch/common/settings/Setting$AffixSetting;", "Lorg/elasticsearch/common/settings/SecureString;", "getEMAIL_PASSWORD", "()Lorg/elasticsearch/common/settings/Setting$AffixSetting;", "EMAIL_USERNAME", "getEMAIL_USERNAME", "HOST_DENY_LIST", "getHOST_DENY_LIST", "getEmailSettingValue", "T", "settings", "Lorg/elasticsearch/common/settings/Settings;", "emailAccountName", "emailSetting", "(Lorg/elasticsearch/common/settings/Settings;Ljava/lang/String;Lorg/elasticsearch/common/settings/Setting$AffixSetting;)Ljava/lang/Object;", "getSecureDestinationSettings", "Lcom/amazon/opendistroforelasticsearch/alerting/settings/DestinationSettings$Companion$SecureDestinationSettings;", "loadDestinationSettings", "", "SecureDestinationSettings", "opendistro-alerting"})
    public static final class Companion {
        @NotNull
        public final List<String> getALLOW_LIST_ALL() {
            return ALLOW_LIST_ALL;
        }

        @NotNull
        public final List<String> getALLOW_LIST_NONE() {
            return ALLOW_LIST_NONE;
        }

        @NotNull
        public final Setting<List<String>> getALLOW_LIST() {
            return ALLOW_LIST;
        }

        @NotNull
        public final Setting.AffixSetting<SecureString> getEMAIL_USERNAME() {
            return EMAIL_USERNAME;
        }

        @NotNull
        public final Setting.AffixSetting<SecureString> getEMAIL_PASSWORD() {
            return EMAIL_PASSWORD;
        }

        @NotNull
        public final Setting<List<String>> getHOST_DENY_LIST() {
            return HOST_DENY_LIST;
        }

        @NotNull
        public final Map<String, SecureDestinationSettings> loadDestinationSettings(@NotNull Settings settings) {
            Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
            Set emailAccountNames = settings.getGroups(DestinationSettings.EMAIL_DESTINATION_SETTING_PREFIX).keySet();
            boolean bl = false;
            Map emailAccounts = new LinkedHashMap();
            for (String emailAccountName : emailAccountNames) {
                SecureDestinationSettings secureDestinationSettings;
                if (this.getSecureDestinationSettings(settings, emailAccountName) == null) continue;
                boolean bl2 = false;
                boolean bl3 = false;
                SecureDestinationSettings it = secureDestinationSettings;
                boolean bl4 = false;
                emailAccounts.put(emailAccountName, it);
            }
            return emailAccounts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final SecureDestinationSettings getSecureDestinationSettings(Settings settings, String emailAccountName) {
            SecureDestinationSettings secureDestinationSettings;
            SecureString secureString = this.getEmailSettingValue(settings, emailAccountName, this.getEMAIL_USERNAME());
            if (secureString != null) {
                Closeable closeable = (Closeable)secureString;
                boolean bl = false;
                Throwable throwable = null;
                try {
                    SecureDestinationSettings secureDestinationSettings2;
                    SecureString emailUsername = (SecureString)closeable;
                    boolean bl2 = false;
                    SecureString secureString2 = Companion.getEmailSettingValue(settings, emailAccountName, Companion.getEMAIL_PASSWORD());
                    if (secureString2 != null) {
                        Closeable closeable2 = (Closeable)secureString2;
                        boolean bl3 = false;
                        Throwable throwable2 = null;
                        try {
                            SecureString emailPassword = (SecureString)closeable2;
                            boolean bl4 = false;
                            SecureString secureString3 = emailUsername.clone();
                            Intrinsics.checkExpressionValueIsNotNull((Object)secureString3, (String)"emailUsername.clone()");
                            SecureString secureString4 = emailPassword.clone();
                            Intrinsics.checkExpressionValueIsNotNull((Object)secureString4, (String)"emailPassword.clone()");
                            SecureDestinationSettings secureDestinationSettings3 = new SecureDestinationSettings(secureString3, secureString4);
                            secureDestinationSettings2 = secureDestinationSettings3;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                    } else {
                        secureDestinationSettings2 = null;
                    }
                    SecureDestinationSettings secureDestinationSettings4 = secureDestinationSettings2;
                    secureDestinationSettings = secureDestinationSettings4;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                secureDestinationSettings = null;
            }
            return secureDestinationSettings;
        }

        private final <T> T getEmailSettingValue(Settings settings, String emailAccountName, Setting.AffixSetting<T> emailSetting) {
            Setting concreteSetting = emailSetting.getConcreteSettingForNamespace(emailAccountName);
            return (T)concreteSetting.get(settings);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/settings/DestinationSettings$Companion$SecureDestinationSettings;", "", "emailUsername", "Lorg/elasticsearch/common/settings/SecureString;", "emailPassword", "(Lorg/elasticsearch/common/settings/SecureString;Lorg/elasticsearch/common/settings/SecureString;)V", "getEmailPassword", "()Lorg/elasticsearch/common/settings/SecureString;", "getEmailUsername", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "opendistro-alerting"})
        public static final class SecureDestinationSettings {
            @NotNull
            private final SecureString emailUsername;
            @NotNull
            private final SecureString emailPassword;

            @NotNull
            public final SecureString getEmailUsername() {
                return this.emailUsername;
            }

            @NotNull
            public final SecureString getEmailPassword() {
                return this.emailPassword;
            }

            public SecureDestinationSettings(@NotNull SecureString emailUsername, @NotNull SecureString emailPassword) {
                Intrinsics.checkParameterIsNotNull((Object)emailUsername, (String)"emailUsername");
                Intrinsics.checkParameterIsNotNull((Object)emailPassword, (String)"emailPassword");
                this.emailUsername = emailUsername;
                this.emailPassword = emailPassword;
            }

            @NotNull
            public final SecureString component1() {
                return this.emailUsername;
            }

            @NotNull
            public final SecureString component2() {
                return this.emailPassword;
            }

            @NotNull
            public final SecureDestinationSettings copy(@NotNull SecureString emailUsername, @NotNull SecureString emailPassword) {
                Intrinsics.checkParameterIsNotNull((Object)emailUsername, (String)"emailUsername");
                Intrinsics.checkParameterIsNotNull((Object)emailPassword, (String)"emailPassword");
                return new SecureDestinationSettings(emailUsername, emailPassword);
            }

            public static /* synthetic */ SecureDestinationSettings copy$default(SecureDestinationSettings secureDestinationSettings, SecureString secureString, SecureString secureString2, int n, Object object) {
                if ((n & 1) != 0) {
                    secureString = secureDestinationSettings.emailUsername;
                }
                if ((n & 2) != 0) {
                    secureString2 = secureDestinationSettings.emailPassword;
                }
                return secureDestinationSettings.copy(secureString, secureString2);
            }

            @NotNull
            public String toString() {
                return "SecureDestinationSettings(emailUsername=" + this.emailUsername + ", emailPassword=" + this.emailPassword + ")";
            }

            public int hashCode() {
                SecureString secureString = this.emailUsername;
                SecureString secureString2 = this.emailPassword;
                return (secureString != null ? secureString.hashCode() : 0) * 31 + (secureString2 != null ? secureString2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof SecureDestinationSettings)) break block3;
                        SecureDestinationSettings secureDestinationSettings = (SecureDestinationSettings)object;
                        if (!Intrinsics.areEqual((Object)this.emailUsername, (Object)secureDestinationSettings.emailUsername) || !Intrinsics.areEqual((Object)this.emailPassword, (Object)secureDestinationSettings.emailPassword)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

