/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.resthandler;

import com.amazon.opendistroforelasticsearch.alerting.AlertingPlugin;
import com.amazon.opendistroforelasticsearch.alerting.action.SearchMonitorAction;
import com.amazon.opendistroforelasticsearch.alerting.action.SearchMonitorRequest;
import com.amazon.opendistroforelasticsearch.alerting.core.model.ScheduledJob;
import com.amazon.opendistroforelasticsearch.alerting.resthandler.RestSearchMonitorActionKt;
import com.amazon.opendistroforelasticsearch.alerting.settings.AlertingSettings;
import com.amazon.opendistroforelasticsearch.alerting.util.RestHandlerUtilsKt;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/resthandler/RestSearchMonitorAction;", "Lorg/elasticsearch/rest/BaseRestHandler;", "settings", "Lorg/elasticsearch/common/settings/Settings;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "(Lorg/elasticsearch/common/settings/Settings;Lorg/elasticsearch/cluster/service/ClusterService;)V", "filterBy", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "getSettings", "()Lorg/elasticsearch/common/settings/Settings;", "getName", "", "prepareRequest", "Lorg/elasticsearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/elasticsearch/rest/RestRequest;", "client", "Lorg/elasticsearch/client/node/NodeClient;", "routes", "", "Lorg/elasticsearch/rest/RestHandler$Route;", "searchMonitorResponse", "Lorg/elasticsearch/rest/action/RestResponseListener;", "Lorg/elasticsearch/action/search/SearchResponse;", "channel", "Lorg/elasticsearch/rest/RestChannel;", "opendistro-alerting"})
public final class RestSearchMonitorAction
extends BaseRestHandler {
    private volatile Boolean filterBy;
    @NotNull
    private final Settings settings;

    @NotNull
    public String getName() {
        return "search_monitor_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object[])new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.POST, AlertingPlugin.MONITOR_BASE_URI + "/_search"), new RestHandler.Route(RestRequest.Method.GET, AlertingPlugin.MONITOR_BASE_URI + "/_search")});
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        SearchRequest searchRequest;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        RestSearchMonitorActionKt.access$getLog$p().debug(request.method() + ' ' + AlertingPlugin.MONITOR_BASE_URI + "/_search");
        String index = request.param("index", ".opendistro-alerting-config");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        searchSourceBuilder.fetchSource(RestHandlerUtilsKt.context(request));
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must(searchSourceBuilder.query());
        searchSourceBuilder.query((QueryBuilder)queryBuilder).seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true));
        SearchRequest searchRequest2 = searchRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{index});
        Intrinsics.checkExpressionValueIsNotNull((Object)searchRequest2, (String)"searchRequest");
        SearchMonitorRequest searchMonitorRequest = new SearchMonitorRequest(searchRequest2);
        return new BaseRestHandler.RestChannelConsumer(this, client, searchMonitorRequest){
            final /* synthetic */ RestSearchMonitorAction this$0;
            final /* synthetic */ NodeClient $client;
            final /* synthetic */ SearchMonitorRequest $searchMonitorRequest;

            public final void accept(RestChannel channel) {
                ActionType actionType = SearchMonitorAction.Companion.getINSTANCE();
                ActionRequest actionRequest = this.$searchMonitorRequest;
                RestChannel restChannel = channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)restChannel, (String)"channel");
                this.$client.execute(actionType, actionRequest, (ActionListener)RestSearchMonitorAction.access$searchMonitorResponse(this.this$0, restChannel));
            }
            {
                this.this$0 = restSearchMonitorAction;
                this.$client = nodeClient;
                this.$searchMonitorRequest = searchMonitorRequest;
            }
        };
    }

    private final RestResponseListener<SearchResponse> searchMonitorResponse(RestChannel channel) {
        return (RestResponseListener)new RestResponseListener<SearchResponse>(channel, channel){
            final /* synthetic */ RestChannel $channel;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public RestResponse buildResponse(@NotNull SearchResponse response2) throws Exception {
                Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                if (response2.isTimedOut()) {
                    return (RestResponse)new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, response2.toString());
                }
                try {
                    for (SearchHit hit : response2.getHits()) {
                        XContent xContent = XContentType.JSON.xContent();
                        RestRequest restRequest = this.$channel.request();
                        Intrinsics.checkExpressionValueIsNotNull((Object)restRequest, (String)"channel.request()");
                        NamedXContentRegistry namedXContentRegistry = restRequest.getXContentRegistry();
                        DeprecationHandler deprecationHandler = (DeprecationHandler)LoggingDeprecationHandler.INSTANCE;
                        SearchHit searchHit = hit;
                        Intrinsics.checkExpressionValueIsNotNull((Object)searchHit, (String)"hit");
                        Closeable closeable = (Closeable)xContent.createParser(namedXContentRegistry, deprecationHandler, searchHit.getSourceAsString());
                        boolean bl = false;
                        Throwable throwable = null;
                        try {
                            XContentParser hitsParser = (XContentParser)closeable;
                            boolean bl2 = false;
                            XContentParser xContentParser = hitsParser;
                            Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"hitsParser");
                            String string = hit.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hit.id");
                            ScheduledJob monitor = ScheduledJob.Companion.parse(xContentParser, string, hit.getVersion());
                            XContentBuilder xcb = monitor.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS);
                            SearchHit searchHit2 = hit.sourceRef(BytesReference.bytes((XContentBuilder)xcb));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                }
                catch (Exception e) {
                    RestSearchMonitorActionKt.access$getLog$p().info("The monitor parsing failed. Will return response as is.");
                }
                return (RestResponse)new BytesRestResponse(RestStatus.OK, response2.toXContent(this.$channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
            {
                this.$channel = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    public RestSearchMonitorAction(@NotNull Settings settings, @NotNull ClusterService clusterService) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        this.settings = settings;
        this.filterBy = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES(), (Consumer)new Consumer<Boolean>(){

            @Override
            public final void accept(Boolean it) {
                filterBy = it;
            }
        });
    }

    public static final /* synthetic */ RestResponseListener access$searchMonitorResponse(RestSearchMonitorAction $this, RestChannel channel) {
        return $this.searchMonitorResponse(channel);
    }

    public static final /* synthetic */ Boolean access$getFilterBy$p(RestSearchMonitorAction $this) {
        return $this.filterBy;
    }
}

