/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.resthandler;

import com.amazon.opendistroforelasticsearch.alerting.AlertingPlugin;
import com.amazon.opendistroforelasticsearch.alerting.action.SearchEmailGroupAction;
import com.amazon.opendistroforelasticsearch.alerting.model.destination.email.EmailGroup;
import com.amazon.opendistroforelasticsearch.alerting.util.RestHandlerUtilsKt;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/resthandler/RestSearchEmailGroupAction;", "Lorg/elasticsearch/rest/BaseRestHandler;", "()V", "getName", "", "prepareRequest", "Lorg/elasticsearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/elasticsearch/rest/RestRequest;", "client", "Lorg/elasticsearch/client/node/NodeClient;", "routes", "", "Lorg/elasticsearch/rest/RestHandler$Route;", "searchEmailGroupResponse", "Lorg/elasticsearch/rest/action/RestResponseListener;", "Lorg/elasticsearch/action/search/SearchResponse;", "channel", "Lorg/elasticsearch/rest/RestChannel;", "opendistro-alerting"})
public final class RestSearchEmailGroupAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "search_email_group_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object[])new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.POST, AlertingPlugin.EMAIL_GROUP_BASE_URI + "/_search"), new RestHandler.Route(RestRequest.Method.GET, AlertingPlugin.EMAIL_GROUP_BASE_URI + "/_search")});
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        searchSourceBuilder.fetchSource(RestHandlerUtilsKt.context(request));
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter((QueryBuilder)QueryBuilders.existsQuery((String)"email_group"))).seqNoAndPrimaryTerm(Boolean.valueOf(true));
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{".opendistro-alerting-config"});
        return new BaseRestHandler.RestChannelConsumer(this, client, searchRequest){
            final /* synthetic */ RestSearchEmailGroupAction this$0;
            final /* synthetic */ NodeClient $client;
            final /* synthetic */ SearchRequest $searchRequest;

            public final void accept(RestChannel channel) {
                ActionType actionType = SearchEmailGroupAction.Companion.getINSTANCE();
                ActionRequest actionRequest = (ActionRequest)this.$searchRequest;
                RestChannel restChannel = channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)restChannel, (String)"channel");
                this.$client.execute(actionType, actionRequest, (ActionListener)RestSearchEmailGroupAction.access$searchEmailGroupResponse(this.this$0, restChannel));
            }
            {
                this.this$0 = restSearchEmailGroupAction;
                this.$client = nodeClient;
                this.$searchRequest = searchRequest;
            }
        };
    }

    private final RestResponseListener<SearchResponse> searchEmailGroupResponse(RestChannel channel) {
        return (RestResponseListener)new RestResponseListener<SearchResponse>(channel, channel){
            final /* synthetic */ RestChannel $channel;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public RestResponse buildResponse(@NotNull SearchResponse response2) throws Exception {
                Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
                if (response2.isTimedOut()) {
                    return (RestResponse)new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, response2.toString());
                }
                for (SearchHit hit : response2.getHits()) {
                    XContent xContent = XContentType.JSON.xContent();
                    RestRequest restRequest = this.$channel.request();
                    Intrinsics.checkExpressionValueIsNotNull((Object)restRequest, (String)"channel.request()");
                    NamedXContentRegistry namedXContentRegistry = restRequest.getXContentRegistry();
                    DeprecationHandler deprecationHandler = (DeprecationHandler)LoggingDeprecationHandler.INSTANCE;
                    SearchHit searchHit = hit;
                    Intrinsics.checkExpressionValueIsNotNull((Object)searchHit, (String)"hit");
                    Closeable closeable = (Closeable)xContent.createParser(namedXContentRegistry, deprecationHandler, searchHit.getSourceAsString());
                    boolean bl = false;
                    Throwable throwable = null;
                    try {
                        XContentParser hitsParser = (XContentParser)closeable;
                        boolean bl2 = false;
                        XContentParser xContentParser = hitsParser;
                        Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"hitsParser");
                        String string = hit.getId();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hit.id");
                        EmailGroup emailGroup = EmailGroup.Companion.parseWithType(xContentParser, string, hit.getVersion());
                        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
                        Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"XContentFactory.jsonBuilder()");
                        ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                        Intrinsics.checkExpressionValueIsNotNull((Object)params, (String)"ToXContent.EMPTY_PARAMS");
                        XContentBuilder xcb = emailGroup.toXContent(xContentBuilder, params);
                        SearchHit searchHit2 = hit.sourceRef(BytesReference.bytes((XContentBuilder)xcb));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                return (RestResponse)new BytesRestResponse(RestStatus.OK, response2.toXContent(this.$channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
            {
                this.$channel = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }

    public static final /* synthetic */ RestResponseListener access$searchEmailGroupResponse(RestSearchEmailGroupAction $this, RestChannel channel) {
        return $this.searchEmailGroupResponse(channel);
    }
}

