/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.resthandler;

import com.amazon.opendistroforelasticsearch.alerting.AlertingPlugin;
import com.amazon.opendistroforelasticsearch.alerting.action.IndexDestinationAction;
import com.amazon.opendistroforelasticsearch.alerting.action.IndexDestinationRequest;
import com.amazon.opendistroforelasticsearch.alerting.action.IndexDestinationResponse;
import com.amazon.opendistroforelasticsearch.alerting.model.destination.Destination;
import com.amazon.opendistroforelasticsearch.alerting.resthandler.RestIndexDestinationActionKt;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestResponseListener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/resthandler/RestIndexDestinationAction;", "Lorg/elasticsearch/rest/BaseRestHandler;", "()V", "getName", "", "indexDestinationResponse", "Lorg/elasticsearch/rest/action/RestResponseListener;", "Lcom/amazon/opendistroforelasticsearch/alerting/action/IndexDestinationResponse;", "channel", "Lorg/elasticsearch/rest/RestChannel;", "restMethod", "Lorg/elasticsearch/rest/RestRequest$Method;", "prepareRequest", "Lorg/elasticsearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/elasticsearch/rest/RestRequest;", "client", "Lorg/elasticsearch/client/node/NodeClient;", "routes", "", "Lorg/elasticsearch/rest/RestHandler$Route;", "opendistro-alerting"})
public final class RestIndexDestinationAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "index_destination_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object[])new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.POST, AlertingPlugin.DESTINATION_BASE_URI), new RestHandler.Route(RestRequest.Method.PUT, AlertingPlugin.DESTINATION_BASE_URI + "/{destinationID}")});
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        WriteRequest.RefreshPolicy refreshPolicy;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        RestIndexDestinationActionKt.access$getLog$p().debug(request.method() + ' ' + AlertingPlugin.DESTINATION_BASE_URI);
        String id = request.param("destinationID", "");
        if (request.method() == RestRequest.Method.PUT && Intrinsics.areEqual((Object)"", (Object)id)) {
            throw (Throwable)new IllegalArgumentException("Missing destination ID");
        }
        XContentParser xcp = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParser xContentParser = xcp;
        Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"xcp");
        String string = id;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
        Destination destination = Destination.Companion.parse$default(Destination.Companion, xContentParser, string, 0L, 0, 0, 28, null);
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        WriteRequest.RefreshPolicy refreshPolicy2 = refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        Intrinsics.checkExpressionValueIsNotNull((Object)refreshPolicy2, (String)"refreshPolicy");
        RestRequest.Method method = request.method();
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"request.method()");
        IndexDestinationRequest indexDestinationRequest = new IndexDestinationRequest(id, seqNo, primaryTerm, refreshPolicy2, method, destination);
        return new BaseRestHandler.RestChannelConsumer(this, client, indexDestinationRequest, request){
            final /* synthetic */ RestIndexDestinationAction this$0;
            final /* synthetic */ NodeClient $client;
            final /* synthetic */ IndexDestinationRequest $indexDestinationRequest;
            final /* synthetic */ RestRequest $request;

            public final void accept(RestChannel channel) {
                ActionType actionType = IndexDestinationAction.Companion.getINSTANCE();
                ActionRequest actionRequest = this.$indexDestinationRequest;
                RestChannel restChannel = channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)restChannel, (String)"channel");
                RestRequest.Method method = this.$request.method();
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"request.method()");
                this.$client.execute(actionType, actionRequest, (ActionListener)RestIndexDestinationAction.access$indexDestinationResponse(this.this$0, restChannel, method));
            }
            {
                this.this$0 = restIndexDestinationAction;
                this.$client = nodeClient;
                this.$indexDestinationRequest = indexDestinationRequest;
                this.$request = restRequest;
            }
        };
    }

    private final RestResponseListener<IndexDestinationResponse> indexDestinationResponse(RestChannel channel, RestRequest.Method restMethod) {
        return (RestResponseListener)new RestResponseListener<IndexDestinationResponse>(restMethod, channel, channel){
            final /* synthetic */ RestRequest.Method $restMethod;
            final /* synthetic */ RestChannel $channel;

            @NotNull
            public RestResponse buildResponse(@NotNull IndexDestinationResponse response2) throws Exception {
                Intrinsics.checkParameterIsNotNull((Object)((Object)response2), (String)"response");
                RestStatus returnStatus = RestStatus.CREATED;
                if (this.$restMethod == RestRequest.Method.PUT) {
                    returnStatus = RestStatus.OK;
                }
                XContentBuilder xContentBuilder = this.$channel.newBuilder();
                Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"channel.newBuilder()");
                ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkExpressionValueIsNotNull((Object)params, (String)"ToXContent.EMPTY_PARAMS");
                BytesRestResponse restResponse = new BytesRestResponse(returnStatus, response2.toXContent(xContentBuilder, params));
                if (returnStatus == RestStatus.CREATED) {
                    String location = AlertingPlugin.DESTINATION_BASE_URI + '/' + response2.getId();
                    restResponse.addHeader("Location", location);
                }
                return (RestResponse)restResponse;
            }
            {
                this.$restMethod = $captured_local_variable$0;
                this.$channel = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    public static final /* synthetic */ RestResponseListener access$indexDestinationResponse(RestIndexDestinationAction $this, RestChannel channel, RestRequest.Method restMethod) {
        return $this.indexDestinationResponse(channel, restMethod);
    }
}

