/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.resthandler;

import com.amazon.opendistroforelasticsearch.alerting.AlertingPlugin;
import com.amazon.opendistroforelasticsearch.alerting.action.GetDestinationsAction;
import com.amazon.opendistroforelasticsearch.alerting.action.GetDestinationsRequest;
import com.amazon.opendistroforelasticsearch.alerting.model.Table;
import com.amazon.opendistroforelasticsearch.alerting.util.RestHandlerUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/resthandler/RestGetDestinationsAction;", "Lorg/elasticsearch/rest/BaseRestHandler;", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getName", "", "prepareRequest", "Lorg/elasticsearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/elasticsearch/rest/RestRequest;", "client", "Lorg/elasticsearch/client/node/NodeClient;", "routes", "", "Lorg/elasticsearch/rest/RestHandler$Route;", "opendistro-alerting"})
public final class RestGetDestinationsAction
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(RestGetDestinationsAction.class);

    @NotNull
    public String getName() {
        return "get_destinations_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object[])new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.GET, AlertingPlugin.DESTINATION_BASE_URI + "/{destinationID}"), new RestHandler.Route(RestRequest.Method.GET, String.valueOf(AlertingPlugin.DESTINATION_BASE_URI))});
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.log.debug(request.method() + ' ' + request.path());
        String destinationId = request.param("destinationID");
        FetchSourceContext srcContext = RestHandlerUtilsKt.context(request);
        if (request.method() == RestRequest.Method.HEAD) {
            srcContext = FetchSourceContext.DO_NOT_FETCH_SOURCE;
        }
        String sortString = request.param("sortString", "destination.name.keyword");
        String sortOrder = request.param("sortOrder", "asc");
        String missing = request.param("missing");
        int size = request.paramAsInt("size", 20);
        int startIndex = request.paramAsInt("startIndex", 0);
        String searchString = request.param("searchString", "");
        String destinationType = request.param("destinationType", "ALL");
        String string = sortOrder;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sortOrder");
        String string2 = sortString;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sortString");
        Table table = new Table(string, string2, missing, size, startIndex, searchString);
        long l = RestActions.parseVersion((RestRequest)request);
        String string3 = destinationType;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"destinationType");
        GetDestinationsRequest getDestinationsRequest = new GetDestinationsRequest(destinationId, l, srcContext, table, string3);
        return new BaseRestHandler.RestChannelConsumer(client, getDestinationsRequest){
            final /* synthetic */ NodeClient $client;
            final /* synthetic */ GetDestinationsRequest $getDestinationsRequest;

            public final void accept(RestChannel channel) {
                this.$client.execute((ActionType)GetDestinationsAction.Companion.getINSTANCE(), (ActionRequest)this.$getDestinationsRequest, (ActionListener)new RestToXContentListener(channel));
            }
            {
                this.$client = nodeClient;
                this.$getDestinationsRequest = getDestinationsRequest;
            }
        };
    }
}

