/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.resthandler;

import com.amazon.opendistroforelasticsearch.alerting.AlertingPlugin;
import com.amazon.opendistroforelasticsearch.alerting.action.GetAlertsAction;
import com.amazon.opendistroforelasticsearch.alerting.action.GetAlertsRequest;
import com.amazon.opendistroforelasticsearch.alerting.model.Table;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/resthandler/RestGetAlertsAction;", "Lorg/elasticsearch/rest/BaseRestHandler;", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getName", "", "prepareRequest", "Lorg/elasticsearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/elasticsearch/rest/RestRequest;", "client", "Lorg/elasticsearch/client/node/NodeClient;", "routes", "", "Lorg/elasticsearch/rest/RestHandler$Route;", "opendistro-alerting"})
public final class RestGetAlertsAction
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(RestGetAlertsAction.class);

    @NotNull
    public String getName() {
        return "get_alerts_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object)new RestHandler.Route(RestRequest.Method.GET, AlertingPlugin.MONITOR_BASE_URI + "/alerts"));
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.log.debug(request.method() + ' ' + AlertingPlugin.MONITOR_BASE_URI + "/alerts");
        String sortString = request.param("sortString", "monitor_name.keyword");
        String sortOrder = request.param("sortOrder", "asc");
        String missing = request.param("missing");
        int size = request.paramAsInt("size", 20);
        int startIndex = request.paramAsInt("startIndex", 0);
        String searchString = request.param("searchString", "");
        String severityLevel = request.param("severityLevel", "ALL");
        String alertState = request.param("alertState", "ALL");
        String monitorId = request.param("monitorId");
        String string = sortOrder;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sortOrder");
        String string2 = sortString;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sortString");
        Table table = new Table(string, string2, missing, size, startIndex, searchString);
        String string3 = severityLevel;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"severityLevel");
        String string4 = alertState;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"alertState");
        GetAlertsRequest getAlertsRequest = new GetAlertsRequest(table, string3, string4, monitorId);
        return new BaseRestHandler.RestChannelConsumer(client, getAlertsRequest){
            final /* synthetic */ NodeClient $client;
            final /* synthetic */ GetAlertsRequest $getAlertsRequest;

            public final void accept(RestChannel channel) {
                this.$client.execute((ActionType)GetAlertsAction.Companion.getINSTANCE(), (ActionRequest)this.$getAlertsRequest, (ActionListener)new RestToXContentListener(channel));
            }
            {
                this.$client = nodeClient;
                this.$getAlertsRequest = getAlertsRequest;
            }
        };
    }
}

