/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.resthandler;

import com.amazon.opendistroforelasticsearch.alerting.AlertingPlugin;
import com.amazon.opendistroforelasticsearch.alerting.action.ExecuteMonitorAction;
import com.amazon.opendistroforelasticsearch.alerting.action.ExecuteMonitorRequest;
import com.amazon.opendistroforelasticsearch.alerting.model.Monitor;
import com.amazon.opendistroforelasticsearch.alerting.resthandler.RestExecuteMonitorActionKt;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0014J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/resthandler/RestExecuteMonitorAction;", "Lorg/elasticsearch/rest/BaseRestHandler;", "()V", "getName", "", "prepareRequest", "Lorg/elasticsearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/elasticsearch/rest/RestRequest;", "client", "Lorg/elasticsearch/client/node/NodeClient;", "responseParams", "", "routes", "", "Lorg/elasticsearch/rest/RestHandler$Route;", "opendistro-alerting"})
public final class RestExecuteMonitorAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "execute_monitor_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object[])new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.POST, AlertingPlugin.MONITOR_BASE_URI + "/{monitorID}/_execute"), new RestHandler.Route(RestRequest.Method.POST, AlertingPlugin.MONITOR_BASE_URI + "/_execute")});
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        RestExecuteMonitorActionKt.access$getLog$p().debug(request.method() + ' ' + AlertingPlugin.MONITOR_BASE_URI + "/_execute");
        return new BaseRestHandler.RestChannelConsumer(request, client){
            final /* synthetic */ RestRequest $request;
            final /* synthetic */ NodeClient $client;

            public final void accept(RestChannel channel) {
                boolean dryrun = this.$request.paramAsBoolean("dryrun", false);
                TimeValue requestEnd = this.$request.paramAsTime("period_end", new TimeValue(Instant.now().toEpochMilli()));
                if (this.$request.hasParam("monitorID")) {
                    String monitorId = this.$request.param("monitorID");
                    TimeValue timeValue = requestEnd;
                    Intrinsics.checkExpressionValueIsNotNull((Object)timeValue, (String)"requestEnd");
                    ExecuteMonitorRequest execMonitorRequest = new ExecuteMonitorRequest(dryrun, timeValue, monitorId, null);
                    this.$client.execute((ActionType)ExecuteMonitorAction.Companion.getINSTANCE(), (ActionRequest)execMonitorRequest, (ActionListener)new RestToXContentListener(channel));
                } else {
                    XContentParser xcp = this.$request.contentParser();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                    XContentParser xContentParser = xcp;
                    Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"xcp");
                    Monitor monitor = Monitor.Companion.parse(xContentParser, "", 1L);
                    TimeValue timeValue = requestEnd;
                    Intrinsics.checkExpressionValueIsNotNull((Object)timeValue, (String)"requestEnd");
                    ExecuteMonitorRequest execMonitorRequest = new ExecuteMonitorRequest(dryrun, timeValue, null, monitor);
                    this.$client.execute((ActionType)ExecuteMonitorAction.Companion.getINSTANCE(), (ActionRequest)execMonitorRequest, (ActionListener)new RestToXContentListener(channel));
                }
            }
            {
                this.$request = restRequest;
                this.$client = nodeClient;
            }
        };
    }

    @NotNull
    protected Set<String> responseParams() {
        return SetsKt.setOf((Object[])new String[]{"dryrun", "period_end", "monitorID"});
    }
}

