/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.resthandler;

import com.amazon.opendistroforelasticsearch.alerting.AlertingPlugin;
import com.amazon.opendistroforelasticsearch.alerting.action.AcknowledgeAlertAction;
import com.amazon.opendistroforelasticsearch.alerting.action.AcknowledgeAlertRequest;
import com.amazon.opendistroforelasticsearch.alerting.resthandler.RestAcknowledgeAlertActionKt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/resthandler/RestAcknowledgeAlertAction;", "Lorg/elasticsearch/rest/BaseRestHandler;", "()V", "getAlertIds", "", "", "xcp", "Lorg/elasticsearch/common/xcontent/XContentParser;", "getName", "prepareRequest", "Lorg/elasticsearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/elasticsearch/rest/RestRequest;", "client", "Lorg/elasticsearch/client/node/NodeClient;", "routes", "Lorg/elasticsearch/rest/RestHandler$Route;", "opendistro-alerting"})
public final class RestAcknowledgeAlertAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "acknowledge_alert_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object)new RestHandler.Route(RestRequest.Method.POST, AlertingPlugin.MONITOR_BASE_URI + "/{monitorID}/_acknowledge/alerts"));
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        WriteRequest.RefreshPolicy refreshPolicy;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        RestAcknowledgeAlertActionKt.access$getLog$p().debug(request.method() + ' ' + AlertingPlugin.MONITOR_BASE_URI + "/{monitorID}/_acknowledge/alerts");
        String monitorId = request.param("monitorID");
        CharSequence charSequence = monitorId;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = !(charSequence == null || charSequence.length() == 0);
        bl = false;
        bl2 = false;
        if (!bl3) {
            boolean bl4 = false;
            String string = "Missing monitor id.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        XContentParser xContentParser = request.contentParser();
        Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"request.contentParser()");
        List<String> alertIds = this.getAlertIds(xContentParser);
        Collection collection = alertIds;
        bl2 = false;
        boolean bl5 = !collection.isEmpty();
        bl2 = false;
        boolean bl6 = false;
        if (!bl5) {
            boolean bl7 = false;
            String string = "You must provide at least one alert id.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        WriteRequest.RefreshPolicy refreshPolicy2 = refreshPolicy = WriteRequest.RefreshPolicy.parse((String)request.param("refresh", WriteRequest.RefreshPolicy.IMMEDIATE.getValue()));
        Intrinsics.checkExpressionValueIsNotNull((Object)refreshPolicy2, (String)"refreshPolicy");
        AcknowledgeAlertRequest acknowledgeAlertRequest = new AcknowledgeAlertRequest(monitorId, alertIds, refreshPolicy2);
        return new BaseRestHandler.RestChannelConsumer(client, acknowledgeAlertRequest){
            final /* synthetic */ NodeClient $client;
            final /* synthetic */ AcknowledgeAlertRequest $acknowledgeAlertRequest;

            public final void accept(RestChannel channel) {
                this.$client.execute((ActionType)AcknowledgeAlertAction.Companion.getINSTANCE(), (ActionRequest)this.$acknowledgeAlertRequest, (ActionListener)new RestToXContentListener(channel));
            }
            {
                this.$client = nodeClient;
                this.$acknowledgeAlertRequest = acknowledgeAlertRequest;
            }
        };
    }

    private final List<String> getAlertIds(XContentParser xcp) {
        boolean bl = false;
        List ids = new ArrayList();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String string;
            String fieldName = xcp.currentName();
            xcp.nextToken();
            if (fieldName == null) continue;
            switch (string.hashCode()) {
                case -1415077225: {
                    if (!string.equals("alerts")) break;
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        String string2 = xcp.text();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"xcp.text()");
                        ids.add(string2);
                    }
                    break;
                }
            }
        }
        return ids;
    }
}

