/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.model.destination;

import java.io.IOException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/model/destination/SNS;", "Lorg/elasticsearch/common/xcontent/ToXContent;", "topicARN", "", "roleARN", "(Ljava/lang/String;Ljava/lang/String;)V", "getRoleARN", "()Ljava/lang/String;", "getTopicARN", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/elasticsearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/elasticsearch/common/xcontent/ToXContent$Params;", "Companion", "opendistro-alerting"})
public final class SNS
implements ToXContent {
    @NotNull
    private final String topicARN;
    @NotNull
    private final String roleARN;
    private static final Pattern SNS_ARN_REGEX;
    private static final Pattern IAM_ARN_REGEX;
    @NotNull
    public static final String TOPIC_ARN_FIELD = "topic_arn";
    @NotNull
    public static final String ROLE_ARN_FIELD = "role_arn";
    @NotNull
    public static final String SNS_TYPE = "sns";
    public static final Companion Companion;

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        XContentBuilder xContentBuilder = builder.startObject(SNS_TYPE).field(TOPIC_ARN_FIELD, this.topicARN).field(ROLE_ARN_FIELD, this.roleARN).endObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"builder.startObject(SNS_\u2026             .endObject()");
        return xContentBuilder;
    }

    @NotNull
    public final String getTopicARN() {
        return this.topicARN;
    }

    @NotNull
    public final String getRoleARN() {
        return this.roleARN;
    }

    public SNS(@NotNull String topicARN, @NotNull String roleARN) {
        Intrinsics.checkParameterIsNotNull((Object)topicARN, (String)"topicARN");
        Intrinsics.checkParameterIsNotNull((Object)roleARN, (String)"roleARN");
        this.topicARN = topicARN;
        this.roleARN = roleARN;
        boolean bl = SNS_ARN_REGEX.matcher(this.topicARN).find();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid AWS SNS topic ARN: " + this.topicARN;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = IAM_ARN_REGEX.matcher(this.roleARN).find();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Invalid AWS role ARN: " + this.roleARN + ' ';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    static {
        Companion = new Companion(null);
        SNS_ARN_REGEX = Pattern.compile("^arn:aws(-[^:]+)?:sns:([a-zA-Z0-9-]+):([0-9]{12}):([a-zA-Z0-9-_]+)$");
        IAM_ARN_REGEX = Pattern.compile("^arn:aws(-[^:]+)?:iam::([0-9]{12}):([a-zA-Z0-9-/_]+)$");
    }

    @NotNull
    public final String component1() {
        return this.topicARN;
    }

    @NotNull
    public final String component2() {
        return this.roleARN;
    }

    @NotNull
    public final SNS copy(@NotNull String topicARN, @NotNull String roleARN) {
        Intrinsics.checkParameterIsNotNull((Object)topicARN, (String)"topicARN");
        Intrinsics.checkParameterIsNotNull((Object)roleARN, (String)"roleARN");
        return new SNS(topicARN, roleARN);
    }

    public static /* synthetic */ SNS copy$default(SNS sNS, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = sNS.topicARN;
        }
        if ((n & 2) != 0) {
            string2 = sNS.roleARN;
        }
        return sNS.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "SNS(topicARN=" + this.topicARN + ", roleARN=" + this.roleARN + ")";
    }

    public int hashCode() {
        String string = this.topicARN;
        String string2 = this.roleARN;
        return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SNS)) break block3;
                SNS sNS = (SNS)object;
                if (!Intrinsics.areEqual((Object)this.topicARN, (Object)sNS.topicARN) || !Intrinsics.areEqual((Object)this.roleARN, (Object)sNS.roleARN)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final SNS parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/model/destination/SNS$Companion;", "", "()V", "IAM_ARN_REGEX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "ROLE_ARN_FIELD", "", "SNS_ARN_REGEX", "SNS_TYPE", "TOPIC_ARN_FIELD", "parse", "Lcom/amazon/opendistroforelasticsearch/alerting/model/destination/SNS;", "xcp", "Lorg/elasticsearch/common/xcontent/XContentParser;", "opendistro-alerting"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @NotNull
        public final SNS parse(@NotNull XContentParser xcp) throws IOException {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)xcp, (String)"xcp");
            String topicARN = null;
            String roleARN = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block4: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String string2;
                String fieldName = xcp.currentName();
                xcp.nextToken();
                if (fieldName == null) throw (Throwable)new IllegalStateException("Unexpected field: " + fieldName + ", while parsing SNS destination");
                switch (string2.hashCode()) {
                    case -266273004: {
                        if (!string2.equals(SNS.ROLE_ARN_FIELD)) throw (Throwable)new IllegalStateException("Unexpected field: " + fieldName + ", while parsing SNS destination");
                        break;
                    }
                    case 388712269: {
                        if (!string2.equals(SNS.TOPIC_ARN_FIELD)) throw (Throwable)new IllegalStateException("Unexpected field: " + fieldName + ", while parsing SNS destination");
                        Intrinsics.checkExpressionValueIsNotNull((Object)xcp.textOrNull(), (String)"xcp.textOrNull()");
                        continue block4;
                    }
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)xcp.textOrNull(), (String)"xcp.textOrNull()");
                continue;
                throw (Throwable)new IllegalStateException("Unexpected field: " + fieldName + ", while parsing SNS destination");
            }
            String string3 = topicARN;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"topicARN");
            }
            String string4 = string3;
            boolean bl = false;
            boolean bl2 = false;
            if (string4 == null) {
                boolean bl3 = false;
                String string5 = "SNS Action topic_arn is null";
                throw (Throwable)new IllegalArgumentException(string5.toString());
            }
            String string6 = string4;
            String string7 = roleARN;
            if (string7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"roleARN");
            }
            string4 = string7;
            bl = false;
            bl2 = false;
            if (string4 == null) {
                boolean bl4 = false;
                String string8 = "SNS Action role_arn is null";
                throw (Throwable)new IllegalArgumentException(string8.toString());
            }
            String string9 = string = string4;
            String string10 = string6;
            return new SNS(string10, string9);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

