/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.model;

import com.amazon.opendistroforelasticsearch.alerting.alerts.AlertError;
import com.amazon.opendistroforelasticsearch.alerting.model.ActionRunResult;
import com.amazon.opendistroforelasticsearch.alerting.model.MonitorRunResultKt;
import java.io.IOException;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.script.ScriptException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B=\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f\u0012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\u0011\u0010\u001d\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\fH\u00c6\u0003J\u0015\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000eH\u00c6\u0003JE\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u0010\b\u0002\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000eH\u00c6\u0001J\u0013\u0010 \u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0007H\u00d6\u0001J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00060"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/model/TriggerRunResult;", "Lorg/elasticsearch/common/io/stream/Writeable;", "Lorg/elasticsearch/common/xcontent/ToXContent;", "sin", "Lorg/elasticsearch/common/io/stream/StreamInput;", "(Lorg/elasticsearch/common/io/stream/StreamInput;)V", "triggerName", "", "triggered", "", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "actionResults", "", "Lcom/amazon/opendistroforelasticsearch/alerting/model/ActionRunResult;", "(Ljava/lang/String;ZLjava/lang/Exception;Ljava/util/Map;)V", "getActionResults", "()Ljava/util/Map;", "getError", "()Ljava/lang/Exception;", "getTriggerName", "()Ljava/lang/String;", "getTriggered", "()Z", "alertError", "Lcom/amazon/opendistroforelasticsearch/alerting/alerts/AlertError;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/elasticsearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/elasticsearch/common/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/elasticsearch/common/io/stream/StreamOutput;", "Companion", "opendistro-alerting"})
public final class TriggerRunResult
implements Writeable,
ToXContent {
    @NotNull
    private final String triggerName;
    private final boolean triggered;
    @Nullable
    private final Exception error;
    @NotNull
    private final Map<String, ActionRunResult> actionResults;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        String msg;
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        Exception exception = this.error;
        String string = msg = exception != null ? exception.getMessage() : null;
        if (this.error instanceof ScriptException) {
            msg = ((ScriptException)this.error).toJsonString();
        }
        Map<String, ActionRunResult> map = this.actionResults;
        if (map == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, com.amazon.opendistroforelasticsearch.alerting.model.ActionRunResult>");
        }
        XContentBuilder xContentBuilder = builder.startObject().field("name", this.triggerName).field("triggered", this.triggered).field("error", msg).field("action_results", map).endObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026             .endObject()");
        return xContentBuilder;
    }

    @Nullable
    public final AlertError alertError() {
        if (this.error != null) {
            Instant instant = Instant.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
            return new AlertError(instant, "Failed evaluating trigger:\n" + MonitorRunResultKt.access$userErrorMessage(this.error));
        }
        for (ActionRunResult actionResult : this.actionResults.values()) {
            if (actionResult.getError() == null) continue;
            Instant instant = Instant.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
            return new AlertError(instant, "Failed running action:\n" + MonitorRunResultKt.access$userErrorMessage(actionResult.getError()));
        }
        return null;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        out.writeString(this.triggerName);
        out.writeBoolean(this.triggered);
        out.writeException((Throwable)this.error);
        Map<String, ActionRunResult> map = this.actionResults;
        if (map == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, com.amazon.opendistroforelasticsearch.alerting.model.ActionRunResult>");
        }
        out.writeMap(map);
    }

    @NotNull
    public final String getTriggerName() {
        return this.triggerName;
    }

    public final boolean getTriggered() {
        return this.triggered;
    }

    @Nullable
    public final Exception getError() {
        return this.error;
    }

    @NotNull
    public final Map<String, ActionRunResult> getActionResults() {
        return this.actionResults;
    }

    public TriggerRunResult(@NotNull String triggerName, boolean triggered, @Nullable Exception error, @NotNull Map<String, ActionRunResult> actionResults) {
        Intrinsics.checkParameterIsNotNull((Object)triggerName, (String)"triggerName");
        Intrinsics.checkParameterIsNotNull(actionResults, (String)"actionResults");
        this.triggerName = triggerName;
        this.triggered = triggered;
        this.error = error;
        this.actionResults = actionResults;
    }

    public /* synthetic */ TriggerRunResult(String string, boolean bl, Exception exception, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            exception = null;
        }
        if ((n & 8) != 0) {
            boolean bl2 = false;
            map = new LinkedHashMap();
        }
        this(string, bl, exception, map);
    }

    public TriggerRunResult(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sin.readString()");
        this(string, sin.readBoolean(), sin.readException(), Companion.suppressWarning(sin.readMap()));
    }

    @NotNull
    public final String component1() {
        return this.triggerName;
    }

    public final boolean component2() {
        return this.triggered;
    }

    @Nullable
    public final Exception component3() {
        return this.error;
    }

    @NotNull
    public final Map<String, ActionRunResult> component4() {
        return this.actionResults;
    }

    @NotNull
    public final TriggerRunResult copy(@NotNull String triggerName, boolean triggered, @Nullable Exception error, @NotNull Map<String, ActionRunResult> actionResults) {
        Intrinsics.checkParameterIsNotNull((Object)triggerName, (String)"triggerName");
        Intrinsics.checkParameterIsNotNull(actionResults, (String)"actionResults");
        return new TriggerRunResult(triggerName, triggered, error, actionResults);
    }

    public static /* synthetic */ TriggerRunResult copy$default(TriggerRunResult triggerRunResult, String string, boolean bl, Exception exception, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = triggerRunResult.triggerName;
        }
        if ((n & 2) != 0) {
            bl = triggerRunResult.triggered;
        }
        if ((n & 4) != 0) {
            exception = triggerRunResult.error;
        }
        if ((n & 8) != 0) {
            map = triggerRunResult.actionResults;
        }
        return triggerRunResult.copy(string, bl, exception, map);
    }

    @NotNull
    public String toString() {
        return "TriggerRunResult(triggerName=" + this.triggerName + ", triggered=" + this.triggered + ", error=" + this.error + ", actionResults=" + this.actionResults + ")";
    }

    public int hashCode() {
        String string = this.triggerName;
        int n = (string != null ? string.hashCode() : 0) * 31;
        int n2 = this.triggered ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        Exception exception = this.error;
        Map<String, ActionRunResult> map = this.actionResults;
        return ((n + n2) * 31 + (exception != null ? exception.hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TriggerRunResult)) break block3;
                TriggerRunResult triggerRunResult = (TriggerRunResult)object;
                if (!Intrinsics.areEqual((Object)this.triggerName, (Object)triggerRunResult.triggerName) || this.triggered != triggerRunResult.triggered || !Intrinsics.areEqual((Object)this.error, (Object)triggerRunResult.error) || !Intrinsics.areEqual(this.actionResults, triggerRunResult.actionResults)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final TriggerRunResult readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J,\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0018\u0010\u000b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\b\u00a8\u0006\f"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/model/TriggerRunResult$Companion;", "", "()V", "readFrom", "Lcom/amazon/opendistroforelasticsearch/alerting/model/TriggerRunResult;", "sin", "Lorg/elasticsearch/common/io/stream/StreamInput;", "suppressWarning", "", "", "Lcom/amazon/opendistroforelasticsearch/alerting/model/ActionRunResult;", "map", "opendistro-alerting"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final TriggerRunResult readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)sin, (String)"sin");
            return new TriggerRunResult(sin);
        }

        @NotNull
        public final Map<String, ActionRunResult> suppressWarning(@Nullable Map<String, Object> map) {
            Map<String, Object> map2 = map;
            if (map2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, com.amazon.opendistroforelasticsearch.alerting.model.ActionRunResult>");
            }
            return TypeIntrinsics.asMutableMap(map2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

