/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.model;

import com.amazon.opendistroforelasticsearch.alerting.alerts.AlertError;
import com.amazon.opendistroforelasticsearch.alerting.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.alerting.model.InputRunResults;
import com.amazon.opendistroforelasticsearch.alerting.model.MonitorRunResultKt;
import com.amazon.opendistroforelasticsearch.alerting.model.Trigger;
import com.amazon.opendistroforelasticsearch.alerting.model.TriggerRunResult;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ;2\u00020\u00012\u00020\u0002:\u0001;B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005BO\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0010\b\u0002\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u001f\u001a\u0004\u0018\u00010 J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\u0011\u0010$\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\rH\u00c6\u0003J\t\u0010%\u001a\u00020\u000fH\u00c6\u0003J\u0015\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0011H\u00c6\u0003JY\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\u0010\b\u0002\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0011H\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\u0016\u0010.\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r2\u0006\u0010/\u001a\u000200J\t\u00101\u001a\u00020\u0007H\u00d6\u0001J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016R\u0019\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006<"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/model/MonitorRunResult;", "Lorg/elasticsearch/common/io/stream/Writeable;", "Lorg/elasticsearch/common/xcontent/ToXContent;", "sin", "Lorg/elasticsearch/common/io/stream/StreamInput;", "(Lorg/elasticsearch/common/io/stream/StreamInput;)V", "monitorName", "", "periodStart", "Ljava/time/Instant;", "periodEnd", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "inputResults", "Lcom/amazon/opendistroforelasticsearch/alerting/model/InputRunResults;", "triggerResults", "", "Lcom/amazon/opendistroforelasticsearch/alerting/model/TriggerRunResult;", "(Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/Exception;Lcom/amazon/opendistroforelasticsearch/alerting/model/InputRunResults;Ljava/util/Map;)V", "getError", "()Ljava/lang/Exception;", "getInputResults", "()Lcom/amazon/opendistroforelasticsearch/alerting/model/InputRunResults;", "getMonitorName", "()Ljava/lang/String;", "getPeriodEnd", "()Ljava/time/Instant;", "getPeriodStart", "getTriggerResults", "()Ljava/util/Map;", "alertError", "Lcom/amazon/opendistroforelasticsearch/alerting/alerts/AlertError;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "scriptContextError", "trigger", "Lcom/amazon/opendistroforelasticsearch/alerting/model/Trigger;", "toString", "toXContent", "Lorg/elasticsearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/elasticsearch/common/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/elasticsearch/common/io/stream/StreamOutput;", "Companion", "opendistro-alerting"})
public final class MonitorRunResult
implements Writeable,
ToXContent {
    @NotNull
    private final String monitorName;
    @NotNull
    private final Instant periodStart;
    @NotNull
    private final Instant periodEnd;
    @Nullable
    private final Exception error;
    @NotNull
    private final InputRunResults inputResults;
    @NotNull
    private final Map<String, TriggerRunResult> triggerResults;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        XContentBuilder xContentBuilder = builder.startObject().field("monitor_name", this.monitorName);
        Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026nitor_name\", monitorName)");
        Exception exception = this.error;
        XContentBuilder xContentBuilder2 = ElasticExtensionsKt.optionalTimeField((XContentBuilder)ElasticExtensionsKt.optionalTimeField((XContentBuilder)xContentBuilder, (String)"period_start", (Instant)this.periodStart), (String)"period_end", (Instant)this.periodEnd).field("error", exception != null ? exception.getMessage() : null).field("input_results", (ToXContent)this.inputResults).field("trigger_results", this.triggerResults).endObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)xContentBuilder2, (String)"builder.startObject()\n  \u2026             .endObject()");
        return xContentBuilder2;
    }

    @Nullable
    public final AlertError alertError() {
        if (this.error != null) {
            Instant instant = Instant.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
            return new AlertError(instant, "Failed running monitor:\n" + MonitorRunResultKt.access$userErrorMessage(this.error));
        }
        if (this.inputResults.getError() != null) {
            Instant instant = Instant.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
            return new AlertError(instant, "Failed fetching inputs:\n" + MonitorRunResultKt.access$userErrorMessage(this.inputResults.getError()));
        }
        return null;
    }

    @Nullable
    public final Exception scriptContextError(@NotNull Trigger trigger) {
        Exception exception;
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        Exception exception2 = this.error;
        if (exception2 == null) {
            exception2 = exception = this.inputResults.getError();
        }
        if (exception2 == null) {
            TriggerRunResult triggerRunResult = this.triggerResults.get(trigger.getId());
            exception = triggerRunResult != null ? triggerRunResult.getError() : null;
        }
        return exception;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        out.writeString(this.monitorName);
        out.writeInstant(this.periodStart);
        out.writeInstant(this.periodEnd);
        out.writeException((Throwable)this.error);
        this.inputResults.writeTo(out);
        out.writeMap(this.triggerResults);
    }

    @NotNull
    public final String getMonitorName() {
        return this.monitorName;
    }

    @NotNull
    public final Instant getPeriodStart() {
        return this.periodStart;
    }

    @NotNull
    public final Instant getPeriodEnd() {
        return this.periodEnd;
    }

    @Nullable
    public final Exception getError() {
        return this.error;
    }

    @NotNull
    public final InputRunResults getInputResults() {
        return this.inputResults;
    }

    @NotNull
    public final Map<String, TriggerRunResult> getTriggerResults() {
        return this.triggerResults;
    }

    public MonitorRunResult(@NotNull String monitorName, @NotNull Instant periodStart, @NotNull Instant periodEnd, @Nullable Exception error, @NotNull InputRunResults inputResults, @NotNull Map<String, TriggerRunResult> triggerResults) {
        Intrinsics.checkParameterIsNotNull((Object)monitorName, (String)"monitorName");
        Intrinsics.checkParameterIsNotNull((Object)periodStart, (String)"periodStart");
        Intrinsics.checkParameterIsNotNull((Object)periodEnd, (String)"periodEnd");
        Intrinsics.checkParameterIsNotNull((Object)inputResults, (String)"inputResults");
        Intrinsics.checkParameterIsNotNull(triggerResults, (String)"triggerResults");
        this.monitorName = monitorName;
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.error = error;
        this.inputResults = inputResults;
        this.triggerResults = triggerResults;
    }

    public /* synthetic */ MonitorRunResult(String string, Instant instant, Instant instant2, Exception exception, InputRunResults inputRunResults, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            exception = null;
        }
        if ((n & 0x10) != 0) {
            inputRunResults = new InputRunResults(null, null, 3, null);
        }
        if ((n & 0x20) != 0) {
            boolean bl = false;
            map = MapsKt.emptyMap();
        }
        this(string, instant, instant2, exception, inputRunResults, map);
    }

    public MonitorRunResult(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sin.readString()");
        Instant instant = sin.readInstant();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"sin.readInstant()");
        Instant instant2 = sin.readInstant();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"sin.readInstant()");
        this(string, instant, instant2, sin.readException(), InputRunResults.Companion.readFrom(sin), Companion.suppressWarning(sin.readMap()));
    }

    @NotNull
    public final String component1() {
        return this.monitorName;
    }

    @NotNull
    public final Instant component2() {
        return this.periodStart;
    }

    @NotNull
    public final Instant component3() {
        return this.periodEnd;
    }

    @Nullable
    public final Exception component4() {
        return this.error;
    }

    @NotNull
    public final InputRunResults component5() {
        return this.inputResults;
    }

    @NotNull
    public final Map<String, TriggerRunResult> component6() {
        return this.triggerResults;
    }

    @NotNull
    public final MonitorRunResult copy(@NotNull String monitorName, @NotNull Instant periodStart, @NotNull Instant periodEnd, @Nullable Exception error, @NotNull InputRunResults inputResults, @NotNull Map<String, TriggerRunResult> triggerResults) {
        Intrinsics.checkParameterIsNotNull((Object)monitorName, (String)"monitorName");
        Intrinsics.checkParameterIsNotNull((Object)periodStart, (String)"periodStart");
        Intrinsics.checkParameterIsNotNull((Object)periodEnd, (String)"periodEnd");
        Intrinsics.checkParameterIsNotNull((Object)inputResults, (String)"inputResults");
        Intrinsics.checkParameterIsNotNull(triggerResults, (String)"triggerResults");
        return new MonitorRunResult(monitorName, periodStart, periodEnd, error, inputResults, triggerResults);
    }

    public static /* synthetic */ MonitorRunResult copy$default(MonitorRunResult monitorRunResult, String string, Instant instant, Instant instant2, Exception exception, InputRunResults inputRunResults, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = monitorRunResult.monitorName;
        }
        if ((n & 2) != 0) {
            instant = monitorRunResult.periodStart;
        }
        if ((n & 4) != 0) {
            instant2 = monitorRunResult.periodEnd;
        }
        if ((n & 8) != 0) {
            exception = monitorRunResult.error;
        }
        if ((n & 0x10) != 0) {
            inputRunResults = monitorRunResult.inputResults;
        }
        if ((n & 0x20) != 0) {
            map = monitorRunResult.triggerResults;
        }
        return monitorRunResult.copy(string, instant, instant2, exception, inputRunResults, map);
    }

    @NotNull
    public String toString() {
        return "MonitorRunResult(monitorName=" + this.monitorName + ", periodStart=" + this.periodStart + ", periodEnd=" + this.periodEnd + ", error=" + this.error + ", inputResults=" + this.inputResults + ", triggerResults=" + this.triggerResults + ")";
    }

    public int hashCode() {
        String string = this.monitorName;
        Instant instant = this.periodStart;
        Instant instant2 = this.periodEnd;
        Exception exception = this.error;
        InputRunResults inputRunResults = this.inputResults;
        Map<String, TriggerRunResult> map = this.triggerResults;
        return (((((string != null ? string.hashCode() : 0) * 31 + (instant != null ? ((Object)instant).hashCode() : 0)) * 31 + (instant2 != null ? ((Object)instant2).hashCode() : 0)) * 31 + (exception != null ? exception.hashCode() : 0)) * 31 + (inputRunResults != null ? ((Object)inputRunResults).hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof MonitorRunResult)) break block3;
                MonitorRunResult monitorRunResult = (MonitorRunResult)object;
                if (!Intrinsics.areEqual((Object)this.monitorName, (Object)monitorRunResult.monitorName) || !Intrinsics.areEqual((Object)this.periodStart, (Object)monitorRunResult.periodStart) || !Intrinsics.areEqual((Object)this.periodEnd, (Object)monitorRunResult.periodEnd) || !Intrinsics.areEqual((Object)this.error, (Object)monitorRunResult.error) || !Intrinsics.areEqual((Object)this.inputResults, (Object)monitorRunResult.inputResults) || !Intrinsics.areEqual(this.triggerResults, monitorRunResult.triggerResults)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final MonitorRunResult readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J,\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0018\u0010\u000b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\f\u00a8\u0006\r"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/model/MonitorRunResult$Companion;", "", "()V", "readFrom", "Lcom/amazon/opendistroforelasticsearch/alerting/model/MonitorRunResult;", "sin", "Lorg/elasticsearch/common/io/stream/StreamInput;", "suppressWarning", "", "", "Lcom/amazon/opendistroforelasticsearch/alerting/model/TriggerRunResult;", "map", "", "opendistro-alerting"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final MonitorRunResult readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)sin, (String)"sin");
            return new MonitorRunResult(sin);
        }

        @NotNull
        public final Map<String, TriggerRunResult> suppressWarning(@Nullable Map<String, Object> map) {
            Map<String, Object> map2 = map;
            if (map2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, com.amazon.opendistroforelasticsearch.alerting.model.TriggerRunResult>");
            }
            return map2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

