/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.alerts;

import com.amazon.opendistroforelasticsearch.alerting.alerts.AlertIndices;
import com.amazon.opendistroforelasticsearch.alerting.elasticapi.ElasticExtensionsKt;
import com.amazon.opendistroforelasticsearch.alerting.settings.AlertingSettings;
import com.amazon.opendistroforelasticsearch.alerting.util.IndexUtils;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexNotFoundException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\u0018\u0000 :2\u00020\u0001:\u0001:B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J%\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010'H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J\u0011\u0010*\u001a\u00020\"H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\u0011\u0010,\u001a\u00020\"H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\b\u0010-\u001a\u00020\"H\u0002J\b\u0010.\u001a\u00020'H\u0002J\u0006\u0010/\u001a\u00020\fJ\u0006\u00100\u001a\u00020\fJ\u0006\u00101\u001a\u00020\"J\u0006\u00102\u001a\u00020\"J\b\u00103\u001a\u00020\"H\u0002J\b\u00104\u001a\u00020\"H\u0002J\b\u00105\u001a\u00020\fH\u0002J\u0018\u00106\u001a\u00020\"2\u0006\u0010&\u001a\u00020'2\u0006\u00107\u001a\u00020'H\u0002J#\u00108\u001a\u00020\"2\u0006\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020\fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00109R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\f0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\n \u000e*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0016\u0010\u0016\u001a\n \u000e*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u000e*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\n \u000e*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006;"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/alerts/AlertIndices;", "Lorg/elasticsearch/cluster/ClusterStateListener;", "settings", "Lorg/elasticsearch/common/settings/Settings;", "client", "Lorg/elasticsearch/client/Client;", "threadPool", "Lorg/elasticsearch/threadpool/ThreadPool;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "(Lorg/elasticsearch/common/settings/Settings;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/threadpool/ThreadPool;Lorg/elasticsearch/cluster/service/ClusterService;)V", "alertIndexInitialized", "", "historyEnabled", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "historyIndexInitialized", "historyMaxAge", "Lorg/elasticsearch/common/unit/TimeValue;", "historyMaxDocs", "", "Ljava/lang/Long;", "historyRetentionPeriod", "historyRolloverPeriod", "isMaster", "lastRolloverTime", "getLastRolloverTime", "()Lorg/elasticsearch/common/unit/TimeValue;", "setLastRolloverTime", "(Lorg/elasticsearch/common/unit/TimeValue;)V", "requestTimeout", "scheduledRollover", "Lorg/elasticsearch/threadpool/Scheduler$Cancellable;", "clusterChanged", "", "event", "Lorg/elasticsearch/cluster/ClusterChangedEvent;", "createIndex", "index", "", "alias", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createOrUpdateAlertIndex", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createOrUpdateInitialHistoryIndex", "deleteOldHistoryIndices", "executorName", "isHistoryEnabled", "isInitialized", "offMaster", "onMaster", "rescheduleRollover", "rolloverAndDeleteHistoryIndices", "rolloverHistoryIndex", "setIndexUpdateFlag", "targetIndex", "updateIndexMapping", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "opendistro-alerting"})
public final class AlertIndices
implements ClusterStateListener {
    private volatile Boolean historyEnabled;
    private volatile Long historyMaxDocs;
    private volatile TimeValue historyMaxAge;
    private volatile TimeValue historyRolloverPeriod;
    private volatile TimeValue historyRetentionPeriod;
    private volatile TimeValue requestTimeout;
    private volatile boolean isMaster;
    @Nullable
    private TimeValue lastRolloverTime;
    private boolean historyIndexInitialized;
    private boolean alertIndexInitialized;
    private Scheduler.Cancellable scheduledRollover;
    private final Client client;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    @NotNull
    public static final String ALERT_INDEX = ".opendistro-alerting-alerts";
    @NotNull
    public static final String MAPPING_TYPE = "_doc";
    @NotNull
    public static final String HISTORY_WRITE_INDEX = ".opendistro-alerting-alert-history-write";
    @NotNull
    public static final String HISTORY_ALL = ".opendistro-alerting-alert-history*";
    @NotNull
    public static final String HISTORY_INDEX_PATTERN = "<.opendistro-alerting-alert-history-{now/d}-1>";
    @NotNull
    public static final String ALL_INDEX_PATTERN = ".opendistro-alerting-alert*";
    private static final Logger logger;
    public static final Companion Companion;

    @Nullable
    public final TimeValue getLastRolloverTime() {
        return this.lastRolloverTime;
    }

    public final void setLastRolloverTime(@Nullable TimeValue timeValue) {
        this.lastRolloverTime = timeValue;
    }

    public final void onMaster() {
        try {
            this.rolloverHistoryIndex();
            this.scheduledRollover = this.threadPool.scheduleWithFixedDelay(new Runnable(this){
                final /* synthetic */ AlertIndices this$0;

                public final void run() {
                    AlertIndices.access$rolloverAndDeleteHistoryIndices(this.this$0);
                }
                {
                    this.this$0 = alertIndices;
                }
            }, this.historyRolloverPeriod, this.executorName());
        }
        catch (Exception e) {
            logger.error("Error creating alert indices. Alerts can't be recorded until master node is restarted.", (Throwable)e);
        }
    }

    public final void offMaster() {
        block0: {
            Scheduler.Cancellable cancellable = this.scheduledRollover;
            if (cancellable == null) break block0;
            cancellable.cancel();
        }
    }

    private final String executorName() {
        return "management";
    }

    public void clusterChanged(@NotNull ClusterChangedEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (this.isMaster != event.localNodeMaster()) {
            this.isMaster = event.localNodeMaster();
            if (this.isMaster) {
                this.onMaster();
            } else {
                this.offMaster();
            }
        }
        this.alertIndexInitialized = event.state().routingTable().hasIndex(ALERT_INDEX);
        this.historyIndexInitialized = event.state().metadata().hasAlias(HISTORY_WRITE_INDEX);
    }

    private final void rescheduleRollover() {
        ClusterState clusterState = this.clusterService.state();
        Intrinsics.checkExpressionValueIsNotNull((Object)clusterState, (String)"clusterService.state()");
        DiscoveryNodes discoveryNodes = clusterState.getNodes();
        Intrinsics.checkExpressionValueIsNotNull((Object)discoveryNodes, (String)"clusterService.state().nodes");
        if (discoveryNodes.isLocalNodeElectedMaster()) {
            Scheduler.Cancellable cancellable = this.scheduledRollover;
            if (cancellable != null) {
                cancellable.cancel();
            }
            this.scheduledRollover = this.threadPool.scheduleWithFixedDelay(new Runnable(this){
                final /* synthetic */ AlertIndices this$0;

                public final void run() {
                    AlertIndices.access$rolloverAndDeleteHistoryIndices(this.this$0);
                }
                {
                    this.this$0 = alertIndices;
                }
            }, this.historyRolloverPeriod, this.executorName());
        }
    }

    public final boolean isInitialized() {
        return this.alertIndexInitialized && this.historyIndexInitialized;
    }

    public final boolean isHistoryEnabled() {
        Boolean bl = this.historyEnabled;
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"historyEnabled");
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createOrUpdateAlertIndex(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof createOrUpdateAlertIndex.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ AlertIndices this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createOrUpdateAlertIndex((Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = alertIndices;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.alertIndexInitialized) break;
                var2_5 = this;
                $continuation.L$0 = this;
                $continuation.L$1 = var2_5;
                $continuation.label = 1;
                v0 = AlertIndices.createIndex$default(this, ".opendistro-alerting-alerts", null, (Continuation)$continuation, 2, null);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl26
            }
            case 1: {
                var2_5 = (AlertIndices)$continuation.L$1;
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                var3_6 = v0;
                var2_5.alertIndexInitialized = (Boolean)var3_6;
                if (this.alertIndexInitialized) {
                    IndexUtils.Companion.alertIndexUpdated();
                }
                ** GOTO lbl43
            }
        }
        if (!IndexUtils.Companion.getAlertIndexUpdated()) {
            $continuation.L$0 = this;
            $continuation.label = 2;
            v1 = AlertIndices.updateIndexMapping$default(this, ".opendistro-alerting-alerts", false, (Continuation)$continuation, 2, null);
            if (v1 == var6_4) {
                return var6_4;
            }
        }
        ** GOTO lbl43
        {
            case 2: {
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createOrUpdateInitialHistoryIndex(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof createOrUpdateInitialHistoryIndex.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ AlertIndices this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createOrUpdateInitialHistoryIndex((Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = alertIndices;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.historyIndexInitialized) break;
                var2_5 = this;
                $continuation.L$0 = this;
                $continuation.L$1 = var2_5;
                $continuation.label = 1;
                v0 = this.createIndex("<.opendistro-alerting-alert-history-{now/d}-1>", ".opendistro-alerting-alert-history-write", (Continuation<? super Boolean>)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl26
            }
            case 1: {
                var2_5 = (AlertIndices)$continuation.L$1;
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                var3_6 = v0;
                var2_5.historyIndexInitialized = (Boolean)var3_6;
                if (this.historyIndexInitialized) {
                    v1 = this.clusterService.state();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"clusterService.state()");
                    IndexUtils.Companion.setLastUpdatedHistoryIndex(IndexUtils.Companion.getIndexNameWithAlias(v1, ".opendistro-alerting-alert-history-write"));
                }
                ** GOTO lbl44
            }
        }
        $continuation.L$0 = this;
        $continuation.label = 2;
        v2 = this.updateIndexMapping(".opendistro-alerting-alert-history-write", true, (Continuation<? super Unit>)$continuation);
        if (v2 == var6_4) {
            return var6_4;
        }
        ** GOTO lbl44
        {
            case 2: {
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl44:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    final /* synthetic */ Object createIndex(@NotNull String index, @Nullable String alias, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof createIndex.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ AlertIndices this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createIndex(null, null, (Continuation<? super Boolean>)this);
                }
                {
                    this.this$0 = alertIndices;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = index;
                $continuation.L$2 = alias;
                $continuation.label = 1;
                v0 = ElasticExtensionsKt.suspendUntil((ElasticsearchClient)((ElasticsearchClient)this.client.admin().indices()), (Function2)((Function2)new Function2<IndicesAdminClient, ActionListener<IndicesExistsResponse>, Unit>(index){
                    final /* synthetic */ String $index;

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<IndicesExistsResponse> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        $this$suspendUntil.exists((IndicesExistsRequest)new IndicesExistsRequest(new String[]{this.$index}).local(true), it);
                    }
                    {
                        this.$index = string;
                        super(2);
                    }
                }), (Continuation)$continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                alias = (String)$continuation.L$2;
                index = (String)$continuation.L$1;
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if ((existsResponse = (IndicesExistsResponse)v0).isExists()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                request = new CreateIndexRequest(index).mapping("_doc", AlertIndices.Companion.alertMapping(), XContentType.JSON).settings(Settings.builder().put("index.hidden", true).build());
                if (alias != null) {
                    request.alias(new Alias(alias));
                }
                $continuation.L$0 = this;
                $continuation.L$1 = index;
                $continuation.L$2 = alias;
                $continuation.L$3 = existsResponse;
                $continuation.L$4 = request;
                $continuation.label = 2;
                v1 = ElasticExtensionsKt.suspendUntil((ElasticsearchClient)((ElasticsearchClient)this.client.admin().indices()), (Function2)((Function2)new Function2<IndicesAdminClient, ActionListener<CreateIndexResponse>, Unit>(request){
                    final /* synthetic */ CreateIndexRequest $request;

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<CreateIndexResponse> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        $this$suspendUntil.create(this.$request, it);
                    }
                    {
                        this.$request = createIndexRequest;
                        super(2);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var10_6) goto lbl43
lbl42:
                // 1 sources

                return var10_6;
lbl43:
                // 1 sources

                ** GOTO lbl54
            }
            case 2: {
                request = (CreateIndexRequest)$continuation.L$4;
                existsResponse = (IndicesExistsResponse)$continuation.L$3;
                alias = (String)$continuation.L$2;
                index = (String)$continuation.L$1;
                this = (AlertIndices)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl54:
                    // 2 sources

                    createIndexResponse = (CreateIndexResponse)v1;
                    var6_12 = createIndexResponse.isAcknowledged();
                }
                catch (ResourceAlreadyExistsException e) {
                    var6_12 = true;
                }
                return Boxing.boxBoolean((boolean)var6_12);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object createIndex$default(AlertIndices alertIndices, String string, String string2, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return alertIndices.createIndex(string, string2, (Continuation<? super Boolean>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    final /* synthetic */ Object updateIndexMapping(@NotNull String index, boolean alias, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateIndexMapping.1)) ** GOTO lbl-1000
        var10_4 = $completion;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ AlertIndices this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                boolean Z$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateIndexMapping(null, false, (Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = alertIndices;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                clusterState = this.clusterService.state();
                mapping = AlertIndices.Companion.alertMapping();
                targetIndex = index;
                if (alias) {
                    v0 = clusterState;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"clusterState");
                    targetIndex = IndexUtils.Companion.getIndexNameWithAlias(v0, index);
                }
                if (Intrinsics.areEqual((Object)targetIndex, (Object)IndexUtils.Companion.getLastUpdatedHistoryIndex())) {
                    return Unit.INSTANCE;
                }
                var7_12 = new Ref.ObjectRef();
                v1 = new PutMappingRequest(new String[]{targetIndex}).type("_doc").source(mapping, XContentType.JSON);
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"PutMappingRequest(target\u2026pping, XContentType.JSON)");
                var7_12.element = v1;
                $continuation.L$0 = this;
                $continuation.L$1 = index;
                $continuation.Z$0 = alias;
                $continuation.L$2 = clusterState;
                $continuation.L$3 = mapping;
                $continuation.L$4 = targetIndex;
                $continuation.L$5 = putMappingRequest;
                $continuation.label = 1;
                v2 = ElasticExtensionsKt.suspendUntil((ElasticsearchClient)((ElasticsearchClient)this.client.admin().indices()), (Function2)((Function2)new Function2<IndicesAdminClient, ActionListener<AcknowledgedResponse>, Unit>((Ref.ObjectRef)putMappingRequest){
                    final /* synthetic */ Ref.ObjectRef $putMappingRequest;

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        $this$suspendUntil.putMapping((PutMappingRequest)this.$putMappingRequest.element, it);
                    }
                    {
                        this.$putMappingRequest = objectRef;
                        super(2);
                    }
                }), (Continuation)$continuation);
                if (v2 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl47
            }
            case 1: {
                putMappingRequest = (Ref.ObjectRef)$continuation.L$5;
                targetIndex = (String)$continuation.L$4;
                mapping = (String)$continuation.L$3;
                clusterState = (ClusterState)$continuation.L$2;
                alias = $continuation.Z$0;
                index = (String)$continuation.L$1;
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl47:
                // 2 sources

                if ((updateResponse = (AcknowledgedResponse)v2).isAcknowledged()) {
                    AlertIndices.logger.info("Index mapping of " + targetIndex + " is updated");
                    this.setIndexUpdateFlag(index, targetIndex);
                } else {
                    AlertIndices.logger.info("Failed to update index mapping of " + targetIndex);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object updateIndexMapping$default(AlertIndices alertIndices, String string, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return alertIndices.updateIndexMapping(string, bl, (Continuation<? super Unit>)continuation);
    }

    private final void setIndexUpdateFlag(String index, String targetIndex) {
        switch (index) {
            case ".opendistro-alerting-alerts": {
                IndexUtils.Companion.alertIndexUpdated();
                break;
            }
            case ".opendistro-alerting-alert-history-write": {
                IndexUtils.Companion.setLastUpdatedHistoryIndex(targetIndex);
                break;
            }
        }
    }

    private final void rolloverAndDeleteHistoryIndices() {
        Boolean bl = this.historyEnabled;
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"historyEnabled");
        if (bl.booleanValue()) {
            this.rolloverHistoryIndex();
        }
        this.deleteOldHistoryIndices();
    }

    private final boolean rolloverHistoryIndex() {
        RolloverResponse response2;
        if (!this.historyIndexInitialized) {
            return false;
        }
        RolloverRequest request = new RolloverRequest(HISTORY_WRITE_INDEX, null);
        request.getCreateIndexRequest().index(HISTORY_INDEX_PATTERN).mapping(MAPPING_TYPE, Companion.alertMapping(), XContentType.JSON).settings(Settings.builder().put("index.hidden", true).build());
        Long l = this.historyMaxDocs;
        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"historyMaxDocs");
        request.addMaxIndexDocsCondition(l.longValue());
        request.addMaxIndexAgeCondition(this.historyMaxAge);
        RolloverResponse rolloverResponse = response2 = (RolloverResponse)this.client.admin().indices().rolloverIndex(request).actionGet(this.requestTimeout);
        Intrinsics.checkExpressionValueIsNotNull((Object)rolloverResponse, (String)"response");
        if (!rolloverResponse.isRolledOver()) {
            logger.info(".opendistro-alerting-alert-history-write not rolled over. Conditions were: " + response2.getConditionStatus());
        } else {
            this.lastRolloverTime = TimeValue.timeValueMillis((long)this.threadPool.absoluteTimeInMillis());
        }
        return response2.isRolledOver();
    }

    private final void deleteOldHistoryIndices() {
        Collection entry2;
        ClusterStateResponse clusterStateResponse;
        boolean bl = false;
        List indicesToDelete = new ArrayList();
        ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(new String[]{HISTORY_ALL}).metadata(true).local(true)).indicesOptions(IndicesOptions.strictExpand());
        ClusterStateResponse clusterStateResponse2 = clusterStateResponse = (ClusterStateResponse)this.client.admin().cluster().state(clusterStateRequest).actionGet();
        Intrinsics.checkExpressionValueIsNotNull((Object)clusterStateResponse2, (String)"clusterStateResponse");
        ClusterState clusterState = clusterStateResponse2.getState();
        Intrinsics.checkExpressionValueIsNotNull((Object)clusterState, (String)"clusterStateResponse.state");
        Metadata metadata = clusterState.getMetadata();
        Intrinsics.checkExpressionValueIsNotNull((Object)metadata, (String)"clusterStateResponse.state.metadata");
        for (Collection entry2 : metadata.getIndices()) {
            Object v8;
            IndexMetadata indexMetaData;
            block10: {
                IndexMetadata indexMetadata = indexMetaData = (IndexMetadata)((ObjectObjectCursor)entry2).value;
                Intrinsics.checkExpressionValueIsNotNull((Object)indexMetadata, (String)"indexMetaData");
                long creationTime = indexMetadata.getCreationDate();
                long l = Instant.now().toEpochMilli() - creationTime;
                TimeValue timeValue = this.historyRetentionPeriod;
                Intrinsics.checkExpressionValueIsNotNull((Object)timeValue, (String)"historyRetentionPeriod");
                if (l <= timeValue.getMillis()) continue;
                ImmutableOpenMap immutableOpenMap = indexMetaData.getAliases();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableOpenMap, (String)"indexMetaData.aliases");
                Iterable $this$firstOrNull$iv = (Iterable)immutableOpenMap;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ObjectObjectCursor it = (ObjectObjectCursor)element$iv;
                    boolean bl2 = false;
                    Object object = it.value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.value");
                    if (!Intrinsics.areEqual((Object)HISTORY_WRITE_INDEX, (Object)((AliasMetadata)object).getAlias())) continue;
                    v8 = element$iv;
                    break block10;
                }
                v8 = null;
            }
            ObjectObjectCursor alias = v8;
            if (alias != null) {
                Boolean bl3 = this.historyEnabled;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl3, (String)"historyEnabled");
                if (bl3.booleanValue()) continue;
                this.historyIndexInitialized = false;
            }
            Index index = indexMetaData.getIndex();
            Intrinsics.checkExpressionValueIsNotNull((Object)index, (String)"indexMetaData.index");
            String string = index.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"indexMetaData.index.name");
            indicesToDelete.add(string);
        }
        entry2 = indicesToDelete;
        boolean bl4 = false;
        if (!entry2.isEmpty()) {
            AcknowledgedResponse deleteIndexResponse;
            Collection $this$toTypedArray$iv = indicesToDelete;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray2 = stringArray;
            String[] stringArray3 = Arrays.copyOf(stringArray2, stringArray2.length);
            DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(stringArray3);
            AcknowledgedResponse acknowledgedResponse = deleteIndexResponse = (AcknowledgedResponse)this.client.admin().indices().delete(deleteIndexRequest).actionGet();
            Intrinsics.checkExpressionValueIsNotNull((Object)acknowledgedResponse, (String)"deleteIndexResponse");
            if (!acknowledgedResponse.isAcknowledged()) {
                logger.error("Could not delete one or more Alerting history indices: " + indicesToDelete + ". Retrying one by one.");
                for (String index : indicesToDelete) {
                    try {
                        AcknowledgedResponse singleDeleteResponse;
                        Collection $this$toTypedArray$iv2 = indicesToDelete;
                        boolean $i$f$toTypedArray2 = false;
                        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
                        if (thisCollection$iv2.toArray(new String[0]) == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        String[] stringArray4 = Arrays.copyOf(stringArray2, stringArray2.length);
                        DeleteIndexRequest singleDeleteRequest = new DeleteIndexRequest(stringArray4);
                        AcknowledgedResponse acknowledgedResponse2 = singleDeleteResponse = (AcknowledgedResponse)this.client.admin().indices().delete(singleDeleteRequest).actionGet();
                        Intrinsics.checkExpressionValueIsNotNull((Object)acknowledgedResponse2, (String)"singleDeleteResponse");
                        if (acknowledgedResponse2.isAcknowledged()) continue;
                        logger.error("Could not delete one or more Alerting history indices: " + index);
                    }
                    catch (IndexNotFoundException e) {
                        logger.debug(index + " was already deleted. " + e.getMessage());
                    }
                }
            }
        }
    }

    public AlertIndices(@NotNull Settings settings, @NotNull Client client, @NotNull ThreadPool threadPool, @NotNull ClusterService clusterService) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)threadPool, (String)"threadPool");
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.clusterService.addListener((ClusterStateListener)this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_HISTORY_ENABLED(), (Consumer)new Consumer<Boolean>(){

            @Override
            public final void accept(Boolean it) {
                historyEnabled = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_HISTORY_MAX_DOCS(), (Consumer)new Consumer<Long>(){

            @Override
            public final void accept(Long it) {
                historyMaxDocs = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_HISTORY_INDEX_MAX_AGE(), (Consumer)new Consumer<TimeValue>(){

            @Override
            public final void accept(TimeValue it) {
                historyMaxAge = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_HISTORY_ROLLOVER_PERIOD(), (Consumer)new Consumer<TimeValue>(){

            @Override
            public final void accept(TimeValue it) {
                historyRolloverPeriod = it;
                this.rescheduleRollover();
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_HISTORY_RETENTION_PERIOD(), (Consumer)new Consumer<TimeValue>(){

            @Override
            public final void accept(TimeValue it) {
                historyRetentionPeriod = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getREQUEST_TIMEOUT(), (Consumer)new Consumer<TimeValue>(){

            @Override
            public final void accept(TimeValue it) {
                requestTimeout = it;
            }
        });
        this.historyEnabled = (Boolean)AlertingSettings.Companion.getALERT_HISTORY_ENABLED().get(settings);
        this.historyMaxDocs = (Long)AlertingSettings.Companion.getALERT_HISTORY_MAX_DOCS().get(settings);
        this.historyMaxAge = (TimeValue)AlertingSettings.Companion.getALERT_HISTORY_INDEX_MAX_AGE().get(settings);
        this.historyRolloverPeriod = (TimeValue)AlertingSettings.Companion.getALERT_HISTORY_ROLLOVER_PERIOD().get(settings);
        this.historyRetentionPeriod = (TimeValue)AlertingSettings.Companion.getALERT_HISTORY_RETENTION_PERIOD().get(settings);
        this.requestTimeout = (TimeValue)AlertingSettings.Companion.getREQUEST_TIMEOUT().get(settings);
    }

    static {
        Companion = new Companion(null);
        logger = LogManager.getLogger(AlertIndices.class);
    }

    public static final /* synthetic */ void access$rolloverAndDeleteHistoryIndices(AlertIndices $this) {
        $this.rolloverAndDeleteHistoryIndices();
    }

    public static final /* synthetic */ Boolean access$getHistoryEnabled$p(AlertIndices $this) {
        return $this.historyEnabled;
    }

    public static final /* synthetic */ Long access$getHistoryMaxDocs$p(AlertIndices $this) {
        return $this.historyMaxDocs;
    }

    public static final /* synthetic */ TimeValue access$getHistoryMaxAge$p(AlertIndices $this) {
        return $this.historyMaxAge;
    }

    public static final /* synthetic */ TimeValue access$getHistoryRolloverPeriod$p(AlertIndices $this) {
        return $this.historyRolloverPeriod;
    }

    public static final /* synthetic */ TimeValue access$getHistoryRetentionPeriod$p(AlertIndices $this) {
        return $this.historyRetentionPeriod;
    }

    public static final /* synthetic */ TimeValue access$getRequestTimeout$p(AlertIndices $this) {
        return $this.requestTimeout;
    }

    @JvmStatic
    @NotNull
    public static final String alertMapping() {
        return Companion.alertMapping();
    }

    @kotlin.Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/alerts/AlertIndices$Companion;", "", "()V", "ALERT_INDEX", "", "ALL_INDEX_PATTERN", "HISTORY_ALL", "HISTORY_INDEX_PATTERN", "HISTORY_WRITE_INDEX", "MAPPING_TYPE", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "alertMapping", "opendistro-alerting"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final String alertMapping() {
            URL uRL = AlertIndices.class.getResource("alert_mapping.json");
            Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"AlertIndices::class.java\u2026rce(\"alert_mapping.json\")");
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            boolean bl2 = false;
            boolean bl3 = false;
            return new String(byArray, charset);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

