/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.destination.message;

import com.amazon.opendistroforelasticsearch.alerting.destination.message.BaseMessage;
import com.amazon.opendistroforelasticsearch.alerting.destination.message.DestinationType;
import org.elasticsearch.common.Strings;

public class ChimeMessage
extends BaseMessage {
    private String message;

    private ChimeMessage(DestinationType destinationType, String destinationName, String url, String message) {
        super(destinationType, destinationName, message, url);
        if (DestinationType.CHIME != destinationType) {
            throw new IllegalArgumentException("Channel Type does not match CHIME");
        }
        if (Strings.isNullOrEmpty((String)message)) {
            throw new IllegalArgumentException("Message content is missing");
        }
        this.message = message;
    }

    public String toString() {
        return "DestinationType: " + (Object)((Object)this.destinationType) + ", DestinationName:" + this.destinationName + ", Url: " + this.url + ", Message: " + this.message;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public static class Builder {
        private String message;
        private DestinationType destinationType;
        private String destinationName;
        private String url;

        public Builder(String destinationName) {
            this.destinationName = destinationName;
            this.destinationType = DestinationType.CHIME;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public ChimeMessage build() {
            ChimeMessage chimeMessage = new ChimeMessage(this.destinationType, this.destinationName, this.url, this.message);
            return chimeMessage;
        }
    }
}

