/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.destination.factory;

import com.amazon.opendistroforelasticsearch.alerting.destination.factory.ChimeDestinationFactory;
import com.amazon.opendistroforelasticsearch.alerting.destination.factory.CustomWebhookDestinationFactory;
import com.amazon.opendistroforelasticsearch.alerting.destination.factory.DestinationFactory;
import com.amazon.opendistroforelasticsearch.alerting.destination.factory.EmailDestinationFactory;
import com.amazon.opendistroforelasticsearch.alerting.destination.factory.SlackDestinationFactory;
import com.amazon.opendistroforelasticsearch.alerting.destination.message.DestinationType;
import java.util.HashMap;
import java.util.Map;

public class DestinationFactoryProvider {
    private static Map<DestinationType, DestinationFactory> destinationFactoryMap = new HashMap<DestinationType, DestinationFactory>();

    public static DestinationFactory getFactory(DestinationType destinationType) {
        if (!destinationFactoryMap.containsKey((Object)destinationType)) {
            throw new IllegalArgumentException("Invalid channel type");
        }
        return destinationFactoryMap.get((Object)destinationType);
    }

    public static void setFactory(DestinationType type, DestinationFactory factory) {
        destinationFactoryMap.put(type, factory);
    }

    static {
        destinationFactoryMap.put(DestinationType.CHIME, new ChimeDestinationFactory());
        destinationFactoryMap.put(DestinationType.SLACK, new SlackDestinationFactory());
        destinationFactoryMap.put(DestinationType.CUSTOMWEBHOOK, new CustomWebhookDestinationFactory());
        destinationFactoryMap.put(DestinationType.EMAIL, new EmailDestinationFactory());
    }
}

