/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.destination.client;

import com.amazon.opendistroforelasticsearch.alerting.destination.message.BaseMessage;
import com.amazon.opendistroforelasticsearch.alerting.destination.message.EmailMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DestinationEmailClient {
    private static final Logger logger = LogManager.getLogger(DestinationEmailClient.class);

    public String execute(BaseMessage message) throws Exception {
        if (message instanceof EmailMessage) {
            final EmailMessage emailMessage = (EmailMessage)message;
            Session session = null;
            Properties prop = new Properties();
            prop.put("mail.transport.protocol", "smtp");
            prop.put("mail.smtp.host", emailMessage.getHost());
            prop.put("mail.smtp.port", (Object)emailMessage.getPort());
            if (emailMessage.getUsername() != null && !emailMessage.getUsername().equals((Object)"".toCharArray())) {
                prop.put("mail.smtp.auth", (Object)true);
                try {
                    session = Session.getInstance((Properties)prop, (Authenticator)new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(emailMessage.getUsername().toString(), emailMessage.getPassword().toString());
                        }
                    });
                }
                catch (IllegalStateException e) {
                    return e.getMessage();
                }
            } else {
                session = Session.getInstance((Properties)prop);
            }
            switch (emailMessage.getMethod()) {
                case "ssl": {
                    prop.put("mail.smtp.ssl.enable", (Object)true);
                    break;
                }
                case "starttls": {
                    prop.put("mail.smtp.starttls.enable", (Object)true);
                }
            }
            try {
                MimeMessage mailmsg = new MimeMessage(session);
                mailmsg.setFrom((Address)new InternetAddress(emailMessage.getFrom()));
                mailmsg.setRecipients(Message.RecipientType.TO, (Address[])this.getRecipientsAsAddresses(emailMessage.getRecipients()));
                mailmsg.setSubject(emailMessage.getSubject());
                mailmsg.setText(emailMessage.getMessageContent());
                this.SendMessage((Message)mailmsg);
            }
            catch (MessagingException e) {
                return e.getMessage();
            }
        }
        return "Sent";
    }

    public void SendMessage(Message msg) throws Exception {
        Transport.send((Message)msg);
    }

    private InternetAddress[] getRecipientsAsAddresses(List<String> recipients) throws Exception {
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
        for (String recipient : recipients) {
            addresses.add(new InternetAddress(recipient));
        }
        return addresses.toArray(new InternetAddress[0]);
    }
}

