/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.core.schedule;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/core/schedule/JobSchedulerMetrics;", "Lorg/elasticsearch/common/xcontent/ToXContentFragment;", "Lorg/elasticsearch/common/io/stream/Writeable;", "scheduledJobId", "", "lastExecutionTime", "", "runningOnTime", "", "(Ljava/lang/String;Ljava/lang/Long;Z)V", "si", "Lorg/elasticsearch/common/io/stream/StreamInput;", "(Lorg/elasticsearch/common/io/stream/StreamInput;)V", "getLastExecutionTime", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getRunningOnTime", "()Z", "getScheduledJobId", "()Ljava/lang/String;", "toXContent", "Lorg/elasticsearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/elasticsearch/common/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/elasticsearch/common/io/stream/StreamOutput;", "alerting-core"})
public final class JobSchedulerMetrics
implements ToXContentFragment,
Writeable {
    @NotNull
    private final String scheduledJobId;
    @Nullable
    private final Long lastExecutionTime;
    private final boolean runningOnTime;

    @NotNull
    public final String getScheduledJobId() {
        return this.scheduledJobId;
    }

    @Nullable
    public final Long getLastExecutionTime() {
        return this.lastExecutionTime;
    }

    public final boolean getRunningOnTime() {
        return this.runningOnTime;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        out.writeString(this.scheduledJobId);
        out.writeOptionalLong(this.lastExecutionTime);
        out.writeBoolean(this.runningOnTime);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        if (this.lastExecutionTime != null) {
            builder.timeField("last_execution_time", "last_execution_time_in_millis", Instant.ofEpochMilli(this.lastExecutionTime).toEpochMilli());
        }
        builder.field("running_on_time", this.runningOnTime);
        return builder;
    }

    public JobSchedulerMetrics(@NotNull String scheduledJobId, @Nullable Long lastExecutionTime, boolean runningOnTime) {
        Intrinsics.checkParameterIsNotNull((Object)scheduledJobId, (String)"scheduledJobId");
        this.scheduledJobId = scheduledJobId;
        this.lastExecutionTime = lastExecutionTime;
        this.runningOnTime = runningOnTime;
    }

    public JobSchedulerMetrics(@NotNull StreamInput si) {
        Intrinsics.checkParameterIsNotNull((Object)si, (String)"si");
        String string = si.readString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"si.readString()");
        this.scheduledJobId = string;
        this.lastExecutionTime = si.readOptionalLong();
        this.runningOnTime = si.readBoolean();
    }
}

