/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.core.resthandler;

import com.amazon.opendistroforelasticsearch.alerting.core.action.node.ScheduledJobsStatsAction;
import com.amazon.opendistroforelasticsearch.alerting.core.action.node.ScheduledJobsStatsRequest;
import com.amazon.opendistroforelasticsearch.alerting.core.resthandler.RestScheduledJobStatsHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/core/resthandler/RestScheduledJobStatsHandler;", "Lorg/elasticsearch/rest/BaseRestHandler;", "path", "", "(Ljava/lang/String;)V", "getName", "getRequest", "Lcom/amazon/opendistroforelasticsearch/alerting/core/action/node/ScheduledJobsStatsRequest;", "request", "Lorg/elasticsearch/rest/RestRequest;", "prepareRequest", "Lorg/elasticsearch/rest/BaseRestHandler$RestChannelConsumer;", "client", "Lorg/elasticsearch/client/node/NodeClient;", "routes", "", "Lorg/elasticsearch/rest/RestHandler$Route;", "Companion", "alerting-core"})
public final class RestScheduledJobStatsHandler
extends BaseRestHandler {
    private final String path;
    @NotNull
    public static final String JOB_SCHEDULING_METRICS = "job_scheduling_metrics";
    @NotNull
    public static final String JOBS_INFO = "jobs_info";
    private static final Map<String, Function1<ScheduledJobsStatsRequest, Unit>> METRICS;
    public static final Companion Companion;

    @NotNull
    public String getName() {
        return this.path + "_jobs_stats";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object[])new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/" + this.path + "/{nodeId}/stats/"), new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/" + this.path + "/{nodeId}/stats/{metric}"), new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/" + this.path + "/stats/"), new RestHandler.Route(RestRequest.Method.GET, "/_opendistro/" + this.path + "/stats/{metric}")});
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        ScheduledJobsStatsRequest scheduledJobNodesStatsRequest = this.getRequest(request);
        return new BaseRestHandler.RestChannelConsumer(client, scheduledJobNodesStatsRequest){
            final /* synthetic */ NodeClient $client;
            final /* synthetic */ ScheduledJobsStatsRequest $scheduledJobNodesStatsRequest;

            public final void accept(RestChannel channel) {
                this.$client.execute((ActionType)ScheduledJobsStatsAction.Companion.getINSTANCE(), (ActionRequest)this.$scheduledJobNodesStatsRequest, (ActionListener)new RestActions.NodesResponseRestListener(channel));
            }
            {
                this.$client = nodeClient;
                this.$scheduledJobNodesStatsRequest = scheduledJobsStatsRequest;
            }
        };
    }

    private final ScheduledJobsStatsRequest getRequest(RestRequest request) {
        String[] nodesIds = Strings.splitStringByCommaToArray((String)request.param("nodeId"));
        Set metrics = Strings.tokenizeByCommaToSet((String)request.param("metric"));
        Intrinsics.checkExpressionValueIsNotNull((Object)nodesIds, (String)"nodesIds");
        ScheduledJobsStatsRequest scheduledJobsStatsRequest = new ScheduledJobsStatsRequest(nodesIds);
        scheduledJobsStatsRequest.timeout(request.param("timeout"));
        if (metrics.isEmpty()) {
            return scheduledJobsStatsRequest;
        }
        if (metrics.size() == 1 && metrics.contains("_all")) {
            scheduledJobsStatsRequest.all();
        } else {
            if (metrics.contains("_all")) {
                String string;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Locale locale = Locale.ROOT;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
                Locale locale2 = locale;
                String string2 = "request [%s] contains _all and individual metrics [%s]";
                Object[] objectArray = new Object[]{request.path(), request.param("metric")};
                boolean bl = false;
                String string3 = String.format(locale2, string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
                String string4 = string = string3;
                throw (Throwable)new IllegalArgumentException(string4);
            }
            scheduledJobsStatsRequest.clear();
            TreeSet<String> invalidMetrics = new TreeSet<String>();
            for (String metric : metrics) {
                Function1<ScheduledJobsStatsRequest, Unit> handler = METRICS.get(metric);
                if (handler != null) {
                    handler.invoke((Object)scheduledJobsStatsRequest);
                    continue;
                }
                invalidMetrics.add(metric);
            }
            if (!invalidMetrics.isEmpty()) {
                throw (Throwable)new IllegalArgumentException(this.unrecognized(request, invalidMetrics, METRICS.keySet(), "metric"));
            }
        }
        return scheduledJobsStatsRequest;
    }

    public RestScheduledJobStatsHandler(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.path = path;
    }

    static {
        Companion = new Companion(null);
        METRICS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)JOB_SCHEDULING_METRICS, (Object)((Object)Companion.METRICS.1.INSTANCE)), TuplesKt.to((Object)JOBS_INFO, (Object)((Object)Companion.METRICS.2.INSTANCE))});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/core/resthandler/RestScheduledJobStatsHandler$Companion;", "", "()V", "JOBS_INFO", "", "JOB_SCHEDULING_METRICS", "METRICS", "", "Lkotlin/Function1;", "Lcom/amazon/opendistroforelasticsearch/alerting/core/action/node/ScheduledJobsStatsRequest;", "", "alerting-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

