/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.core.model;

import com.amazon.opendistroforelasticsearch.alerting.core.model.Schedule;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 42\u00020\u0001:\u00014B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\nH\u00c6\u0003J)\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u0016J\u001e\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0 2\b\u0010!\u001a\u0004\u0018\u00010\nH\u0016J\u001e\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0 2\b\u0010#\u001a\u0004\u0018\u00010\nH\u0016J\t\u0010$\u001a\u00020\u0006H\u00d6\u0001J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0012\u0010'\u001a\u00020\u00192\b\u0010(\u001a\u0004\u0018\u00010\nH\u0016J\t\u0010)\u001a\u00020*H\u00d6\u0001J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00065"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/core/model/IntervalSchedule;", "Lcom/amazon/opendistroforelasticsearch/alerting/core/model/Schedule;", "sin", "Lorg/elasticsearch/common/io/stream/StreamInput;", "(Lorg/elasticsearch/common/io/stream/StreamInput;)V", "interval", "", "unit", "Ljava/time/temporal/ChronoUnit;", "testInstant", "Ljava/time/Instant;", "(ILjava/time/temporal/ChronoUnit;Ljava/time/Instant;)V", "getInterval", "()I", "intervalInMills", "", "getTestInstant", "()Ljava/time/Instant;", "getUnit", "()Ljava/time/temporal/ChronoUnit;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getExpectedNextExecutionTime", "enabledTime", "expectedPreviousExecutionTime", "getPeriodEndingAt", "Lkotlin/Pair;", "endTime", "getPeriodStartingAt", "startTime", "hashCode", "nextTimeToExecute", "Ljava/time/Duration;", "runningOnTime", "lastExecutionTime", "toString", "", "toXContent", "Lorg/elasticsearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/elasticsearch/common/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/elasticsearch/common/io/stream/StreamOutput;", "Companion", "alerting-core"})
public final class IntervalSchedule
extends Schedule {
    private final transient long intervalInMills;
    private final int interval;
    @NotNull
    private final ChronoUnit unit;
    @Nullable
    private final transient Instant testInstant;
    private static final transient List<ChronoUnit> SUPPORTED_UNIT;
    public static final Companion Companion;

    @Override
    @Nullable
    public Duration nextTimeToExecute(@NotNull Instant enabledTime) {
        Intrinsics.checkParameterIsNotNull((Object)enabledTime, (String)"enabledTime");
        long enabledTimeEpochMillis = enabledTime.toEpochMilli();
        Instant instant = this.testInstant;
        if (instant == null) {
            instant = Instant.now();
        }
        Instant currentTime = instant;
        long delta = currentTime.toEpochMilli() - enabledTimeEpochMillis;
        long remainingScheduleTime = this.intervalInMills - delta % this.intervalInMills;
        return Duration.of(remainingScheduleTime, ChronoUnit.MILLIS);
    }

    @Override
    @Nullable
    public Instant getExpectedNextExecutionTime(@NotNull Instant enabledTime, @Nullable Instant expectedPreviousExecutionTime) {
        Intrinsics.checkParameterIsNotNull((Object)enabledTime, (String)"enabledTime");
        Instant instant = expectedPreviousExecutionTime;
        if (instant == null) {
            instant = enabledTime;
        }
        long expectedPreviousExecutionTimeEpochMillis = instant.toEpochMilli();
        Instant instant2 = this.testInstant;
        if (instant2 == null) {
            instant2 = Instant.now();
        }
        Instant currentTime = instant2;
        long delta = currentTime.toEpochMilli() - expectedPreviousExecutionTimeEpochMillis;
        long remainingScheduleTime = this.intervalInMills - delta % this.intervalInMills;
        return Instant.ofEpochMilli(currentTime.toEpochMilli() + remainingScheduleTime);
    }

    @Override
    @NotNull
    public Pair<Instant, Instant> getPeriodStartingAt(@Nullable Instant startTime) {
        Instant instant = startTime;
        if (instant == null) {
            instant = Instant.now();
        }
        Instant realStartTime = instant;
        Instant newEndTime = realStartTime.plusMillis(this.intervalInMills);
        return new Pair((Object)realStartTime, (Object)newEndTime);
    }

    @Override
    @NotNull
    public Pair<Instant, Instant> getPeriodEndingAt(@Nullable Instant endTime) {
        Instant instant = endTime;
        if (instant == null) {
            instant = Instant.now();
        }
        Instant realEndTime = instant;
        Instant newStartTime = realEndTime.minusMillis(this.intervalInMills);
        return new Pair((Object)newStartTime, (Object)realEndTime);
    }

    @Override
    public boolean runningOnTime(@Nullable Instant lastExecutionTime) {
        if (lastExecutionTime == null) {
            return true;
        }
        Instant instant = this.testInstant;
        long delta = ChronoUnit.MILLIS.between(lastExecutionTime, instant != null ? (Temporal)instant : (Temporal)Instant.now());
        return 0L < delta && delta < this.intervalInMills;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        builder.startObject().startObject("period").field("interval", this.interval).field("unit", this.unit.name()).endObject().endObject();
        return builder;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        out.writeInt(this.interval);
        out.writeEnum((Enum)this.unit);
    }

    public final int getInterval() {
        return this.interval;
    }

    @NotNull
    public final ChronoUnit getUnit() {
        return this.unit;
    }

    @Nullable
    public final Instant getTestInstant() {
        return this.testInstant;
    }

    public IntervalSchedule(int interval, @NotNull ChronoUnit unit, @Nullable Instant testInstant) {
        Intrinsics.checkParameterIsNotNull((Object)unit, (String)"unit");
        super(null);
        this.interval = interval;
        this.unit = unit;
        this.testInstant = testInstant;
        if (!SUPPORTED_UNIT.contains(this.unit)) {
            throw (Throwable)new IllegalArgumentException("Timezone " + this.unit + " is not supported expected " + SUPPORTED_UNIT);
        }
        if (this.interval <= 0) {
            throw (Throwable)new IllegalArgumentException("Interval is not allowed to be 0 or negative");
        }
        this.intervalInMills = Duration.of(this.interval, this.unit).toMillis();
    }

    public /* synthetic */ IntervalSchedule(int n, ChronoUnit chronoUnit, Instant instant, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            instant = null;
        }
        this(n, chronoUnit, instant);
    }

    public IntervalSchedule(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)sin, (String)"sin");
        int n = sin.readInt();
        Enum enum_ = sin.readEnum(ChronoUnit.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)enum_, (String)"sin.readEnum(ChronoUnit::class.java)");
        this(n, (ChronoUnit)enum_, null, 4, null);
    }

    static {
        Companion = new Companion(null);
        SUPPORTED_UNIT = CollectionsKt.listOf((Object[])new ChronoUnit[]{ChronoUnit.MINUTES, ChronoUnit.HOURS, ChronoUnit.DAYS});
    }

    public final int component1() {
        return this.interval;
    }

    @NotNull
    public final ChronoUnit component2() {
        return this.unit;
    }

    @Nullable
    public final Instant component3() {
        return this.testInstant;
    }

    @NotNull
    public final IntervalSchedule copy(int interval, @NotNull ChronoUnit unit, @Nullable Instant testInstant) {
        Intrinsics.checkParameterIsNotNull((Object)unit, (String)"unit");
        return new IntervalSchedule(interval, unit, testInstant);
    }

    public static /* synthetic */ IntervalSchedule copy$default(IntervalSchedule intervalSchedule, int n, ChronoUnit chronoUnit, Instant instant, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = intervalSchedule.interval;
        }
        if ((n2 & 2) != 0) {
            chronoUnit = intervalSchedule.unit;
        }
        if ((n2 & 4) != 0) {
            instant = intervalSchedule.testInstant;
        }
        return intervalSchedule.copy(n, chronoUnit, instant);
    }

    @NotNull
    public String toString() {
        return "IntervalSchedule(interval=" + this.interval + ", unit=" + this.unit + ", testInstant=" + this.testInstant + ")";
    }

    public int hashCode() {
        ChronoUnit chronoUnit = this.unit;
        Instant instant = this.testInstant;
        return (Integer.hashCode(this.interval) * 31 + (chronoUnit != null ? chronoUnit.hashCode() : 0)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof IntervalSchedule)) break block3;
                IntervalSchedule intervalSchedule = (IntervalSchedule)object;
                if (this.interval != intervalSchedule.interval || !Intrinsics.areEqual((Object)this.unit, (Object)intervalSchedule.unit) || !Intrinsics.areEqual((Object)this.testInstant, (Object)intervalSchedule.testInstant)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final IntervalSchedule readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/core/model/IntervalSchedule$Companion;", "", "()V", "SUPPORTED_UNIT", "", "Ljava/time/temporal/ChronoUnit;", "readFrom", "Lcom/amazon/opendistroforelasticsearch/alerting/core/model/IntervalSchedule;", "sin", "Lorg/elasticsearch/common/io/stream/StreamInput;", "alerting-core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IntervalSchedule readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)sin, (String)"sin");
            return new IntervalSchedule(sin);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

