/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.core.model;

import com.amazon.opendistroforelasticsearch.alerting.core.model.Schedule;
import com.cronutils.model.Cron;
import com.cronutils.model.time.ExecutionTime;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 62\u00020\u0001:\u00016B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u00c6\u0003J)\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010\nH\u0016J\u001e\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\"2\b\u0010#\u001a\u0004\u0018\u00010\nH\u0016J\u001e\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\"2\b\u0010%\u001a\u0004\u0018\u00010\nH\u0016J\t\u0010&\u001a\u00020'H\u00d6\u0001J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\u0012\u0010*\u001a\u00020\u001b2\b\u0010+\u001a\u0004\u0018\u00010\nH\u0016J\t\u0010,\u001a\u00020\u0006H\u00d6\u0001J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00067"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/core/model/CronSchedule;", "Lcom/amazon/opendistroforelasticsearch/alerting/core/model/Schedule;", "sin", "Lorg/elasticsearch/common/io/stream/StreamInput;", "(Lorg/elasticsearch/common/io/stream/StreamInput;)V", "expression", "", "timezone", "Ljava/time/ZoneId;", "testInstant", "Ljava/time/Instant;", "(Ljava/lang/String;Ljava/time/ZoneId;Ljava/time/Instant;)V", "executionTime", "Lcom/cronutils/model/time/ExecutionTime;", "getExecutionTime", "()Lcom/cronutils/model/time/ExecutionTime;", "getExpression", "()Ljava/lang/String;", "getTestInstant", "()Ljava/time/Instant;", "getTimezone", "()Ljava/time/ZoneId;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getExpectedNextExecutionTime", "enabledTime", "expectedPreviousExecutionTime", "getPeriodEndingAt", "Lkotlin/Pair;", "endTime", "getPeriodStartingAt", "startTime", "hashCode", "", "nextTimeToExecute", "Ljava/time/Duration;", "runningOnTime", "lastExecutionTime", "toString", "toXContent", "Lorg/elasticsearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/elasticsearch/common/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/elasticsearch/common/io/stream/StreamOutput;", "Companion", "alerting-core"})
public final class CronSchedule
extends Schedule {
    @NotNull
    private final transient ExecutionTime executionTime;
    @NotNull
    private final String expression;
    @NotNull
    private final ZoneId timezone;
    @Nullable
    private final transient Instant testInstant;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ExecutionTime getExecutionTime() {
        return this.executionTime;
    }

    @Override
    @Nullable
    public Duration nextTimeToExecute(@NotNull Instant enabledTime) {
        Intrinsics.checkParameterIsNotNull((Object)enabledTime, (String)"enabledTime");
        Instant instant = this.testInstant;
        if (instant == null) {
            instant = Instant.now();
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, this.timezone);
        Optional timeToNextExecution = this.executionTime.timeToNextExecution(zonedDateTime);
        return timeToNextExecution.orElse(null);
    }

    @Override
    @Nullable
    public Instant getExpectedNextExecutionTime(@NotNull Instant enabledTime, @Nullable Instant expectedPreviousExecutionTime) {
        Instant instant;
        Intrinsics.checkParameterIsNotNull((Object)enabledTime, (String)"enabledTime");
        Instant instant2 = expectedPreviousExecutionTime;
        if (instant2 == null) {
            instant2 = instant = this.testInstant;
        }
        if (instant2 == null) {
            instant = Instant.now();
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, this.timezone);
        Optional nextExecution = this.executionTime.nextExecution(zonedDateTime);
        ZonedDateTime zonedDateTime2 = nextExecution.orElse(null);
        return zonedDateTime2 != null ? zonedDateTime2.toInstant() : null;
    }

    @Override
    @NotNull
    public Pair<Instant, Instant> getPeriodStartingAt(@Nullable Instant startTime) {
        Instant instant;
        if (startTime != null) {
            instant = startTime;
        } else {
            Optional lastExecutionTime;
            Optional optional = lastExecutionTime = this.executionTime.lastExecution(ZonedDateTime.now(this.timezone));
            Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"lastExecutionTime");
            if (!optional.isPresent()) {
                Instant currentTime = Instant.now();
                return new Pair((Object)currentTime, (Object)currentTime);
            }
            instant = ((ZonedDateTime)lastExecutionTime.get()).toInstant();
        }
        Instant realStartTime = instant;
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(realStartTime, this.timezone);
        ZonedDateTime newEndTime = this.executionTime.nextExecution(zonedDateTime).orElse(null);
        Comparable<ChronoZonedDateTime<?>> comparable = newEndTime;
        if (comparable == null || (comparable = comparable.toInstant()) == null) {
            comparable = realStartTime;
        }
        return new Pair((Object)realStartTime, (Object)comparable);
    }

    @Override
    @NotNull
    public Pair<Instant, Instant> getPeriodEndingAt(@Nullable Instant endTime) {
        Instant instant;
        if (endTime != null) {
            instant = endTime;
        } else {
            Optional nextExecutionTime;
            Optional optional = nextExecutionTime = this.executionTime.nextExecution(ZonedDateTime.now(this.timezone));
            Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"nextExecutionTime");
            if (!optional.isPresent()) {
                Instant currentTime = Instant.now();
                return new Pair((Object)currentTime, (Object)currentTime);
            }
            instant = ((ZonedDateTime)nextExecutionTime.get()).toInstant();
        }
        Instant realEndTime = instant;
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(realEndTime, this.timezone);
        ZonedDateTime newStartTime = this.executionTime.lastExecution(zonedDateTime).orElse(null);
        Comparable<ChronoZonedDateTime<?>> comparable = newStartTime;
        if (comparable == null || (comparable = comparable.toInstant()) == null) {
            comparable = realEndTime;
        }
        return new Pair((Object)comparable, (Object)realEndTime);
    }

    @Override
    public boolean runningOnTime(@Nullable Instant lastExecutionTime) {
        Optional expectedExecutionTime;
        if (lastExecutionTime == null) {
            return true;
        }
        Instant instant = this.testInstant;
        if (instant == null) {
            instant = Instant.now();
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, this.timezone);
        Optional optional = expectedExecutionTime = this.executionTime.lastExecution(zonedDateTime);
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"expectedExecutionTime");
        if (!optional.isPresent()) {
            return false;
        }
        ZonedDateTime actualExecutionTime = ZonedDateTime.ofInstant(lastExecutionTime, this.timezone);
        return ChronoUnit.SECONDS.between((Temporal)expectedExecutionTime.get(), actualExecutionTime) == 0L;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        builder.startObject().startObject("cron").field("expression", this.expression).field("timezone", this.timezone.getId()).endObject().endObject();
        return builder;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        out.writeString(this.expression);
        out.writeZoneId(this.timezone);
    }

    @NotNull
    public final String getExpression() {
        return this.expression;
    }

    @NotNull
    public final ZoneId getTimezone() {
        return this.timezone;
    }

    @Nullable
    public final Instant getTestInstant() {
        return this.testInstant;
    }

    public CronSchedule(@NotNull String expression, @NotNull ZoneId timezone, @Nullable Instant testInstant) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)timezone, (String)"timezone");
        super(null);
        this.expression = expression;
        this.timezone = timezone;
        this.testInstant = testInstant;
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)Schedule.Companion.getCronParser().parse(this.expression));
        Intrinsics.checkExpressionValueIsNotNull((Object)executionTime, (String)"ExecutionTime.forCron(cr\u2026Parser.parse(expression))");
        this.executionTime = executionTime;
    }

    public /* synthetic */ CronSchedule(String string, ZoneId zoneId, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            instant = null;
        }
        this(string, zoneId, instant);
    }

    public CronSchedule(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sin.readString()");
        ZoneId zoneId = sin.readZoneId();
        Intrinsics.checkExpressionValueIsNotNull((Object)zoneId, (String)"sin.readZoneId()");
        this(string, zoneId, null, 4, null);
    }

    @NotNull
    public final String component1() {
        return this.expression;
    }

    @NotNull
    public final ZoneId component2() {
        return this.timezone;
    }

    @Nullable
    public final Instant component3() {
        return this.testInstant;
    }

    @NotNull
    public final CronSchedule copy(@NotNull String expression, @NotNull ZoneId timezone, @Nullable Instant testInstant) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)timezone, (String)"timezone");
        return new CronSchedule(expression, timezone, testInstant);
    }

    public static /* synthetic */ CronSchedule copy$default(CronSchedule cronSchedule, String string, ZoneId zoneId, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            string = cronSchedule.expression;
        }
        if ((n & 2) != 0) {
            zoneId = cronSchedule.timezone;
        }
        if ((n & 4) != 0) {
            instant = cronSchedule.testInstant;
        }
        return cronSchedule.copy(string, zoneId, instant);
    }

    @NotNull
    public String toString() {
        return "CronSchedule(expression=" + this.expression + ", timezone=" + this.timezone + ", testInstant=" + this.testInstant + ")";
    }

    public int hashCode() {
        String string = this.expression;
        ZoneId zoneId = this.timezone;
        Instant instant = this.testInstant;
        return ((string != null ? string.hashCode() : 0) * 31 + (zoneId != null ? ((Object)zoneId).hashCode() : 0)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof CronSchedule)) break block3;
                CronSchedule cronSchedule = (CronSchedule)object;
                if (!Intrinsics.areEqual((Object)this.expression, (Object)cronSchedule.expression) || !Intrinsics.areEqual((Object)this.timezone, (Object)cronSchedule.timezone) || !Intrinsics.areEqual((Object)this.testInstant, (Object)cronSchedule.testInstant)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final CronSchedule readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/core/model/CronSchedule$Companion;", "", "()V", "readFrom", "Lcom/amazon/opendistroforelasticsearch/alerting/core/model/CronSchedule;", "sin", "Lorg/elasticsearch/common/io/stream/StreamInput;", "alerting-core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final CronSchedule readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)sin, (String)"sin");
            return new CronSchedule(sin);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

