/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.core;

import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/core/ScheduledJobIndices;", "", "client", "Lorg/elasticsearch/client/AdminClient;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "(Lorg/elasticsearch/client/AdminClient;Lorg/elasticsearch/cluster/service/ClusterService;)V", "initScheduledJobIndex", "", "actionListener", "Lorg/elasticsearch/action/ActionListener;", "Lorg/elasticsearch/action/admin/indices/create/CreateIndexResponse;", "scheduledJobIndexExists", "", "scheduledJobIndexHealth", "Lorg/elasticsearch/cluster/health/ClusterIndexHealth;", "Companion", "alerting-core"})
public final class ScheduledJobIndices {
    private final AdminClient client;
    private final ClusterService clusterService;
    public static final Companion Companion = new Companion(null);

    public final void initScheduledJobIndex(@NotNull ActionListener<CreateIndexResponse> actionListener) {
        Intrinsics.checkParameterIsNotNull(actionListener, (String)"actionListener");
        if (!this.scheduledJobIndexExists()) {
            CreateIndexRequest indexRequest = new CreateIndexRequest(".opendistro-alerting-config").mapping("_doc", Companion.scheduledJobMappings(), XContentType.JSON).settings(Settings.builder().put("index.hidden", true).build());
            this.client.indices().create(indexRequest, actionListener);
        }
    }

    public final boolean scheduledJobIndexExists() {
        ClusterState clusterState;
        ClusterState clusterState2 = clusterState = this.clusterService.state();
        Intrinsics.checkExpressionValueIsNotNull((Object)clusterState2, (String)"clusterState");
        return clusterState2.getRoutingTable().hasIndex(".opendistro-alerting-config");
    }

    @Nullable
    public final ClusterIndexHealth scheduledJobIndexHealth() {
        ClusterIndexHealth indexHealth = null;
        if (this.scheduledJobIndexExists()) {
            ClusterState clusterState = this.clusterService.state();
            Intrinsics.checkExpressionValueIsNotNull((Object)clusterState, (String)"clusterService.state()");
            IndexRoutingTable indexRoutingTable = clusterState.getRoutingTable().index(".opendistro-alerting-config");
            IndexMetadata indexMetaData = this.clusterService.state().metadata().index(".opendistro-alerting-config");
            indexHealth = new ClusterIndexHealth(indexMetaData, indexRoutingTable);
        }
        return indexHealth;
    }

    public ScheduledJobIndices(@NotNull AdminClient client, @NotNull ClusterService clusterService) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        this.client = client;
        this.clusterService = clusterService;
    }

    @JvmStatic
    @NotNull
    public static final String scheduledJobMappings() {
        return Companion.scheduledJobMappings();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/core/ScheduledJobIndices$Companion;", "", "()V", "scheduledJobMappings", "", "alerting-core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final String scheduledJobMappings() {
            URL uRL = ScheduledJobIndices.class.getClassLoader().getResource("mappings/scheduled-jobs.json");
            Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"ScheduledJobIndices::cla\u2026ngs/scheduled-jobs.json\")");
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            boolean bl2 = false;
            boolean bl3 = false;
            return new String(byArray, charset);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

