/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.alerting.core;

import com.amazon.opendistroforelasticsearch.alerting.core.JobSweeper;
import com.amazon.opendistroforelasticsearch.alerting.core.JobSweeperMetrics;
import com.amazon.opendistroforelasticsearch.alerting.core.ShardNodes;
import com.amazon.opendistroforelasticsearch.alerting.core.model.ScheduledJob;
import com.amazon.opendistroforelasticsearch.alerting.core.schedule.JobScheduler;
import com.amazon.opendistroforelasticsearch.alerting.core.settings.ScheduledJobSettings;
import com.amazon.opendistroforelasticsearch.alerting.elasticapi.ElasticExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BC\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0016J\b\u00102\u001a\u000200H\u0016J\u0010\u00103\u001a\u0002002\u0006\u00104\u001a\u000205H\u0016J\u0006\u00106\u001a\u000200J\u0006\u00107\u001a\u000200J\b\u00108\u001a\u00020\u001cH\u0002J\u0006\u00109\u001a\u00020:J\b\u0010;\u001a\u000200H\u0002J\u001c\u0010<\u001a\u00020(2\u0006\u0010=\u001a\u00020,2\n\u0010>\u001a\u00060\u0012j\u0002`-H\u0002J\u0010\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020AH\u0002J\u0006\u0010B\u001a\u00020(JD\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010@\u001a\u00020A2\u0006\u0010=\u001a\u00020,2\n\u0010>\u001a\u00060\u0012j\u0002`-2\n\u0010E\u001a\u00060\u0018j\u0002`.2\u0006\u0010F\u001a\u00020G2\b\b\u0002\u0010H\u001a\u00020(H\u0002J0\u0010I\u001a\u00020D2\u0006\u0010@\u001a\u00020A2\n\u0010>\u001a\u00060\u0012j\u0002`-2\n\u0010E\u001a\u00060\u0018j\u0002`.2\u0006\u0010H\u001a\u00020(H\u0002J \u0010J\u001a\u0002002\u0006\u0010=\u001a\u00020,2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0016J \u0010O\u001a\u0002002\u0006\u0010=\u001a\u00020,2\u0006\u0010P\u001a\u00020Q2\u0006\u0010M\u001a\u00020RH\u0016J<\u0010S\u001a\u0002002\u0006\u0010=\u001a\u00020,2\n\u0010>\u001a\u00060\u0012j\u0002`-2\n\u0010T\u001a\u00060\u0018j\u0002`.2\b\u0010U\u001a\u0004\u0018\u00010D2\b\b\u0002\u0010V\u001a\u00020(H\u0002J\b\u0010W\u001a\u000200H\u0002J\"\u0010X\u001a\u0002002\u0006\u0010=\u001a\u00020,2\u0006\u0010Y\u001a\u00020Z2\b\b\u0002\u0010[\u001a\u00020\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u0016*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010 \u001a\n \u0016*\u0004\u0018\u00010!0!X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u0018\u0010#\u001a\n \u0016*\u0004\u0018\u00010!0!X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u0016\u0010$\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n \u0016*\u0004\u0018\u00010&0&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010'\u001a\n \u0016*\u0004\u0018\u00010(0(X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010)R.\u0010*\u001a\"\u0012\u0004\u0012\u00020,\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\u0012j\u0002`-\u0012\b\u0012\u00060\u0018j\u0002`.0+0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lcom/amazon/opendistroforelasticsearch/alerting/core/JobSweeper;", "Lorg/elasticsearch/cluster/ClusterStateListener;", "Lorg/elasticsearch/index/shard/IndexingOperationListener;", "Lorg/elasticsearch/common/component/LifecycleListener;", "settings", "Lorg/elasticsearch/common/settings/Settings;", "client", "Lorg/elasticsearch/client/Client;", "clusterService", "Lorg/elasticsearch/cluster/service/ClusterService;", "threadPool", "Lorg/elasticsearch/threadpool/ThreadPool;", "xContentRegistry", "Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;", "scheduler", "Lcom/amazon/opendistroforelasticsearch/alerting/core/schedule/JobScheduler;", "sweepableJobTypes", "", "", "(Lorg/elasticsearch/common/settings/Settings;Lorg/elasticsearch/client/Client;Lorg/elasticsearch/cluster/service/ClusterService;Lorg/elasticsearch/threadpool/ThreadPool;Lorg/elasticsearch/common/xcontent/NamedXContentRegistry;Lcom/amazon/opendistroforelasticsearch/alerting/core/schedule/JobScheduler;Ljava/util/List;)V", "fullSweepExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "lastFullSweepTimeNano", "", "logger", "Lorg/apache/logging/log4j/Logger;", "requestTimeout", "Lorg/elasticsearch/common/unit/TimeValue;", "scheduledFullSweep", "Lorg/elasticsearch/threadpool/Scheduler$Cancellable;", "sweepBackoffMillis", "sweepBackoffRetryCount", "", "Ljava/lang/Integer;", "sweepPageSize", "sweepPeriod", "sweepSearchBackoff", "Lorg/elasticsearch/action/bulk/BackoffPolicy;", "sweeperEnabled", "", "Ljava/lang/Boolean;", "sweptJobs", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/elasticsearch/index/shard/ShardId;", "Lcom/amazon/opendistroforelasticsearch/alerting/core/JobId;", "Lcom/amazon/opendistroforelasticsearch/alerting/core/JobVersion;", "afterStart", "", "beforeClose", "beforeStop", "clusterChanged", "event", "Lorg/elasticsearch/cluster/ClusterChangedEvent;", "disable", "enable", "getFullSweepElapsedTime", "getJobSweeperMetrics", "Lcom/amazon/opendistroforelasticsearch/alerting/core/JobSweeperMetrics;", "initBackgroundSweep", "isOwningNode", "shardId", "jobId", "isSweepableJobType", "xcp", "Lorg/elasticsearch/common/xcontent/XContentParser;", "isSweepingEnabled", "parseAndSweepJob", "Lcom/amazon/opendistroforelasticsearch/alerting/core/model/ScheduledJob;", "jobVersion", "jobSource", "Lorg/elasticsearch/common/bytes/BytesReference;", "typeIsParsed", "parseScheduledJob", "postDelete", "delete", "Lorg/elasticsearch/index/engine/Engine$Delete;", "result", "Lorg/elasticsearch/index/engine/Engine$DeleteResult;", "postIndex", "index", "Lorg/elasticsearch/index/engine/Engine$Index;", "Lorg/elasticsearch/index/engine/Engine$IndexResult;", "sweep", "newVersion", "job", "failedToParse", "sweepAllShards", "sweepShard", "shardNodes", "Lcom/amazon/opendistroforelasticsearch/alerting/core/ShardNodes;", "startAfter", "alerting-core"})
public final class JobSweeper
extends LifecycleListener
implements ClusterStateListener,
IndexingOperationListener {
    private final Logger logger;
    private final ExecutorService fullSweepExecutor;
    private final ConcurrentHashMap<ShardId, ConcurrentHashMap<String, Long>> sweptJobs;
    private Scheduler.Cancellable scheduledFullSweep;
    private volatile long lastFullSweepTimeNano;
    private volatile TimeValue requestTimeout;
    private volatile TimeValue sweepPeriod;
    private volatile Boolean sweeperEnabled;
    private volatile Integer sweepPageSize;
    private volatile TimeValue sweepBackoffMillis;
    private volatile Integer sweepBackoffRetryCount;
    private volatile BackoffPolicy sweepSearchBackoff;
    private final Settings settings;
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final NamedXContentRegistry xContentRegistry;
    private final JobScheduler scheduler;
    private final List<String> sweepableJobTypes;

    public void afterStart() {
        this.initBackgroundSweep();
    }

    public void beforeStop() {
        block0: {
            Scheduler.Cancellable cancellable = this.scheduledFullSweep;
            if (cancellable == null) break block0;
            cancellable.cancel();
        }
    }

    public void beforeClose() {
        this.fullSweepExecutor.shutdown();
    }

    public void clusterChanged(@NotNull ClusterChangedEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!this.isSweepingEnabled()) {
            return;
        }
        if (!event.indexRoutingTableChanged(".opendistro-alerting-config")) {
            return;
        }
        this.logger.debug("Scheduled Jobs routing table changed. Running full sweep...");
        this.fullSweepExecutor.submit(new Runnable(this){
            final /* synthetic */ JobSweeper this$0;

            public final void run() {
                JobSweeper.access$sweepAllShards(this.this$0);
            }
            {
                this.this$0 = jobSweeper;
            }
        });
    }

    public void postIndex(@NotNull ShardId shardId, @NotNull Engine.Index index, @NotNull Engine.IndexResult result) {
        Intrinsics.checkParameterIsNotNull((Object)shardId, (String)"shardId");
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        if (!this.isSweepingEnabled()) {
            return;
        }
        if (result.getResultType() != Engine.Result.Type.SUCCESS) {
            ConcurrentHashMap<String, Long> concurrentHashMap = this.sweptJobs.get(shardId);
            Map shardJobs = concurrentHashMap != null ? (Map)concurrentHashMap : MapsKt.emptyMap();
            Long l = (Long)shardJobs.get(index.id());
            long currentVersion = l != null ? l : -1L;
            this.logger.debug("Indexing failed for ScheduledJob: " + index.id() + ". Continuing with current version " + currentVersion);
            return;
        }
        String string = index.id();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"index.id()");
        if (this.isOwningNode(shardId, string)) {
            XContentParser xcp;
            XContentParser xContentParser = xcp = XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)index.source(), (XContentType)XContentType.JSON);
            Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"xcp");
            if (this.isSweepableJobType(xContentParser)) {
                String string2 = index.id();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"index.id()");
                long l = result.getVersion();
                BytesReference bytesReference = index.source();
                Intrinsics.checkExpressionValueIsNotNull((Object)bytesReference, (String)"index.source()");
                ScheduledJob job = this.parseAndSweepJob(xcp, shardId, string2, l, bytesReference, true);
                if (job != null) {
                    this.scheduler.postIndex(job);
                }
            } else {
                this.logger.debug("Not a valid job type in document " + index.id() + " to sweep.");
            }
        }
    }

    public void postDelete(@NotNull ShardId shardId, @NotNull Engine.Delete delete, @NotNull Engine.DeleteResult result) {
        Intrinsics.checkParameterIsNotNull((Object)shardId, (String)"shardId");
        Intrinsics.checkParameterIsNotNull((Object)delete, (String)"delete");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        if (!this.isSweepingEnabled()) {
            return;
        }
        if (result.getResultType() != Engine.Result.Type.SUCCESS) {
            ConcurrentHashMap<String, Long> concurrentHashMap = this.sweptJobs.get(shardId);
            Map shardJobs = concurrentHashMap != null ? (Map)concurrentHashMap : MapsKt.emptyMap();
            Long l = (Long)shardJobs.get(delete.id());
            long currentVersion = l != null ? l : -1L;
            this.logger.debug("Deletion failed for ScheduledJob: " + delete.id() + ". Continuing with current version " + currentVersion);
            return;
        }
        String string = delete.id();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"delete.id()");
        if (this.isOwningNode(shardId, string)) {
            if (this.scheduler.scheduledJobs().contains(delete.id())) {
                String string2 = delete.id();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"delete.id()");
                JobSweeper.sweep$default(this, shardId, string2, result.getVersion(), null, false, 16, null);
            }
            String string3 = delete.id();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"delete.id()");
            this.scheduler.postDelete(string3);
        }
    }

    public final void enable() {
        this.initBackgroundSweep();
        this.sweeperEnabled = true;
    }

    public final void disable() {
        Scheduler.Cancellable cancellable = this.scheduledFullSweep;
        if (cancellable != null) {
            cancellable.cancel();
        }
        this.logger.info("Descheduling all jobs as sweeping is disabled");
        this.scheduler.deschedule((Collection<String>)this.scheduler.scheduledJobs());
        this.sweeperEnabled = false;
    }

    public final boolean isSweepingEnabled() {
        return Intrinsics.areEqual((Object)this.sweeperEnabled, (Object)true);
    }

    private final void initBackgroundSweep() {
        if (!this.isSweepingEnabled()) {
            return;
        }
        Scheduler.Cancellable cancellable = this.scheduledFullSweep;
        if (cancellable != null) {
            cancellable.cancel();
        }
        Runnable scheduledSweep2 = new Runnable(this){
            final /* synthetic */ JobSweeper this$0;

            public final void run() {
                TimeValue elapsedTime = JobSweeper.access$getFullSweepElapsedTime(this.this$0);
                TimeValue timeValue = JobSweeper.access$getSweepPeriod$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)timeValue, (String)"sweepPeriod");
                long delta = timeValue.getMillis() - elapsedTime.getMillis();
                if (delta < 20L) {
                    JobSweeper.access$getFullSweepExecutor$p(this.this$0).submit(new Runnable(this){
                        final /* synthetic */ initBackgroundSweep.scheduledSweep.1 this$0;

                        public final void run() {
                            JobSweeper.access$getLogger$p(this.this$0.this$0).debug("Performing background sweep of scheduled jobs.");
                            JobSweeper.access$sweepAllShards(this.this$0.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.this$0 = jobSweeper;
            }
        };
        this.scheduledFullSweep = this.threadPool.scheduleWithFixedDelay(scheduledSweep2, this.sweepPeriod, "same");
    }

    /*
     * WARNING - void declaration
     */
    private final void sweepAllShards() {
        Object $dstr$_u24__u24$shards;
        Object $this$groupByTo$iv$iv;
        ShardRouting it;
        Iterable $this$filterTo$iv$iv;
        ClusterState clusterState;
        ClusterState clusterState2 = clusterState = this.clusterService.state();
        Intrinsics.checkExpressionValueIsNotNull((Object)clusterState2, (String)"clusterState");
        if (!clusterState2.getRoutingTable().hasIndex(".opendistro-alerting-config")) {
            this.scheduler.deschedule((Collection<String>)this.scheduler.scheduledJobs());
            this.sweptJobs.clear();
            this.lastFullSweepTimeNano = System.nanoTime();
            return;
        }
        DiscoveryNodes discoveryNodes = clusterState.getNodes();
        Intrinsics.checkExpressionValueIsNotNull((Object)discoveryNodes, (String)"clusterState.nodes");
        String localNodeId = discoveryNodes.getLocalNodeId();
        List list = clusterState.getRoutingTable().allShards(".opendistro-alerting-config");
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"clusterState.routingTabl\u2026Job.SCHEDULED_JOBS_INDEX)");
        Object $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ShardRouting)element$iv$iv;
            boolean bl = false;
            if (!it.active()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            it = (ShardRouting)element$iv$iv;
            boolean bl = false;
            ShardId key$iv$iv = it.shardId();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = destination$iv$iv;
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv;
        boolean element$iv$iv = false;
        for (Map.Entry element$iv$iv2 : iterator.entrySet()) {
            boolean bl;
            block14: {
                $dstr$_u24__u24$shards = element$iv$iv2;
                boolean bl3 = false;
                Map.Entry $i$f$getOrPut = $dstr$_u24__u24$shards;
                boolean value$iv$iv$iv = false;
                List shards = (List)$i$f$getOrPut.getValue();
                Iterable $this$any$iv = shards;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ShardRouting it2 = (ShardRouting)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it2.currentNodeId(), (Object)localNodeId)) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        Object localShards = destination$iv$iv;
        ConcurrentHashMap.KeySetView keySetView = (ConcurrentHashMap.KeySetView)this.sweptJobs.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)keySetView, (String)"sweptJobs.keys");
        Set removedShards = SetsKt.minus((Set)keySetView, (Iterable)localShards.keySet());
        Object $this$forEach$iv = removedShards;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            ShardId shardId = (ShardId)element$iv;
            boolean bl = false;
            ConcurrentHashMap<String, Long> concurrentHashMap = this.sweptJobs.remove(shardId);
            Map shardJobs = concurrentHashMap != null ? (Map)concurrentHashMap : MapsKt.emptyMap();
            this.scheduler.deschedule(shardJobs.keySet());
        }
        $this$forEach$iv = localShards;
        $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl = false;
        iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void shardId;
            Map.Entry element$iv;
            Map.Entry $dstr$shardId$shards = element$iv = iterator.next();
            boolean bl5 = false;
            $dstr$_u24__u24$shards = $dstr$shardId$shards;
            boolean bl3 = false;
            ShardId $this$any$iv = (ShardId)$dstr$_u24__u24$shards.getKey();
            $dstr$_u24__u24$shards = $dstr$shardId$shards;
            bl3 = false;
            List shards = (List)$dstr$_u24__u24$shards.getValue();
            try {
                void var20_35;
                String string;
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)shardId, (String)"shardId");
                Intrinsics.checkExpressionValueIsNotNull((Object)localNodeId, (String)"localNodeId");
                $dstr$_u24__u24$shards = shards;
                JobSweeper jobSweeper = this;
                boolean $i$f$map = false;
                void var22_39 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    ShardRouting shardRouting = (ShardRouting)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl6 = false;
                    String string2 = it3.currentNodeId();
                    collection.add(string2);
                }
                collection = (List)destination$iv$iv2;
                Collection collection2 = collection;
                String string3 = string;
                JobSweeper.sweepShard$default(jobSweeper, (ShardId)var20_35, new ShardNodes(string3, collection2), null, 4, null);
            }
            catch (Exception e) {
                Logger shardLogger = Loggers.getLogger(((Object)((Object)this)).getClass(), (ShardId)shardId, (String[])new String[0]);
                shardLogger.error("Error while sweeping shard " + shardId, (Throwable)e);
            }
        }
        this.lastFullSweepTimeNano = System.nanoTime();
    }

    private final void sweepShard(ShardId shardId, ShardNodes shardNodes, String startAfter) {
        Iterator $this$filterNotTo$iv$iv;
        Logger logger = Loggers.getLogger(((Object)((Object)this)).getClass(), (ShardId)shardId, (String[])new String[0]);
        logger.debug("Sweeping shard " + shardId);
        ConcurrentMap $this$getOrPut$iv = this.sweptJobs;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(shardId);
        if (object == null) {
            boolean bl = false;
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            boolean bl2 = false;
            boolean bl3 = false;
            ConcurrentHashMap default$iv = concurrentHashMap;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(shardId, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        ConcurrentHashMap currentJobs = (ConcurrentHashMap)object;
        ConcurrentHashMap.KeySetView keySetView = (ConcurrentHashMap.KeySetView)currentJobs.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)keySetView, (String)"currentJobs.keys");
        Iterable $this$filterNot$iv = keySetView;
        boolean $i$f$filterNot = false;
        Iterable bl = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            String it = (String)element$iv$iv;
            boolean bl5 = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            if (shardNodes.isOwningNode(string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl6 = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            this.scheduler.deschedule(string);
            currentJobs.remove(it);
        }
        String searchAfter = startAfter;
        while (searchAfter != null) {
            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
            Iterable $this$forEach$iv2 = this.sweepableJobTypes;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String it = (String)element$iv;
                boolean bl7 = false;
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.existsQuery((String)it));
            }
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{".opendistro-alerting-config"}).preference("_shards:" + shardId.getId() + "|_only_local");
            SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().version(Boolean.valueOf(true)).sort((SortBuilder)new FieldSortBuilder("_id").unmappedType("keyword").missing((Object)"_last")).searchAfter((Object[])new String[]{searchAfter});
            Integer n = this.sweepPageSize;
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"sweepPageSize");
            SearchRequest jobSearchRequest = searchRequest.source(searchSourceBuilder.size(n.intValue()).query((QueryBuilder)boolQueryBuilder));
            BackoffPolicy backoffPolicy = this.sweepSearchBackoff;
            Intrinsics.checkExpressionValueIsNotNull((Object)backoffPolicy, (String)"sweepSearchBackoff");
            SearchResponse response2 = (SearchResponse)ElasticExtensionsKt.retry(backoffPolicy, (Function0)new Function0<SearchResponse>(this, jobSearchRequest){
                final /* synthetic */ JobSweeper this$0;
                final /* synthetic */ SearchRequest $jobSearchRequest;

                public final SearchResponse invoke() {
                    return (SearchResponse)JobSweeper.access$getClient$p(this.this$0).search(this.$jobSearchRequest).actionGet(JobSweeper.access$getRequestTimeout$p(this.this$0));
                }
                {
                    this.this$0 = jobSweeper;
                    this.$jobSearchRequest = searchRequest;
                    super(0);
                }
            });
            if (response2.status() != RestStatus.OK) {
                String string = "Error sweeping shard " + shardId + '.';
                SearchResponse searchResponse = response2;
                Intrinsics.checkExpressionValueIsNotNull((Object)searchResponse, (String)"response");
                logger.error(string, (Object)ElasticExtensionsKt.firstFailureOrNull(searchResponse));
                return;
            }
            SearchResponse searchResponse = response2;
            Intrinsics.checkExpressionValueIsNotNull((Object)searchResponse, (String)"response");
            Iterator iterator2 = searchResponse.getHits().iterator();
            while (iterator2.hasNext()) {
                XContentParser xcp;
                SearchHit hit;
                SearchHit searchHit = hit = (SearchHit)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)searchHit, (String)"hit");
                String string = searchHit.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hit.id");
                if (!shardNodes.isOwningNode(string)) continue;
                XContentParser xContentParser = xcp = XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)hit.getSourceRef(), (XContentType)XContentType.JSON);
                Intrinsics.checkExpressionValueIsNotNull((Object)xContentParser, (String)"xcp");
                String string2 = hit.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"hit.id");
                long l = hit.getVersion();
                BytesReference bytesReference = hit.getSourceRef();
                Intrinsics.checkExpressionValueIsNotNull((Object)bytesReference, (String)"hit.sourceRef");
                JobSweeper.parseAndSweepJob$default(this, xContentParser, shardId, string2, l, bytesReference, false, 32, null);
            }
            SearchHits searchHits = response2.getHits();
            Intrinsics.checkExpressionValueIsNotNull((Object)searchHits, (String)"response.hits");
            SearchHit searchHit = (SearchHit)CollectionsKt.lastOrNull((Iterable)((Iterable)searchHits));
            searchAfter = searchHit != null ? searchHit.getId() : null;
        }
    }

    static /* synthetic */ void sweepShard$default(JobSweeper jobSweeper, ShardId shardId, ShardNodes shardNodes, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        jobSweeper.sweepShard(shardId, shardNodes, string);
    }

    private final void sweep(ShardId shardId, String jobId, long newVersion, ScheduledJob job, boolean failedToParse) {
        ConcurrentMap $this$getOrPut$iv = this.sweptJobs;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(shardId);
        if (object == null) {
            boolean bl = false;
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            boolean bl2 = false;
            boolean bl3 = false;
            ConcurrentHashMap default$iv = concurrentHashMap;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(shardId, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        ((ConcurrentHashMap)object).compute(jobId, (BiFunction)new BiFunction<String, Long, Long>(this, newVersion, jobId, failedToParse, job){
            final /* synthetic */ JobSweeper this$0;
            final /* synthetic */ long $newVersion;
            final /* synthetic */ String $jobId;
            final /* synthetic */ boolean $failedToParse;
            final /* synthetic */ ScheduledJob $job;

            @Nullable
            public final Long apply(@NotNull String $noName_0, @Nullable Long currentVersion) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Long l = currentVersion;
                if (l == null) {
                    l = -1L;
                }
                if (this.$newVersion <= l) {
                    JobSweeper.access$getLogger$p(this.this$0).debug("Skipping job " + this.$jobId + ", " + this.$newVersion + " <= " + currentVersion);
                    return currentVersion;
                }
                if (JobSweeper.access$getScheduler$p(this.this$0).scheduledJobs().contains(this.$jobId)) {
                    JobSweeper.access$getScheduler$p(this.this$0).deschedule(this.$jobId);
                }
                if (this.$failedToParse) {
                    return currentVersion;
                }
                if (this.$job != null) {
                    if (this.$job.getEnabled()) {
                        JobSweeper.access$getScheduler$p(this.this$0).schedule(this.$job);
                    }
                    return this.$newVersion;
                }
                return null;
            }
            {
                this.this$0 = jobSweeper;
                this.$newVersion = l;
                this.$jobId = string;
                this.$failedToParse = bl;
                this.$job = scheduledJob;
            }
        });
    }

    static /* synthetic */ void sweep$default(JobSweeper jobSweeper, ShardId shardId, String string, long l, ScheduledJob scheduledJob, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        jobSweeper.sweep(shardId, string, l, scheduledJob, bl);
    }

    private final ScheduledJob parseAndSweepJob(XContentParser xcp, ShardId shardId, String jobId, long jobVersion, BytesReference jobSource, boolean typeIsParsed) {
        ScheduledJob scheduledJob;
        try {
            ScheduledJob job = this.parseScheduledJob(xcp, jobId, jobVersion, typeIsParsed);
            JobSweeper.sweep$default(this, shardId, jobId, jobVersion, job, false, 16, null);
            scheduledJob = job;
        }
        catch (Exception e) {
            this.logger.warn("Unable to parse ScheduledJob source: {}", (Object)Strings.cleanTruncate((String)jobSource.utf8ToString(), (int)1000));
            this.sweep(shardId, jobId, jobVersion, null, true);
            scheduledJob = null;
        }
        return scheduledJob;
    }

    static /* synthetic */ ScheduledJob parseAndSweepJob$default(JobSweeper jobSweeper, XContentParser xContentParser, ShardId shardId, String string, long l, BytesReference bytesReference, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return jobSweeper.parseAndSweepJob(xContentParser, shardId, string, l, bytesReference, bl);
    }

    private final ScheduledJob parseScheduledJob(XContentParser xcp, String jobId, long jobVersion, boolean typeIsParsed) {
        ScheduledJob scheduledJob;
        if (typeIsParsed) {
            String string = xcp.currentName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"xcp.currentName()");
            scheduledJob = ScheduledJob.Companion.parse(xcp, string, jobId, jobVersion);
        } else {
            scheduledJob = ScheduledJob.Companion.parse(xcp, jobId, jobVersion);
        }
        return scheduledJob;
    }

    private final TimeValue getFullSweepElapsedTime() {
        TimeValue timeValue = TimeValue.timeValueNanos((long)(System.nanoTime() - this.lastFullSweepTimeNano));
        Intrinsics.checkExpressionValueIsNotNull((Object)timeValue, (String)"TimeValue.timeValueNanos\u2026 - lastFullSweepTimeNano)");
        return timeValue;
    }

    @NotNull
    public final JobSweeperMetrics getJobSweeperMetrics() {
        if (!this.isSweepingEnabled()) {
            return new JobSweeperMetrics(-1L, true);
        }
        TimeValue elapsedTime = this.getFullSweepElapsedTime();
        long l = elapsedTime.getMillis();
        long l2 = elapsedTime.getMillis();
        TimeValue timeValue = this.sweepPeriod;
        Intrinsics.checkExpressionValueIsNotNull((Object)timeValue, (String)"sweepPeriod");
        return new JobSweeperMetrics(l, l2 <= timeValue.getMillis());
    }

    private final boolean isSweepableJobType(XContentParser xcp) {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        String jobType = xcp.currentName();
        return this.sweepableJobTypes.contains(jobType);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isOwningNode(ShardId shardId, String jobId) {
        void $this$mapTo$iv$iv;
        ShardRouting it;
        Iterable $this$filterTo$iv$iv;
        DiscoveryNode discoveryNode = this.clusterService.localNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)discoveryNode, (String)"clusterService.localNode()");
        String localNodeId = discoveryNode.getId();
        ClusterState clusterState = this.clusterService.state();
        Intrinsics.checkExpressionValueIsNotNull((Object)clusterState, (String)"clusterService.state()");
        IndexShardRoutingTable indexShardRoutingTable = clusterState.getRoutingTable().shardRoutingTable(shardId);
        Intrinsics.checkExpressionValueIsNotNull((Object)indexShardRoutingTable, (String)"clusterService.state().r\u2026hardRoutingTable(shardId)");
        Iterable $this$filter$iv = (Iterable)indexShardRoutingTable;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ShardRouting)element$iv$iv;
            boolean bl = false;
            if (!it.active()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ShardRouting)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.currentNodeId();
            collection.add(string);
        }
        List shardNodeIds = (List)destination$iv$iv;
        String string = localNodeId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localNodeId");
        ShardNodes shardNodes = new ShardNodes(string, shardNodeIds);
        return shardNodes.isOwningNode(jobId);
    }

    public JobSweeper(@NotNull Settings settings, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull NamedXContentRegistry xContentRegistry, @NotNull JobScheduler scheduler, @NotNull List<String> sweepableJobTypes) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)clusterService, (String)"clusterService");
        Intrinsics.checkParameterIsNotNull((Object)threadPool, (String)"threadPool");
        Intrinsics.checkParameterIsNotNull((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
        Intrinsics.checkParameterIsNotNull(sweepableJobTypes, (String)"sweepableJobTypes");
        this.settings = settings;
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.scheduler = scheduler;
        this.sweepableJobTypes = sweepableJobTypes;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.fullSweepExecutor = Executors.newSingleThreadExecutor(EsExecutors.daemonThreadFactory((String)"opendistro_job_sweeper"));
        this.sweptJobs = new ConcurrentHashMap();
        this.lastFullSweepTimeNano = System.nanoTime();
        this.requestTimeout = (TimeValue)ScheduledJobSettings.Companion.getREQUEST_TIMEOUT().get(this.settings);
        this.sweepPeriod = (TimeValue)ScheduledJobSettings.Companion.getSWEEP_PERIOD().get(this.settings);
        this.sweeperEnabled = (Boolean)ScheduledJobSettings.Companion.getSWEEPER_ENABLED().get(this.settings);
        this.sweepPageSize = (Integer)ScheduledJobSettings.Companion.getSWEEP_PAGE_SIZE().get(this.settings);
        this.sweepBackoffMillis = (TimeValue)ScheduledJobSettings.Companion.getSWEEP_BACKOFF_MILLIS().get(this.settings);
        Integer n = this.sweepBackoffRetryCount = (Integer)ScheduledJobSettings.Companion.getSWEEP_BACKOFF_RETRY_COUNT().get(this.settings);
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"sweepBackoffRetryCount");
        this.sweepSearchBackoff = BackoffPolicy.exponentialBackoff((TimeValue)this.sweepBackoffMillis, (int)n);
        this.clusterService.addListener((ClusterStateListener)this);
        this.clusterService.addLifecycleListener((LifecycleListener)this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getSWEEP_PERIOD(), (Consumer)new Consumer<TimeValue>(){

            @Override
            public final void accept(TimeValue it) {
                logger.debug("Reinitializing background full sweep with period: " + sweepPeriod.minutes());
                sweepPeriod = it;
                this.initBackgroundSweep();
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getSWEEPER_ENABLED(), (Consumer)new Consumer<Boolean>(){

            @Override
            public final void accept(Boolean it) {
                sweeperEnabled = it;
                if (!sweeperEnabled.booleanValue()) {
                    this.disable();
                } else {
                    this.enable();
                }
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getSWEEP_BACKOFF_MILLIS(), (Consumer)new Consumer<TimeValue>(){

            @Override
            public final void accept(TimeValue it) {
                sweepBackoffMillis = it;
                TimeValue timeValue = sweepBackoffMillis;
                Integer n = sweepBackoffRetryCount;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"sweepBackoffRetryCount");
                sweepSearchBackoff = BackoffPolicy.exponentialBackoff((TimeValue)timeValue, (int)n);
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getSWEEP_BACKOFF_RETRY_COUNT(), (Consumer)new Consumer<Integer>(){

            @Override
            public final void accept(Integer it) {
                sweepBackoffRetryCount = it;
                TimeValue timeValue = sweepBackoffMillis;
                Integer n = sweepBackoffRetryCount;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"sweepBackoffRetryCount");
                sweepSearchBackoff = BackoffPolicy.exponentialBackoff((TimeValue)timeValue, (int)n);
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getSWEEP_PAGE_SIZE(), (Consumer)new Consumer<Integer>(){

            @Override
            public final void accept(Integer it) {
                sweepPageSize = it;
            }
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getREQUEST_TIMEOUT(), (Consumer)new Consumer<TimeValue>(){

            @Override
            public final void accept(TimeValue it) {
                requestTimeout = it;
            }
        });
    }

    public static final /* synthetic */ void access$sweepAllShards(JobSweeper $this) {
        $this.sweepAllShards();
    }

    public static final /* synthetic */ TimeValue access$getFullSweepElapsedTime(JobSweeper $this) {
        return $this.getFullSweepElapsedTime();
    }

    public static final /* synthetic */ ExecutorService access$getFullSweepExecutor$p(JobSweeper $this) {
        return $this.fullSweepExecutor;
    }

    public static final /* synthetic */ Client access$getClient$p(JobSweeper $this) {
        return $this.client;
    }

    public static final /* synthetic */ TimeValue access$getRequestTimeout$p(JobSweeper $this) {
        return $this.requestTimeout;
    }

    public static final /* synthetic */ JobScheduler access$getScheduler$p(JobSweeper $this) {
        return $this.scheduler;
    }

    public static final /* synthetic */ BackoffPolicy access$getSweepSearchBackoff$p(JobSweeper $this) {
        return $this.sweepSearchBackoff;
    }

    public static final /* synthetic */ Integer access$getSweepPageSize$p(JobSweeper $this) {
        return $this.sweepPageSize;
    }
}

