/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.threads;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerThreads;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.threads.exceptions.PAThreadException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadProvider {
    private static final Logger LOG = LogManager.getLogger(ThreadProvider.class);
    private static final String PA_THREADS_STARTED_METRIC_NAME = "NumberOfPAThreadsStarted";
    private static final String PA_THREADS_ENDED_METRIC_NAME = "NumberOfPAThreadsEnded";

    public Thread createThreadForRunnable(Runnable innerRunnable, PerformanceAnalyzerThreads paThread, String threadNameAppender) {
        StringBuilder threadName = new StringBuilder(paThread.toString());
        if (!threadNameAppender.isEmpty()) {
            threadName.append("-").append(threadNameAppender);
        }
        String threadNameStr = threadName.toString();
        Thread t = new Thread(() -> {
            try {
                innerRunnable.run();
            }
            catch (Throwable innerThrowable) {
                LOG.error("A thread crashed: ", innerThrowable);
                try {
                    PerformanceAnalyzerApp.exceptionQueue.put(new PAThreadException(paThread, innerThrowable));
                }
                catch (InterruptedException e) {
                    LOG.error("Thread was interrupted while waiting to put an exception into the queue. Message: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            StatsCollector.instance().logMetric(PA_THREADS_ENDED_METRIC_NAME);
            LOG.info("Thread: {} completed.", (Object)threadNameStr);
        }, threadNameStr);
        LOG.info("Spun up a thread with name: {}", (Object)threadNameStr);
        StatsCollector.instance().logMetric(PA_THREADS_STARTED_METRIC_NAME);
        return t;
    }

    public Thread createThreadForRunnable(Runnable innerRunnable, PerformanceAnalyzerThreads paThread) {
        return this.createThreadForRunnable(innerRunnable, paThread, "");
    }
}

