/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rest;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.config.PluginSettings;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.MetricsRestUtil;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metricsdb.MetricsDB;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.model.MetricsModel;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.net.NetClient;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.ReaderMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.ReaderMetricsProcessor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rest.MetricsHandler;
import com.google.common.annotations.VisibleForTesting;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.exception.DataAccessException;

public class QueryBatchRequestHandler
extends MetricsHandler
implements HttpHandler {
    private static final Logger LOG = LogManager.getLogger(QueryBatchRequestHandler.class);
    private static final int TIME_OUT_VALUE = 2;
    private static final TimeUnit TIME_OUT_UNIT = TimeUnit.SECONDS;
    private NetClient netClient;
    MetricsRestUtil metricsRestUtil;
    public static final int DEFAULT_MAX_DATAPOINTS = 100800;
    public static final long DEFAULT_SAMPLING_PERIOD_MILLIS = 5000L;

    public QueryBatchRequestHandler(NetClient netClient, MetricsRestUtil metricsRestUtil) {
        this.netClient = netClient;
        this.metricsRestUtil = metricsRestUtil;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String requestMethod = exchange.getRequestMethod();
        if (!requestMethod.equalsIgnoreCase("GET")) {
            exchange.sendResponseHeaders(404, -1L);
            exchange.close();
            return;
        }
        ReaderMetricsProcessor mp = ReaderMetricsProcessor.getInstance();
        if (mp == null) {
            this.sendResponse(exchange, "{\"error\":\"Metrics Processor is not initialized. The reader has run into an issue or has just started.\"}", 503);
            LOG.warn("Metrics Processor is not initialized. The reader has run into an issue or has just started.");
            return;
        }
        NavigableSet<Long> batchMetrics = mp.getBatchMetrics();
        long currentTime = System.currentTimeMillis();
        if (batchMetrics == null) {
            this.sendResponse(exchange, "{\"error\":\"The batch metrics api has not been enabled for this node.\"}", 503);
            LOG.warn("The batch metrics api has not been enabled for this node.");
            return;
        }
        if (batchMetrics.isEmpty()) {
            this.sendResponse(exchange, "{\"error\":\"There are no metrics databases. The reader has run into an issue or has just started.\"}", 503);
            LOG.warn("There are no metrics databases. The reader has run into an issue or has just started.");
            return;
        }
        exchange.getResponseHeaders().set("Content-Type", "application/json");
        Map<String, String> params = this.getParamsMap(exchange.getRequestURI().getQuery());
        try {
            long endTime;
            long startTime;
            String[] validParamsTmp = new String[]{"", "metrics", "starttime", "endtime", "samplingperiod"};
            HashSet<String> validParams = new HashSet<String>(Arrays.asList(validParamsTmp));
            for (String param : params.keySet()) {
                if (validParams.contains(param)) continue;
                throw new InvalidParameterException(String.format("%s is an invalid parameter", param));
            }
            List<String> metrics = this.metricsRestUtil.parseArrayParam(params, "metrics", false);
            String startTimeParam = params.get("starttime");
            String endTimeParam = params.get("endtime");
            String samplingPeriodParam = params.get("samplingperiod");
            for (String metric : metrics) {
                if (MetricsModel.ALL_METRICS.containsKey(metric)) continue;
                throw new InvalidParameterException(String.format("%s is an invalid metric", metric));
            }
            if (startTimeParam == null || startTimeParam.isEmpty()) {
                throw new InvalidParameterException("starttime parameter must be set");
            }
            try {
                startTime = Long.parseUnsignedLong(startTimeParam);
            }
            catch (NumberFormatException e) {
                throw new InvalidParameterException(String.format("%s is an invalid starttime", startTimeParam));
            }
            if (endTimeParam == null || endTimeParam.isEmpty()) {
                throw new InvalidParameterException("endtime parameter must be set");
            }
            try {
                endTime = Long.parseUnsignedLong(endTimeParam);
            }
            catch (NumberFormatException e) {
                throw new InvalidParameterException(String.format("%s is an invalid endtime", endTimeParam));
            }
            long samplingPeriod = 5000L;
            if (samplingPeriodParam != null && !samplingPeriodParam.isEmpty()) {
                samplingPeriod = Long.parseLong(samplingPeriodParam);
                if (samplingPeriod < 5L || samplingPeriod % 5L != 0L) {
                    throw new InvalidParameterException(String.format("%s is an invalid sampling period", samplingPeriodParam));
                }
                if (samplingPeriod >= PluginSettings.instance().getBatchMetricsRetentionPeriodMinutes() * 60L) {
                    throw new InvalidParameterException("sampling period must be less than the retention period");
                }
                samplingPeriod *= 1000L;
            }
            if (startTime >= endTime) {
                throw new InvalidParameterException("starttime must be less than the endtime");
            }
            if ((startTime -= startTime % samplingPeriod) == (endTime -= endTime % samplingPeriod)) {
                throw new InvalidParameterException("starttime and endtime must be at least one sampling period apart");
            }
            if (endTime > currentTime) {
                throw new InvalidParameterException("endtime can be no greater than the system time at the node");
            }
            if (startTime < currentTime - PluginSettings.instance().getBatchMetricsRetentionPeriodMinutes() * 60L * 1000L) {
                throw new InvalidParameterException("starttime must be within the retention period");
            }
            long processingStartTime = System.currentTimeMillis();
            String queryResponse = this.queryFromBatchMetrics(batchMetrics, metrics, startTime, endTime, samplingPeriod, 100800);
            PerformanceAnalyzerApp.READER_METRICS_AGGREGATOR.updateStat(ReaderMetrics.BATCH_METRICS_QUERY_PROCESSING_TIME, "", System.currentTimeMillis() - processingStartTime);
            PerformanceAnalyzerApp.READER_METRICS_AGGREGATOR.updateStat(ReaderMetrics.BATCH_METRICS_HTTP_SUCCESS, "", 1);
            this.sendResponse(exchange, queryResponse, 200);
        }
        catch (DataAccessException e) {
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat(ExceptionsAndErrors.READER_METRICSDB_ACCESS_ERRORS, "", 1);
            LOG.error("QueryException {} ExceptionCode: {}.", (Object)e, (Object)ReaderMetrics.BATCH_METRICS_HTTP_HOST_ERROR, (Object)e);
            PerformanceAnalyzerApp.READER_METRICS_AGGREGATOR.updateStat(ReaderMetrics.BATCH_METRICS_HTTP_HOST_ERROR, "", 1);
            String response = "{\"error\":\"" + e.toString() + "\"}";
            this.sendResponse(exchange, response, 500);
        }
        catch (InvalidParameterException e) {
            LOG.error("QueryException {} ExceptionCode: {}.", (Object)e, (Object)ReaderMetrics.BATCH_METRICS_HTTP_CLIENT_ERROR, (Object)e);
            PerformanceAnalyzerApp.READER_METRICS_AGGREGATOR.updateStat(ReaderMetrics.BATCH_METRICS_HTTP_CLIENT_ERROR, "", 1);
            String response = "{\"error\":\"" + e.getMessage() + ".\"}";
            this.sendResponse(exchange, response, 400);
        }
        catch (Exception e) {
            LOG.error("QueryException {} ExceptionCode: {}.", (Object)e, (Object)ReaderMetrics.BATCH_METRICS_HTTP_HOST_ERROR, (Object)e);
            PerformanceAnalyzerApp.READER_METRICS_AGGREGATOR.updateStat(ReaderMetrics.BATCH_METRICS_HTTP_HOST_ERROR, "", 1);
            String response = "{\"error\":\"" + e.toString() + "\"}";
            this.sendResponse(exchange, response, 500);
        }
    }

    private int appendMetrics(Long timestamp, List<String> metrics, StringBuilder builder, int maxDatapoints) throws Exception {
        ++maxDatapoints;
        builder.append("\"");
        builder.append(timestamp);
        builder.append("\":{");
        MetricsDB db = MetricsDB.fetchExisting(timestamp);
        int numMetrics = metrics.size();
        for (int metricIndex = 0; metricIndex < numMetrics; ++metricIndex) {
            String metric = metrics.get(metricIndex);
            Result<Record> results = db.queryMetric(metric, MetricsModel.ALL_METRICS.get((Object)metric).dimensionNames, maxDatapoints);
            if (results == null) continue;
            if ((maxDatapoints -= results.size()) <= 0) {
                PerformanceAnalyzerApp.READER_METRICS_AGGREGATOR.updateStat(ReaderMetrics.BATCH_METRICS_EXCEEDED_MAX_DATAPOINTS, "", 1);
                throw new InvalidParameterException(String.format("requested data exceeds the %d datapoints limit", 100800));
            }
            builder.append("\"");
            builder.append(metric);
            builder.append("\":");
            builder.append(results.formatJSON());
            ++metricIndex;
            while (metricIndex < numMetrics) {
                metric = metrics.get(metricIndex);
                results = db.queryMetric(metric, MetricsModel.ALL_METRICS.get((Object)metric).dimensionNames, maxDatapoints);
                if (results != null) {
                    if ((maxDatapoints -= results.size()) <= 0) {
                        PerformanceAnalyzerApp.READER_METRICS_AGGREGATOR.updateStat(ReaderMetrics.BATCH_METRICS_EXCEEDED_MAX_DATAPOINTS, "", 1);
                        throw new InvalidParameterException(String.format("requested data exceeds the %d datapoints limit", 100800));
                    }
                    builder.append(",\"");
                    builder.append(metric);
                    builder.append("\":");
                    builder.append(results.formatJSON());
                }
                ++metricIndex;
            }
        }
        builder.append("}");
        db.remove();
        return maxDatapoints - 1;
    }

    private String queryFromBatchMetrics(NavigableSet<Long> batchMetrics, List<String> metrics, long startTime, long endTime, long samplingPeriod, int maxDatapoints) throws Exception {
        StringBuilder responseJson = new StringBuilder();
        responseJson.append("{");
        Long metricsTimestamp = batchMetrics.ceiling(startTime);
        if (metricsTimestamp != null && metricsTimestamp < endTime) {
            maxDatapoints = this.appendMetrics(metricsTimestamp, metrics, responseJson, maxDatapoints);
            metricsTimestamp = metricsTimestamp - metricsTimestamp % samplingPeriod + samplingPeriod;
            metricsTimestamp = batchMetrics.ceiling(metricsTimestamp);
            while (metricsTimestamp != null && metricsTimestamp < endTime) {
                responseJson.append(",");
                maxDatapoints = this.appendMetrics(metricsTimestamp, metrics, responseJson, maxDatapoints);
                metricsTimestamp = metricsTimestamp - metricsTimestamp % samplingPeriod + samplingPeriod;
                metricsTimestamp = batchMetrics.ceiling(metricsTimestamp);
            }
        }
        responseJson.append("}");
        return responseJson.toString();
    }

    private void sendResponse(HttpExchange exchange, String response, int status) throws IOException {
        try (OutputStream os = exchange.getResponseBody();){
            exchange.sendResponseHeaders(status, response.length());
            os.write(response.getBytes());
        }
        catch (Exception e) {
            response = e.toString();
            exchange.sendResponseHeaders(500, response.length());
        }
    }

    @VisibleForTesting
    public String queryFromBatchMetricsShim(NavigableSet<Long> batchMetrics, List<String> metrics, long startTime, long endTime, long samplingPeriod, int maxDatapoints) throws Exception {
        return this.queryFromBatchMetrics(batchMetrics, metrics, startTime, endTime, samplingPeriod, maxDatapoints);
    }

    @VisibleForTesting
    public int appendMetricsShim(Long timestamp, List<String> metrics, StringBuilder builder, int maxDatapoints) throws Exception {
        return this.appendMetrics(timestamp, metrics, builder, maxDatapoints);
    }
}

