/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.reader_writer_shared;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.core.Util;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.EventDispatcher;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader_writer_shared.Event;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader_writer_shared.EventLog;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventLogFileHandler {
    private static final Logger LOG = LogManager.getLogger(EventLogFileHandler.class);
    private final EventLog eventLog;
    private final String metricsLocation;
    private static final int BUFFER_SIZE = 8192;
    private static final String TMP_FILE_EXT = ".tmp";
    private long lastProcessed;

    public EventLogFileHandler(EventLog eventLog, String metricsLocation) {
        this.eventLog = eventLog;
        this.metricsLocation = metricsLocation;
    }

    public void writeTmpFile(List<Event> dataEntries, long epoch) {
        Util.invokePrivileged(() -> this.writeTmpFileWithPrivilege(dataEntries, epoch));
    }

    public void writeTmpFileWithPrivilege(List<Event> dataEntries, long epoch) {
        Path path = Paths.get(this.metricsLocation, String.valueOf(epoch));
        Path tmpPath = Paths.get(path.toString() + TMP_FILE_EXT, new String[0]);
        Event currEntry = null;
        try (OutputStream out = Files.newOutputStream(tmpPath, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            Iterator<Event> iterator = dataEntries.iterator();
            while (iterator.hasNext()) {
                Event event;
                currEntry = event = iterator.next();
                byte[] data = this.eventLog.write(event);
                this.writeInternal(out, data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error("Error writing entry '{}'. Cause: {}", (Object)(currEntry == null ? "NOT_INITIALIZED" : currEntry.key), (Object)e.getMessage());
        }
    }

    public void renameFromTmp(long epoch) {
        Util.invokePrivileged(() -> this.renameFromTmpWithPrivilege(epoch));
    }

    public void renameFromTmpWithPrivilege(long epoch) {
        Path path = Paths.get(this.metricsLocation, String.valueOf(epoch));
        Path tmpPath = Paths.get(path.toString() + TMP_FILE_EXT, new String[0]);
        try {
            Files.move(tmpPath, path, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error("Error moving file {} to {}.", (Object)tmpPath.toString(), (Object)path.toString());
        }
    }

    public void read(long timestamp, EventDispatcher processor) {
        if (timestamp <= this.lastProcessed) {
            return;
        }
        String filename = String.valueOf(timestamp);
        Path pathToFile = Paths.get(this.metricsLocation, filename);
        File tempFile = new File(pathToFile.toString());
        if (!tempFile.exists()) {
            long mCurrT = System.currentTimeMillis();
            LOG.info("Didnt find {} at {}", (Object)filename, (Object)mCurrT);
            return;
        }
        this.readInternal(pathToFile, 8192, processor);
        this.lastProcessed = timestamp;
        this.eventLog.clear();
    }

    private void writeInternal(OutputStream stream, byte[] data) throws IOException {
        int len;
        int n;
        for (int rem = len = data.length; rem > 0; rem -= n) {
            n = Math.min(rem, 8192);
            stream.write(data, len - rem, n);
        }
    }

    private void readInternal(Path pathToFile, int bufferSize, EventDispatcher processor) {
        try (SeekableByteChannel channel = Files.newByteChannel(pathToFile, StandardOpenOption.READ);){
            ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize);
            while (channel.read(byteBuffer) > 0) {
                ((Buffer)byteBuffer).flip();
                this.eventLog.read(byteBuffer, processor);
                ((Buffer)byteBuffer).clear();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

