/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.reader;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.AllMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.EventProcessor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.ReaderMetricsProcessor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.ShardRequestMetricsSnapshot;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader_writer_shared.Event;
import java.io.File;
import java.sql.Connection;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;

public class RequestEventProcessor
implements EventProcessor {
    private static final Logger LOG = LogManager.getLogger(RequestEventProcessor.class);
    private ShardRequestMetricsSnapshot rqSnap;
    private BatchBindStep handle;
    private long startTime;
    private long endTime;

    private RequestEventProcessor(ShardRequestMetricsSnapshot rqSnap) {
        this.rqSnap = rqSnap;
    }

    static RequestEventProcessor buildRequestMetricEventsProcessor(long currWindowStartTime, long currWindowEndTime, Connection conn, NavigableMap<Long, ShardRequestMetricsSnapshot> shardRqMetricsMap) throws Exception {
        if (shardRqMetricsMap.get(currWindowStartTime) == null) {
            ShardRequestMetricsSnapshot rqSnap = new ShardRequestMetricsSnapshot(conn, currWindowStartTime);
            Map.Entry<Long, ShardRequestMetricsSnapshot> entry = shardRqMetricsMap.lastEntry();
            if (entry != null) {
                rqSnap.rolloverInflightRequests(entry.getValue());
            }
            shardRqMetricsMap.put(currWindowStartTime, rqSnap);
            return new RequestEventProcessor(rqSnap);
        }
        return new RequestEventProcessor((ShardRequestMetricsSnapshot)shardRqMetricsMap.get(currWindowStartTime));
    }

    @Override
    public boolean shouldProcessEvent(Event event) {
        return event.key.contains("shardbulk") || event.key.contains("shardfetch") || event.key.contains("shardquery");
    }

    @Override
    public void initializeProcessing(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.handle = this.rqSnap.startBatchPut();
    }

    @Override
    public void finalizeProcessing() {
        if (this.handle.size() > 0) {
            this.handle.execute();
        }
    }

    @Override
    public void processEvent(Event event) {
        this.handleESMetrics(event);
        if (this.handle.size() == 500) {
            this.handle.execute();
            this.handle = this.rqSnap.startBatchPut();
        }
    }

    @Override
    public void commitBatchIfRequired() {
        if (this.handle.size() > 500) {
            this.handle.execute();
            this.handle = this.rqSnap.startBatchPut();
        }
    }

    private void handleESMetrics(Event entry) {
        String[] items = entry.key.split(File.separatorChar == '\\' ? "\\\\" : File.separator);
        String startOrEnd = items[4];
        Map<String, String> keyValueMap = ReaderMetricsProcessor.extractEntryData(entry.value);
        if (startOrEnd.equals("start")) {
            this.emitStartMetric(items, keyValueMap);
        } else if (startOrEnd.equals("finish")) {
            this.emitFinishMetric(items, keyValueMap);
        }
    }

    private void emitStartMetric(String[] metricKeyPathElements, Map<String, String> keyValueMap) {
        long startTime = Long.parseLong(keyValueMap.get(AllMetrics.ShardBulkMetric.START_TIME.toString()));
        long docCount = Long.parseLong(keyValueMap.computeIfAbsent(AllMetrics.ShardBulkMetric.ITEM_COUNT.toString(), k -> "0"));
        String indexName = keyValueMap.get(AllMetrics.ShardBulkDimension.INDEX_NAME.toString());
        String shardId = keyValueMap.get(AllMetrics.ShardBulkDimension.SHARD_ID.toString());
        String primary = this.getPrimary(keyValueMap.get(AllMetrics.ShardBulkDimension.PRIMARY.toString()));
        String threadId = metricKeyPathElements[1];
        String operation = metricKeyPathElements[2];
        String rid = metricKeyPathElements[3];
        this.handle.bind(new Object[]{shardId, indexName, rid, threadId, operation, primary, startTime, null, docCount});
    }

    private String getPrimary(String primary) {
        return primary == null ? "NA" : (primary.equals("true") ? "primary" : "replica");
    }

    private void emitFinishMetric(String[] metricKeyPathElements, Map<String, String> keyValueMap) {
        long finishTime = Long.parseLong(keyValueMap.get(AllMetrics.ShardBulkMetric.FINISH_TIME.toString()));
        String indexName = keyValueMap.get(AllMetrics.ShardBulkDimension.INDEX_NAME.toString());
        String shardId = keyValueMap.get(AllMetrics.ShardBulkDimension.SHARD_ID.toString());
        String primary = this.getPrimary(keyValueMap.get(AllMetrics.ShardBulkDimension.PRIMARY.toString()));
        String threadId = metricKeyPathElements[1];
        String operation = metricKeyPathElements[2];
        String rid = metricKeyPathElements[3];
        this.handle.bind(new Object[]{shardId, indexName, rid, threadId, operation, primary, null, finishTime, null});
    }
}

