/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.reader;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.OSMetricsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.AllMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.EventProcessor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.OSMetricsSnapshot;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader_writer_shared.Event;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;

public class OSEventProcessor
implements EventProcessor {
    private static final Logger LOG = LogManager.getLogger(OSEventProcessor.class);
    private List<String> tidToDelete;
    private OSMetricsSnapshot osSnap;
    private BatchBindStep handle;
    private long startTime;
    private long endTime;
    private Map<String, Long> lastUpdateTimePerTid;

    private OSEventProcessor(OSMetricsSnapshot osSnap) {
        this.osSnap = osSnap;
        this.tidToDelete = new ArrayList<String>();
    }

    static EventProcessor buildOSMetricEventsProcessor(long startTime, long endTime, Connection conn, NavigableMap<Long, OSMetricsSnapshot> osMetricsMap) throws Exception {
        OSMetricsSnapshot osSnap;
        if (osMetricsMap.get(endTime) == null) {
            osSnap = new OSMetricsSnapshot(conn, "os_", endTime);
            osMetricsMap.put(endTime, osSnap);
        }
        osSnap = (OSMetricsSnapshot)osMetricsMap.get(endTime);
        return new OSEventProcessor(osSnap);
    }

    @Override
    public void initializeProcessing(long startTime, long endTime) {
        this.handle = this.osSnap.startBatchPut();
        this.startTime = startTime;
        this.endTime = endTime;
        this.lastUpdateTimePerTid = this.osSnap.getLastUpdateTimePerTid();
    }

    @Override
    public void finalizeProcessing() {
        this.osSnap.deleteByTid(this.tidToDelete);
        if (this.handle.size() > 0) {
            this.handle.execute();
        }
    }

    @Override
    public void processEvent(Event event) {
        String key = event.key;
        String threadID = key.split(File.separatorChar == '\\' ? "\\\\" : File.separator)[1];
        this.processOSEvent(event.value, threadID);
        if (this.handle.size() == 500) {
            this.handle.execute();
            this.handle = this.osSnap.startBatchPut();
        }
    }

    @Override
    public boolean shouldProcessEvent(Event event) {
        return event.key.contains("os_metrics");
    }

    @Override
    public void commitBatchIfRequired() {
        if (this.handle.size() > 500) {
            this.handle.execute();
            this.handle = this.osSnap.startBatchPut();
        }
    }

    private Map<String, String> extrackKeyValFromData(String osMetricsData) {
        String[] lines = osMetricsData.split(System.lineSeparator());
        HashMap<String, String> osMetricsKeyValPairs = new HashMap<String, String>();
        for (String line : lines) {
            String[] pair = line.split(":");
            osMetricsKeyValPairs.put(pair[0], String.join((CharSequence)":", Arrays.copyOfRange(pair, 1, pair.length)));
        }
        return osMetricsKeyValPairs;
    }

    private boolean processOSEvent(String data, String threadID) {
        AllMetrics.OSMetrics[] metrics;
        HashMap<String, Double> osMetrics = new HashMap<String, Double>();
        Map<String, String> processedData = this.extrackKeyValFromData(data);
        long opFileLastModified = Long.parseLong(processedData.computeIfAbsent("current_time", k -> String.valueOf(0)));
        if (opFileLastModified > this.endTime) {
            LOG.info("File last modified {} time is greater than endTime - {}", (Object)opFileLastModified, (Object)this.endTime);
            opFileLastModified = this.endTime;
        }
        if (opFileLastModified < this.startTime) {
            return false;
        }
        if (this.lastUpdateTimePerTid.containsKey(threadID)) {
            if (this.lastUpdateTimePerTid.get(threadID) == opFileLastModified) {
                return false;
            }
            this.tidToDelete.add(threadID);
        }
        for (AllMetrics.OSMetrics metric : metrics = AllMetrics.OSMetrics.values()) {
            String metricVal = processedData.get(metric.toString());
            if (metricVal == null) continue;
            Double val = Double.parseDouble(metricVal);
            osMetrics.put(metric.toString(), val);
        }
        String threadName = processedData.get(OSMetricsCollector.MetaDataFields.threadName.toString());
        int numMetrics = metrics.length + 3;
        Object[] metricVals = new Object[numMetrics];
        metricVals[0] = threadID;
        metricVals[1] = threadName;
        for (int i = 2; i < numMetrics - 1; ++i) {
            metricVals[i] = osMetrics.get(metrics[i - 2].toString());
        }
        metricVals[numMetrics - 1] = opFileLastModified;
        this.handle.bind(metricVals);
        return true;
    }
}

