/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.reader;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.AllMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.FileHandler;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.MetricProperties;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader_writer_shared.Event;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class MetricPropertiesConfig {
    private final Map<AllMetrics.MetricName, MetricProperties> metricName2Property;
    private static final MetricPropertiesConfig INSTANCE = new MetricPropertiesConfig();
    private Map<AllMetrics.MetricName, String> metricPathMap = new HashMap<AllMetrics.MetricName, String>();
    private Map<String, AllMetrics.MetricName> eventKeyToMetricNameMap;

    static FileHandler createFileHandler(final String ... metricPathElements) {
        return new FileHandler(){

            @Override
            public List<File> findFiles4Metric(long startTimeThirtySecondBucket) {
                ArrayList<File> ret = new ArrayList<File>(1);
                StringBuilder sb = new StringBuilder();
                sb.append(this.getRootLocation());
                sb.append(startTimeThirtySecondBucket);
                for (String element : metricPathElements) {
                    sb.append(File.separator);
                    sb.append(element);
                }
                File metricFile = new File(sb.toString());
                if (metricFile.exists()) {
                    ret.add(metricFile);
                }
                return ret;
            }

            @Override
            public List<Event> getMetricData(Map<String, List<Event>> metricDataMap) {
                Objects.requireNonNull(metricDataMap);
                List<Event> entries = metricDataMap.get(metricPathElements[0]);
                return entries == null ? Collections.emptyList() : entries;
            }
        };
    }

    private MetricPropertiesConfig() {
        this.metricPathMap.put(AllMetrics.MetricName.CACHE_CONFIG, "cache_config");
        this.metricPathMap.put(AllMetrics.MetricName.CIRCUIT_BREAKER, "circuit_breaker");
        this.metricPathMap.put(AllMetrics.MetricName.HEAP_METRICS, "heap_metrics");
        this.metricPathMap.put(AllMetrics.MetricName.DISK_METRICS, "disk_metrics");
        this.metricPathMap.put(AllMetrics.MetricName.TCP_METRICS, "tcp_metrics");
        this.metricPathMap.put(AllMetrics.MetricName.IP_METRICS, "ip_metrics");
        this.metricPathMap.put(AllMetrics.MetricName.THREAD_POOL, "thread_pool");
        this.metricPathMap.put(AllMetrics.MetricName.SHARD_STATS, "indices");
        this.metricPathMap.put(AllMetrics.MetricName.MASTER_PENDING, "pending_tasks");
        this.metricPathMap.put(AllMetrics.MetricName.MOUNTED_PARTITION_METRICS, "mounted_part_space");
        this.eventKeyToMetricNameMap = new HashMap<String, AllMetrics.MetricName>();
        this.eventKeyToMetricNameMap.put("cache_config", AllMetrics.MetricName.CACHE_CONFIG);
        this.eventKeyToMetricNameMap.put("circuit_breaker", AllMetrics.MetricName.CIRCUIT_BREAKER);
        this.eventKeyToMetricNameMap.put("heap_metrics", AllMetrics.MetricName.HEAP_METRICS);
        this.eventKeyToMetricNameMap.put("disk_metrics", AllMetrics.MetricName.DISK_METRICS);
        this.eventKeyToMetricNameMap.put("tcp_metrics", AllMetrics.MetricName.TCP_METRICS);
        this.eventKeyToMetricNameMap.put("ip_metrics", AllMetrics.MetricName.IP_METRICS);
        this.eventKeyToMetricNameMap.put("thread_pool", AllMetrics.MetricName.THREAD_POOL);
        this.eventKeyToMetricNameMap.put("indices", AllMetrics.MetricName.SHARD_STATS);
        this.eventKeyToMetricNameMap.put("pending_tasks", AllMetrics.MetricName.MASTER_PENDING);
        this.eventKeyToMetricNameMap.put("mounted_part_space", AllMetrics.MetricName.MOUNTED_PARTITION_METRICS);
        this.metricName2Property = new HashMap<AllMetrics.MetricName, MetricProperties>();
        this.metricName2Property.put(AllMetrics.MetricName.CACHE_CONFIG, new MetricProperties(AllMetrics.CacheConfigDimension.values(), AllMetrics.CacheConfigValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get((Object)AllMetrics.MetricName.CACHE_CONFIG))));
        this.metricName2Property.put(AllMetrics.MetricName.CIRCUIT_BREAKER, new MetricProperties(AllMetrics.CircuitBreakerDimension.values(), AllMetrics.CircuitBreakerValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get((Object)AllMetrics.MetricName.CIRCUIT_BREAKER))));
        this.metricName2Property.put(AllMetrics.MetricName.HEAP_METRICS, new MetricProperties(AllMetrics.HeapDimension.values(), AllMetrics.HeapValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get((Object)AllMetrics.MetricName.HEAP_METRICS))));
        this.metricName2Property.put(AllMetrics.MetricName.DISK_METRICS, new MetricProperties(AllMetrics.DiskDimension.values(), AllMetrics.DiskValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get((Object)AllMetrics.MetricName.DISK_METRICS))));
        this.metricName2Property.put(AllMetrics.MetricName.TCP_METRICS, new MetricProperties(AllMetrics.TCPDimension.values(), AllMetrics.TCPValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get((Object)AllMetrics.MetricName.TCP_METRICS))));
        this.metricName2Property.put(AllMetrics.MetricName.IP_METRICS, new MetricProperties(AllMetrics.IPDimension.values(), AllMetrics.IPValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get((Object)AllMetrics.MetricName.IP_METRICS))));
        this.metricName2Property.put(AllMetrics.MetricName.THREAD_POOL, new MetricProperties(AllMetrics.ThreadPoolDimension.values(), AllMetrics.ThreadPoolValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get((Object)AllMetrics.MetricName.THREAD_POOL))));
        this.metricName2Property.put(AllMetrics.MetricName.SHARD_STATS, new MetricProperties(AllMetrics.ShardStatsDerivedDimension.values(), MetricProperties.EMPTY_DIMENSION, AllMetrics.ShardStatsValue.values(), new ShardStatFileHandler()));
        this.metricName2Property.put(AllMetrics.MetricName.MASTER_PENDING, new MetricProperties(MetricProperties.EMPTY_DIMENSION, AllMetrics.MasterPendingValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get((Object)AllMetrics.MetricName.MASTER_PENDING), "current", "metadata")));
        this.metricName2Property.put(AllMetrics.MetricName.MOUNTED_PARTITION_METRICS, new MetricProperties(AllMetrics.DevicePartitionDimension.values(), AllMetrics.DevicePartitionValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get((Object)AllMetrics.MetricName.MOUNTED_PARTITION_METRICS))));
    }

    public static MetricPropertiesConfig getInstance() {
        return INSTANCE;
    }

    public MetricProperties getProperty(AllMetrics.MetricName name) {
        return this.metricName2Property.get((Object)name);
    }

    public Map<AllMetrics.MetricName, String> getMetricPathMap() {
        return this.metricPathMap;
    }

    Map<String, AllMetrics.MetricName> getEventKeyToMetricNameMap() {
        return this.eventKeyToMetricNameMap;
    }

    @VisibleForTesting
    Map<AllMetrics.MetricName, MetricProperties> getMetricName2Property() {
        return this.metricName2Property;
    }

    public static class ShardStatFileHandler
    extends FileHandler {
        @Override
        public List<File> findFiles4Metric(long timeBucket) {
            File indicesFolder = new File(this.getRootLocation() + File.separator + timeBucket + File.separator + "indices");
            if (!indicesFolder.exists()) {
                return Collections.emptyList();
            }
            ArrayList<File> metricFiles = new ArrayList<File>();
            File[] files = indicesFolder.listFiles();
            if (files != null) {
                for (File indexFolder : files) {
                    File[] shardIdFiles;
                    if (indexFolder == null || (shardIdFiles = indexFolder.listFiles()) == null) continue;
                    for (File shardIdFile : shardIdFiles) {
                        metricFiles.add(shardIdFile);
                    }
                }
            }
            return metricFiles;
        }

        @Override
        public List<Event> getMetricData(Map<String, List<Event>> metricDataMap) {
            Objects.requireNonNull(metricDataMap);
            return metricDataMap.computeIfAbsent("indices", k -> Collections.emptyList());
        }

        @Override
        public String filePathRegex() {
            return this.getRootLocation() + File.separator + "?\\d+" + File.separator + "indices" + File.separator + "(.*)" + File.separator + "(\\d+)";
        }
    }
}

