/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.reader;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.DBUtils;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatExceptionCode;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.MetricDimension;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.MetricValue;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.FileHandler;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.MemoryDBSnapshot;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader_writer_shared.Event;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.util.JsonConverter;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.util.JsonPathNotFoundException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.impl.DSL;

public class MetricProperties {
    private static final Logger LOG = LogManager.getLogger(MetricProperties.class);
    public static final MetricDimension[] EMPTY_DIMENSION = new MetricDimension[0];
    private FileHandler handler;
    private MetricDimension[] derivedDimension;
    private MetricDimension[] directDimensions;
    private MetricValue[] metadata;
    private List<String> dimensionNames;
    private List<Field<String>> dimensionFields;
    private List<Field<Double>> metadataFields;
    private List<String> metadataTableNames;
    private Map<String, List<Field<?>>> inMemoryTableSelectFieldsMap = new HashMap();
    private Map<String, List<Field<String>>> inMemoryTableGroupByFieldsMap = new HashMap<String, List<Field<String>>>();
    private Map<String, Condition> inMemoryTableWhereClauseMap = new HashMap<String, Condition>();

    int getDirectDimensionsSize() {
        return this.directDimensions.length;
    }

    public int getMetadataSize() {
        return this.metadata.length;
    }

    public MetricProperties(MetricDimension[] derivedDimension, MetricDimension[] dimensions, MetricValue[] values, FileHandler handler, Map<String, String> customizedTableNames) {
        this(derivedDimension, dimensions, values, handler);
        this.customizeMetricTableName(customizedTableNames);
        this.initializeTableSelectFields();
    }

    public MetricProperties(MetricDimension[] derivedDimension, MetricDimension[] dimensions, MetricValue[] values, FileHandler handler) {
        this.handler = handler;
        this.derivedDimension = (MetricDimension[])derivedDimension.clone();
        this.directDimensions = (MetricDimension[])dimensions.clone();
        this.metadata = (MetricValue[])values.clone();
        this.inMemoryTableSelectFieldsMap = new HashMap();
        this.initializeFields();
        this.initializeTableSelectFields();
    }

    public MetricProperties(MetricDimension[] dimensions, MetricValue[] values, FileHandler handler) {
        this(EMPTY_DIMENSION, dimensions, values, handler);
    }

    public List<Field<Double>> getMetricFields() {
        return this.metadataFields;
    }

    public List<Field<String>> getDimensionFields() {
        return this.dimensionFields;
    }

    @VisibleForTesting
    void setHandler(FileHandler handler) {
        this.handler = handler;
    }

    FileHandler getHandler() {
        return this.handler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean processMetrics(File file, MemoryDBSnapshot snap, long startTime, long lastSnapTimestamp, BatchBindStep batchHandle) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String line = bufferedReader.readLine();
            if (line == null) {
                boolean bl = false;
                return bl;
            }
            long lastModifiedTime = JsonConverter.getLongValue(line, "current_time");
            if (lastModifiedTime > startTime || lastModifiedTime <= lastSnapTimestamp) {
                boolean bl = false;
                return bl;
            }
            if (snap.getLastUpdatedTime() < lastModifiedTime) {
                snap.setLastUpdatedTime(lastModifiedTime);
            }
            String[] derivedDimension = this.handler.processExtraDimensions(file);
            int numMetrics = derivedDimension.length + this.directDimensions.length + this.metadata.length;
            Object[] templateMetricVals = new Object[numMetrics];
            int valIndex = 0;
            for (int i = 0; i < derivedDimension.length; ++i) {
                templateMetricVals[valIndex++] = derivedDimension[i];
            }
            boolean processed = false;
            while ((line = bufferedReader.readLine()) != null) {
                processed = this.processJsonLine(line, batchHandle, templateMetricVals) || processed;
            }
            boolean bl = processed;
            return bl;
        }
        catch (JsonPathNotFoundException | JsonProcessingException e) {
            LOG.warn(String.format("Fail to get last modified time of %s ExceptionCode: %s", file.getAbsolutePath(), StatExceptionCode.JSON_PARSER_ERROR.toString()), e);
            StatsCollector.instance().logException(StatExceptionCode.JSON_PARSER_ERROR);
            return false;
        }
    }

    private boolean processEvent(Event event, MemoryDBSnapshot snap, long startTime, long lastSnapTimestamp, BatchBindStep batchHandle) {
        if (event.value.isEmpty()) {
            return false;
        }
        String[] lines = event.value.split(System.getProperty("line.separator"));
        long lastModifiedTime = 0L;
        try {
            lastModifiedTime = JsonConverter.getLongValue(lines[0], "current_time");
        }
        catch (JsonPathNotFoundException ex) {
            LOG.warn(String.format("Fail to get last modified time of %s ExceptionCode: %s", event.key, StatExceptionCode.JSON_PARSER_ERROR.toString()), (Throwable)ex);
            StatsCollector.instance().logException(StatExceptionCode.JSON_PARSER_ERROR);
            return false;
        }
        catch (JsonProcessingException ex) {
            LOG.warn(String.format("Malformed json (%s) ExceptionCode: %s", lines[0], StatExceptionCode.JSON_PARSER_ERROR.toString()), (Throwable)ex);
            StatsCollector.instance().logException(StatExceptionCode.JSON_PARSER_ERROR);
            return false;
        }
        catch (IOException ex) {
            LOG.warn(String.format("I/O exception processing metric %s with value: %s.%sExceptionCode: %s", event.key, lines[0], File.separator, StatExceptionCode.JSON_PARSER_ERROR.toString()), (Throwable)ex);
            StatsCollector.instance().logException(StatExceptionCode.JSON_PARSER_ERROR);
            return false;
        }
        if (lastModifiedTime > startTime || lastModifiedTime <= lastSnapTimestamp) {
            return false;
        }
        if (snap.getLastUpdatedTime() < lastModifiedTime) {
            snap.setLastUpdatedTime(lastModifiedTime);
        }
        String[] derivedDimension = this.handler.processExtraDimensions(event.key);
        int numMetrics = derivedDimension.length + this.directDimensions.length + this.metadata.length;
        Object[] templateMetricVals = new Object[numMetrics];
        int valIndex = 0;
        for (String s : derivedDimension) {
            templateMetricVals[valIndex] = s;
            ++valIndex;
        }
        boolean processed = false;
        for (int lineNum = 1; lineNum < lines.length; ++lineNum) {
            processed = this.processJsonLine(lines[lineNum], batchHandle, templateMetricVals) || processed;
        }
        return processed;
    }

    boolean processJsonLine(String line, BatchBindStep batchHandle, Object[] templateMetricVals) {
        int i;
        Map<String, Object> map = JsonConverter.createMapFrom(line);
        if (map.isEmpty()) {
            return false;
        }
        Object[] metricVals = (Object[])templateMetricVals.clone();
        int startIndex = this.derivedDimension.length;
        for (i = 0; i < this.directDimensions.length; ++i) {
            metricVals[startIndex + i] = map.get(this.directDimensions[i].toString());
        }
        startIndex += this.directDimensions.length;
        for (i = 0; i < this.metadata.length; ++i) {
            String key = this.metadata[i].toString();
            if (!map.containsKey(key)) continue;
            metricVals[startIndex + i] = map.get(key);
        }
        batchHandle.bind(metricVals);
        return true;
    }

    public boolean dispatch(MemoryDBSnapshot snap, long startTime, long lastSnapTimestamp) throws Exception {
        long startTimeThirtySecondBucket = PerformanceAnalyzerMetrics.getTimeInterval(startTime);
        long prevThirtySecondBucket = startTimeThirtySecondBucket - 30000L;
        BatchBindStep handle = snap.startBatchPut();
        boolean metricProcessed = false;
        List<File> metricFiles = this.handler.findFiles4Metric(startTimeThirtySecondBucket);
        for (File f : metricFiles) {
            metricProcessed = this.processMetrics(f, snap, startTime, lastSnapTimestamp, handle) || metricProcessed;
        }
        metricFiles = this.handler.findFiles4Metric(prevThirtySecondBucket);
        for (File f : metricFiles) {
            metricProcessed = this.processMetrics(f, snap, startTime, lastSnapTimestamp, handle) || metricProcessed;
        }
        if (handle.size() > 0) {
            handle.execute();
        }
        return metricProcessed;
    }

    private List<String> createEnumNameList(Object[] enumValues) {
        if (enumValues != null && enumValues.length > 0) {
            return Arrays.stream(enumValues).map(d -> d.toString()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void initializeFields() {
        this.dimensionNames = new ArrayList<String>();
        this.dimensionNames.addAll(this.createEnumNameList(this.derivedDimension));
        this.dimensionNames.addAll(this.createEnumNameList(this.directDimensions));
        this.dimensionFields = DBUtils.getStringFieldsFromList(this.dimensionNames);
        this.metadataTableNames = this.createEnumNameList(this.metadata);
        this.metadataFields = DBUtils.getDoubleFieldsFromList(this.metadataTableNames);
    }

    private void customizeMetricTableName(Map<String, String> tableName) {
        for (int i = 0; i < this.metadataTableNames.size(); ++i) {
            String metricName = this.metadataTableNames.get(i).toString();
            if (!tableName.containsKey(metricName)) continue;
            this.metadataTableNames.set(i, tableName.get(metricName));
        }
    }

    public List<String> getMetadataTableNames() {
        return this.metadataTableNames;
    }

    private void initializeTableSelectFields() {
        for (int i = 0; i < this.metadataFields.size(); ++i) {
            Field<Double> metadataField = this.metadataFields.get(i);
            String metadataName = metadataField.getName();
            String tableName = this.metadataTableNames.get(i);
            ArrayList<Field<String>> groupByFields = new ArrayList<Field<String>>();
            groupByFields.addAll(this.getDimensionFields());
            ArrayList<Object> selectFields = new ArrayList<Object>();
            selectFields.addAll(this.getDimensionFields());
            selectFields.add(DSL.sum(metadataField).as("sum_" + metadataName));
            selectFields.add(DSL.avg(metadataField).as("avg_" + metadataName));
            selectFields.add(DSL.min(metadataField).as("min_" + metadataName));
            selectFields.add(DSL.max(metadataField).as("max_" + metadataName));
            this.inMemoryTableSelectFieldsMap.put(tableName, selectFields);
            this.inMemoryTableGroupByFieldsMap.put(tableName, groupByFields);
            Condition whereClause = metadataField.isNotNull();
            this.inMemoryTableWhereClauseMap.put(tableName, whereClause);
        }
    }

    public Map<String, List<Field<?>>> getTableSelectMap() {
        return this.inMemoryTableSelectFieldsMap;
    }

    public Map<String, List<Field<String>>> getTableGroupByFieldsMap() {
        return this.inMemoryTableGroupByFieldsMap;
    }

    public Map<String, Condition> getTableWhereClauseMap() {
        return this.inMemoryTableWhereClauseMap;
    }

    public List<String> getDimensionNames() {
        return this.dimensionNames;
    }
}

