/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.reader;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.AllMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.EventProcessor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.MasterThrottlingMetricsSnapshot;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader_writer_shared.Event;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;

public class MasterThrottlingMetricsEventProcessor
implements EventProcessor {
    private static final Logger LOG = LogManager.getLogger(MasterThrottlingMetricsEventProcessor.class);
    private final MasterThrottlingMetricsSnapshot masterThrottlingMetricsSnapshot;
    private BatchBindStep handle;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final TypeReference<HashMap<String, String>> TYPE_REF = new TypeReference<HashMap<String, String>>(){};

    private MasterThrottlingMetricsEventProcessor(MasterThrottlingMetricsSnapshot snapshot) {
        this.masterThrottlingMetricsSnapshot = snapshot;
    }

    static MasterThrottlingMetricsEventProcessor buildMasterThrottlingMetricEventsProcessor(long currWindowStartTime, Connection conn, NavigableMap<Long, MasterThrottlingMetricsSnapshot> masterThroEventMetricsMap) {
        MasterThrottlingMetricsSnapshot masterThrottlingSnapshot = (MasterThrottlingMetricsSnapshot)masterThroEventMetricsMap.get(currWindowStartTime);
        if (masterThrottlingSnapshot == null) {
            masterThrottlingSnapshot = new MasterThrottlingMetricsSnapshot(conn, currWindowStartTime);
            masterThroEventMetricsMap.put(currWindowStartTime, masterThrottlingSnapshot);
        }
        return new MasterThrottlingMetricsEventProcessor(masterThrottlingSnapshot);
    }

    @Override
    public void initializeProcessing(long startTime, long endTime) {
        this.handle = this.masterThrottlingMetricsSnapshot.startBatchPut();
    }

    @Override
    public void finalizeProcessing() {
        if (this.handle.size() > 0) {
            this.handle.execute();
        }
        LOG.debug("Final Master Throttling metrics {}", this.masterThrottlingMetricsSnapshot.fetchAll());
    }

    @Override
    public void processEvent(Event event) {
        String[] lines;
        for (String line : lines = event.value.split(System.lineSeparator())) {
            Map<String, String> masterThrottlingMap = MasterThrottlingMetricsEventProcessor.extractEntryData(line);
            if (masterThrottlingMap.containsKey("current_time")) continue;
            try {
                this.handle.bind(new Object[]{Long.parseLong(masterThrottlingMap.get(AllMetrics.MasterThrottlingValue.DATA_RETRYING_TASK_COUNT.toString())), Long.parseLong(masterThrottlingMap.get(AllMetrics.MasterThrottlingValue.MASTER_THROTTLED_PENDING_TASK_COUNT.toString()))});
            }
            catch (Exception ex) {
                LOG.error("Fail to get master throttling metrics ", (Throwable)ex);
            }
        }
    }

    @Override
    public boolean shouldProcessEvent(Event event) {
        return event.key.contains("master_throttling_metrics");
    }

    @Override
    public void commitBatchIfRequired() {
        if (this.handle.size() > 500) {
            this.handle.execute();
            this.handle = this.masterThrottlingMetricsSnapshot.startBatchPut();
        }
    }

    static Map<String, String> extractEntryData(String line) {
        try {
            return (Map)MAPPER.readValue(line, TYPE_REF);
        }
        catch (IOException ioe) {
            LOG.error("Error occurred while parsing tmp file", (Throwable)ioe);
            return new HashMap<String, String>();
        }
    }
}

