/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.reader;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.DBUtils;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.AllMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.Removable;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

public class FaultDetectionMetricsSnapshot
implements Removable {
    private static final Logger LOG = LogManager.getLogger(FaultDetectionMetricsSnapshot.class);
    private final DSLContext create;
    private final Long windowStartTime;
    private final String tableName;
    private ArrayList<Field<?>> columns;
    private static final Long EXPIRE_AFTER = 600000L;

    public FaultDetectionMetricsSnapshot(Connection conn, Long windowStartTime) {
        this.create = DSL.using((Connection)conn, (SQLDialect)SQLDialect.SQLITE);
        this.windowStartTime = windowStartTime;
        this.tableName = "fault_detection_" + windowStartTime;
        this.columns = new ArrayList<Field<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.RID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.FaultDetectionDimension.SOURCE_NODE_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.FaultDetectionDimension.TARGET_NODE_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.FAULT_DETECTION_TYPE.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ST.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.ET.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.FAULT.toString()), Integer.class));
            }
        };
        this.create.createTable(this.tableName).columns(this.columns).execute();
    }

    public BatchBindStep startBatchPut() {
        ArrayList<Object> dummyValues = new ArrayList<Object>();
        for (int i = 0; i < this.columns.size(); ++i) {
            dummyValues.add(null);
        }
        return this.create.batch((Query)this.create.insertInto(DSL.table((String)this.tableName)).values(dummyValues));
    }

    @VisibleForTesting
    public void putStartMetric(Long startTime, Map<String, String> dimensions) {
        HashMap<Field, String> dimensionMap = new HashMap<Field, String>();
        for (Map.Entry<String, String> dimension : dimensions.entrySet()) {
            dimensionMap.put(DSL.field((Name)DSL.name((String)dimension.getKey()), String.class), dimension.getValue());
        }
        this.create.insertInto(DSL.table((String)this.tableName)).set(DSL.field((Name)DSL.name((String)Fields.ST.toString()), Long.class), (Object)startTime).set(dimensionMap).execute();
    }

    @VisibleForTesting
    public void putEndMetric(Long endTime, int error, Map<String, String> dimensions) {
        HashMap<Field, String> dimensionMap = new HashMap<Field, String>();
        for (Map.Entry<String, String> dimension : dimensions.entrySet()) {
            dimensionMap.put(DSL.field((Name)DSL.name((String)dimension.getKey()), String.class), dimension.getValue());
        }
        this.create.insertInto(DSL.table((String)this.tableName)).set(DSL.field((Name)DSL.name((String)Fields.ET.toString()), Long.class), (Object)endTime).set(DSL.field((Name)DSL.name((String)Fields.FAULT.toString()), Integer.class), (Object)error).set(dimensionMap).execute();
    }

    public Result<Record> fetchAll() {
        return this.create.select(new SelectField[0]).from((TableLike)DSL.table((String)this.tableName)).fetch();
    }

    @Override
    public void remove() throws Exception {
        this.create.dropTable(DSL.table((String)this.tableName)).execute();
    }

    public void rolloverInFlightRequests(FaultDetectionMetricsSnapshot prevSnap) {
        this.create.insertInto(DSL.table((String)this.tableName)).select((Select)this.create.select(new SelectField[0]).from(prevSnap.fetchInFlightRequests())).execute();
    }

    public SelectHavingStep<Record> fetchInFlightRequests() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.RID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.FaultDetectionDimension.SOURCE_NODE_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.FaultDetectionDimension.TARGET_NODE_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.FAULT_DETECTION_TYPE.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.FAULT.toString()), String.class));
                this.add(DSL.field((String)Fields.ST.toString(), Long.class));
                this.add(DSL.field((String)Fields.ET.toString(), Long.class));
            }
        };
        return this.create.select((Collection)fields).from(this.groupByRidAndTypeSelect()).where(new Condition[]{DSL.field((String)Fields.ST.toString()).isNotNull().and(DSL.field((String)Fields.ET.toString()).isNull()).and(DSL.field((String)Fields.ST.toString()).gt((Object)(this.windowStartTime - EXPIRE_AFTER)))});
    }

    public SelectHavingStep<Record> groupByRidAndTypeSelect() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.RID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.FaultDetectionDimension.SOURCE_NODE_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.FaultDetectionDimension.TARGET_NODE_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.FAULT_DETECTION_TYPE.toString()), String.class));
            }
        };
        fields.add((SelectField<?>)DSL.max((Field)DSL.field((String)Fields.ST.toString(), Long.class)).as(DSL.name((String)Fields.ST.toString())));
        fields.add((SelectField<?>)DSL.max((Field)DSL.field((String)Fields.ET.toString(), Long.class)).as(DSL.name((String)Fields.ET.toString())));
        fields.add((SelectField<?>)DSL.max((Field)DSL.field((String)Fields.FAULT.toString(), Integer.class)).as(DSL.name((String)Fields.FAULT.toString())));
        return this.create.select((Collection)fields).from((TableLike)DSL.table((String)this.tableName)).groupBy(new GroupField[]{DSL.field((String)Fields.RID.toString()), DSL.field((String)Fields.FAULT_DETECTION_TYPE.toString())});
    }

    public SelectHavingStep<Record> fetchLatencyTable() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.RID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.FaultDetectionDimension.SOURCE_NODE_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.FaultDetectionDimension.TARGET_NODE_ID.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.FAULT_DETECTION_TYPE.toString()), String.class));
                this.add(DSL.field((String)Fields.ST.toString(), Long.class));
                this.add(DSL.field((String)Fields.ET.toString(), Long.class));
                this.add(DSL.field((String)Fields.FAULT.toString(), Integer.class));
            }
        };
        fields.add((SelectField<?>)DSL.field((String)Fields.ET.toString()).minus(DSL.field((String)Fields.ST.toString())).as(DSL.name((String)Fields.LAT.toString())));
        return this.create.select((Collection)fields).from(this.groupByRidAndTypeSelect()).where(new Condition[]{DSL.field((String)Fields.ET.toString()).isNotNull().and(DSL.field((String)Fields.ST.toString()).isNotNull())});
    }

    public Result<Record> fetchAggregatedTable() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.FaultDetectionDimension.SOURCE_NODE_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.FaultDetectionDimension.TARGET_NODE_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.FAULT_DETECTION_TYPE.toString()), String.class));
                this.add(DSL.sum((Field)DSL.field((Name)DSL.name((String)Fields.LAT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.LAT.toString(), "sum")));
                this.add(DSL.avg((Field)DSL.field((Name)DSL.name((String)Fields.LAT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.LAT.toString(), "avg")));
                this.add(DSL.min((Field)DSL.field((Name)DSL.name((String)Fields.LAT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.LAT.toString(), "min")));
                this.add(DSL.max((Field)DSL.field((Name)DSL.name((String)Fields.LAT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.LAT.toString(), "max")));
                this.add(DSL.sum((Field)DSL.field((Name)DSL.name((String)Fields.FAULT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.FAULT.toString(), "sum")));
                this.add(DSL.avg((Field)DSL.field((Name)DSL.name((String)Fields.FAULT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.FAULT.toString(), "avg")));
                this.add(DSL.min((Field)DSL.field((Name)DSL.name((String)Fields.FAULT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.FAULT.toString(), "min")));
                this.add(DSL.max((Field)DSL.field((Name)DSL.name((String)Fields.FAULT.toString()), Double.class)).as(DBUtils.getAggFieldName(Fields.FAULT.toString(), "max")));
            }
        };
        ArrayList groupByFields = new ArrayList<Field<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.FaultDetectionDimension.SOURCE_NODE_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.FaultDetectionDimension.TARGET_NODE_ID.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.FAULT_DETECTION_TYPE.toString()), String.class));
            }
        };
        return this.create.select((Collection)fields).from(this.fetchLatencyTable()).groupBy((Collection)groupByFields).fetch();
    }

    public static enum Fields {
        RID("rid"),
        FAULT_DETECTION_TYPE("type"),
        ST("st"),
        ET("et"),
        LAT("lat"),
        FAULT("fault");

        private final String fieldValue;

        private Fields(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        public String toString() {
            return this.fieldValue;
        }
    }
}

