/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.reader;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatExceptionCode;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.AllMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.EventProcessor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.FaultDetectionMetricsSnapshot;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.ReaderMetricsProcessor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader_writer_shared.Event;
import java.io.File;
import java.sql.Connection;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;

public class FaultDetectionMetricsProcessor
implements EventProcessor {
    private static final Logger LOG = LogManager.getLogger(FaultDetectionMetricsProcessor.class);
    private FaultDetectionMetricsSnapshot faultDetectionMetricsSnapshot;
    private long startTime;
    private long endTime;
    private BatchBindStep handle;

    public FaultDetectionMetricsProcessor(FaultDetectionMetricsSnapshot faultDetectionMetricsSnapshot) {
        this.faultDetectionMetricsSnapshot = faultDetectionMetricsSnapshot;
    }

    static FaultDetectionMetricsProcessor buildFaultDetectionMetricsProcessor(long currWindowStartTime, Connection conn, NavigableMap<Long, FaultDetectionMetricsSnapshot> faultDetectionMetricsMap) {
        if (faultDetectionMetricsMap.get(currWindowStartTime) == null) {
            FaultDetectionMetricsSnapshot faultDetectionMetricsSnapshot = new FaultDetectionMetricsSnapshot(conn, currWindowStartTime);
            Map.Entry<Long, FaultDetectionMetricsSnapshot> entry = faultDetectionMetricsMap.lastEntry();
            if (entry != null) {
                faultDetectionMetricsSnapshot.rolloverInFlightRequests(entry.getValue());
            }
            faultDetectionMetricsMap.put(currWindowStartTime, faultDetectionMetricsSnapshot);
            return new FaultDetectionMetricsProcessor(faultDetectionMetricsSnapshot);
        }
        return new FaultDetectionMetricsProcessor((FaultDetectionMetricsSnapshot)faultDetectionMetricsMap.get(currWindowStartTime));
    }

    @Override
    public void initializeProcessing(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.handle = this.faultDetectionMetricsSnapshot.startBatchPut();
    }

    @Override
    public void finalizeProcessing() {
        if (this.handle.size() > 0) {
            this.handle.execute();
        }
        LOG.debug("Final Fault Detection request metrics {}", this.faultDetectionMetricsSnapshot.fetchAll());
    }

    @Override
    public void processEvent(Event event) {
        String[] keyItems = event.key.split(File.separatorChar == '\\' ? "\\\\" : File.separator);
        assert (keyItems.length == 4);
        if (keyItems[0].equals("fault_detection")) {
            if (keyItems[3].equals("start")) {
                this.emitStartMetric(event, keyItems);
            } else if (keyItems[3].equals("finish")) {
                this.emitFinishMetric(event, keyItems);
            }
        }
    }

    @Override
    public boolean shouldProcessEvent(Event event) {
        return event.key.contains("fault_detection");
    }

    @Override
    public void commitBatchIfRequired() {
        if (this.handle.size() > 500) {
            this.handle.execute();
            this.handle = this.faultDetectionMetricsSnapshot.startBatchPut();
        }
    }

    private void emitStartMetric(Event entry, String[] keyItems) {
        Map<String, String> keyValueMap = ReaderMetricsProcessor.extractEntryData(entry.value);
        String sourceNodeId = keyValueMap.get(AllMetrics.FaultDetectionDimension.SOURCE_NODE_ID.toString());
        String targetNodeId = keyValueMap.get(AllMetrics.FaultDetectionDimension.TARGET_NODE_ID.toString());
        String startTimeVal = keyValueMap.get(AllMetrics.CommonMetric.START_TIME.toString());
        try {
            long st = Long.parseLong(startTimeVal);
            String fault_detection_type = keyItems[1];
            String rid = keyItems[2];
            this.handle.bind(new Object[]{rid, sourceNodeId, targetNodeId, fault_detection_type, st, null, 0});
        }
        catch (NumberFormatException e) {
            LOG.error("Unable to parse string. StartTime:{}", (Object)startTimeVal);
            StatsCollector.instance().logException(StatExceptionCode.READER_PARSER_ERROR);
            throw e;
        }
    }

    private void emitFinishMetric(Event entry, String[] keyItems) {
        Map<String, String> keyValueMap = ReaderMetricsProcessor.extractEntryData(entry.value);
        String sourceNodeId = keyValueMap.get(AllMetrics.FaultDetectionDimension.SOURCE_NODE_ID.toString());
        String targetNodeId = keyValueMap.get(AllMetrics.FaultDetectionDimension.TARGET_NODE_ID.toString());
        String finishTimeVal = keyValueMap.get(AllMetrics.CommonMetric.FINISH_TIME.toString());
        String faultString = keyValueMap.get("fault");
        try {
            long et = Long.parseLong(finishTimeVal);
            int fault = Integer.parseInt(faultString);
            String fault_detection_type = keyItems[1];
            String rid = keyItems[2];
            this.handle.bind(new Object[]{rid, sourceNodeId, targetNodeId, fault_detection_type, null, et, fault});
        }
        catch (NumberFormatException e) {
            LOG.error("Unable to parse string. StartTime:{}, Error:{}", (Object)finishTimeVal, (Object)faultString);
            StatsCollector.instance().logException(StatExceptionCode.READER_PARSER_ERROR);
            throw e;
        }
    }
}

