/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.reader;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.config.PluginSettings;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.config.overrides.ConfigOverridesApplier;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.AllMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.RcaControllerHelper;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.EventProcessor;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader_writer_shared.Event;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.util.JsonConverter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterDetailsEventProcessor
implements EventProcessor {
    private static final Logger LOG = LogManager.getLogger(ClusterDetailsEventProcessor.class);
    private volatile ImmutableList<NodeDetails> nodesDetails = null;
    private final ConfigOverridesApplier overridesApplier;

    public ClusterDetailsEventProcessor() {
        this(new ConfigOverridesApplier());
    }

    public ClusterDetailsEventProcessor(ConfigOverridesApplier overridesApplier) {
        this.overridesApplier = overridesApplier;
    }

    public ClusterDetailsEventProcessor(ClusterDetailsEventProcessor other) {
        if (other.nodesDetails != null) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (NodeDetails oldDetails : other.nodesDetails) {
                builder.add((Object)new NodeDetails(oldDetails));
            }
            this.nodesDetails = builder.build();
            this.overridesApplier = other.getOverridesApplier();
        } else {
            this.overridesApplier = new ConfigOverridesApplier();
        }
    }

    @Override
    public void initializeProcessing(long startTime, long endTime) {
    }

    @Override
    public void finalizeProcessing() {
    }

    @Override
    public void processEvent(Event event) {
        String[] lines = event.value.split(System.lineSeparator());
        if (lines.length < 4) {
            LOG.error("ClusterDetails contain less items than expected. Expected 4, found: {}", (Object)event.value);
            return;
        }
        String overridesJson = lines[1];
        String overrideUpdatedTimestamp = lines[2];
        this.overridesApplier.applyOverride(overridesJson, overrideUpdatedTimestamp);
        ArrayList<NodeDetails> tmpNodesDetails = new ArrayList<NodeDetails>();
        HashSet<String> ids = new HashSet<String>();
        for (int i = 3; i < lines.length; ++i) {
            NodeDetails nodeDetails = new NodeDetails(lines[i]);
            if (ids.add(nodeDetails.getId())) {
                tmpNodesDetails.add(nodeDetails);
                continue;
            }
            LOG.info("node id {}, logged twice.", (Object)nodeDetails.getId());
        }
        this.setNodesDetails(tmpNodesDetails);
    }

    @Override
    public boolean shouldProcessEvent(Event event) {
        return event.key.contains("node_metrics");
    }

    @Override
    public void commitBatchIfRequired() {
    }

    public void setNodesDetails(List<NodeDetails> nodesDetails) {
        this.nodesDetails = ImmutableList.copyOf(nodesDetails);
    }

    public List<NodeDetails> getNodesDetails() {
        if (this.nodesDetails != null) {
            return this.nodesDetails.asList();
        }
        return Collections.emptyList();
    }

    public ConfigOverridesApplier getOverridesApplier() {
        return this.overridesApplier;
    }

    public List<NodeDetails> getDataNodesDetails() {
        List<NodeDetails> allNodes = this.getNodesDetails();
        if (allNodes.size() > 0) {
            return allNodes.stream().filter(p -> p.getRole().equals(AllMetrics.NodeRole.DATA.toString())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public NodeDetails getCurrentNodeDetails() {
        List<NodeDetails> allNodes = this.getNodesDetails();
        if (allNodes.size() > 0) {
            return allNodes.get(0);
        }
        return null;
    }

    public static class NodeDetails {
        private String id;
        private String hostAddress;
        private String role;
        private Boolean isMasterNode;
        private int grpcPort = PluginSettings.instance().getRpcPort();

        NodeDetails(String stringifiedMetrics) {
            Map<String, Object> map = JsonConverter.createMapFrom(stringifiedMetrics);
            this.id = (String)map.get(AllMetrics.NodeDetailColumns.ID.toString());
            this.hostAddress = (String)map.get(AllMetrics.NodeDetailColumns.HOST_ADDRESS.toString());
            this.role = (String)map.get(AllMetrics.NodeDetailColumns.ROLE.toString());
            Object isMasterNodeObject = map.get(AllMetrics.NodeDetailColumns.IS_MASTER_NODE.toString());
            this.isMasterNode = isMasterNodeObject != null ? (Boolean)isMasterNodeObject : null;
        }

        public NodeDetails(AllMetrics.NodeRole role, String id, String hostAddress, boolean isMaster) {
            this(role, id, hostAddress, isMaster, PluginSettings.instance().getRpcPort());
        }

        public NodeDetails(NodeDetails other) {
            if (other != null) {
                this.id = other.id;
                this.hostAddress = other.hostAddress;
                this.isMasterNode = other.isMasterNode;
                this.role = other.role;
            }
        }

        public NodeDetails(AllMetrics.NodeRole role, String id, String hostAddress, boolean isMaster, int grpcPort) {
            this.role = role.toString();
            this.id = id;
            this.hostAddress = hostAddress;
            this.isMasterNode = isMaster;
            this.grpcPort = grpcPort;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{").append("id:").append(this.id).append(" hostAddress:").append(this.hostAddress).append(" role:").append(this.role).append(" isMasterNode:").append(this.isMasterNode).append("}");
            return stringBuilder.toString();
        }

        public String getId() {
            return this.id;
        }

        @Nullable
        public String getHostAddress() {
            return this.hostAddress;
        }

        @Nullable
        public String getRole() {
            return this.role;
        }

        public boolean getIsMasterNode() {
            if (this.isMasterNode == null) {
                String electedMasterHostAddress = RcaControllerHelper.getElectedMasterHostAddress();
                this.isMasterNode = this.hostAddress.equalsIgnoreCase(electedMasterHostAddress);
            }
            return this.isMasterNode;
        }

        public int getGrpcPort() {
            return this.grpcPort;
        }
    }
}

