/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.util;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.MetricEnum;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.Resource;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.ResourceEnum;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.ResourceUtil;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.collector.NodeConfigCache;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NodeConfigCacheReaderUtil {
    private static final Logger LOG = LogManager.getLogger(NodeConfigCacheReaderUtil.class);

    public static Integer readQueueCapacity(NodeConfigCache nodeConfigCache, NodeKey esNode, ResourceEnum resourceEnum) {
        Resource resource = Resource.newBuilder().setResourceEnum(resourceEnum).setMetricEnum(MetricEnum.QUEUE_CAPACITY).build();
        try {
            return (int)nodeConfigCache.get(esNode, resource);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Exception while reading queue capacity from Node Config Cache", (Throwable)e);
            return null;
        }
    }

    public static Long readCacheMaxSizeInBytes(NodeConfigCache nodeConfigCache, NodeKey esNode, ResourceEnum cacheType) {
        try {
            if (cacheType.equals((Object)ResourceEnum.FIELD_DATA_CACHE)) {
                return (long)nodeConfigCache.get(esNode, ResourceUtil.FIELD_DATA_CACHE_MAX_SIZE);
            }
            return (long)nodeConfigCache.get(esNode, ResourceUtil.SHARD_REQUEST_CACHE_MAX_SIZE);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Exception while reading cache max size from Node Config Cache", (Throwable)e);
            return null;
        }
    }

    public static Long readHeapMaxSizeInBytes(NodeConfigCache nodeConfigCache, NodeKey esNode) {
        try {
            return (long)nodeConfigCache.get(esNode, ResourceUtil.HEAP_MAX_SIZE);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Exception while reading heap max size from Node Config Cache", (Throwable)e);
            return null;
        }
    }
}

