/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.temperature;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.FlowUnitMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Rca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Resources;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.temperature.CompactNodeTemperatureFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.temperature.DimensionalTemperatureFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature.CompactNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature.FullNodeTemperatureSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature.NodeLevelDimensionalSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.temperature.dimension.CpuUtilDimensionTemperatureRca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.temperature.dimension.HeapAllocRateTemperatureRca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.temperature.dimension.ShardSizeDimensionTemperatureRca;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NodeTemperatureRca
extends Rca<CompactNodeTemperatureFlowUnit> {
    public static final String TABLE_NAME = NodeTemperatureRca.class.getSimpleName();
    private static final Logger LOG = LogManager.getLogger(NodeTemperatureRca.class);
    private final CpuUtilDimensionTemperatureRca cpuUtilDimensionTemperatureRca;
    private final HeapAllocRateTemperatureRca heapAllocRateTemperatureRca;
    private final ShardSizeDimensionTemperatureRca shardSizeDimensionTemperatureRca;

    public NodeTemperatureRca(CpuUtilDimensionTemperatureRca cpuUtilDimensionTemperatureRca, HeapAllocRateTemperatureRca heapAllocRateTemperatureRca, ShardSizeDimensionTemperatureRca shardSizeDimensionTemperatureRca) {
        super(5L);
        this.cpuUtilDimensionTemperatureRca = cpuUtilDimensionTemperatureRca;
        this.heapAllocRateTemperatureRca = heapAllocRateTemperatureRca;
        this.shardSizeDimensionTemperatureRca = shardSizeDimensionTemperatureRca;
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        List<FlowUnitMessage> flowUnitMessages = args.getWireHopper().readFromWire(args.getNode());
        ArrayList<CompactNodeTemperatureFlowUnit> flowUnitList = new ArrayList<CompactNodeTemperatureFlowUnit>();
        LOG.debug("rca: Executing fromWire: {}", (Object)this.getClass().getSimpleName());
        for (FlowUnitMessage flowUnitMessage : flowUnitMessages) {
            flowUnitList.add(CompactNodeTemperatureFlowUnit.buildFlowUnitFromWrapper(flowUnitMessage));
        }
        this.setFlowUnits(flowUnitList);
    }

    @Override
    public CompactNodeTemperatureFlowUnit operate() {
        List cpuFlowUnits = this.cpuUtilDimensionTemperatureRca.getFlowUnits();
        List heapAllocRateFlowUnits = this.heapAllocRateTemperatureRca.getFlowUnits();
        List shardSizeFlowUnits = this.shardSizeDimensionTemperatureRca.getFlowUnits();
        if (cpuFlowUnits.size() < 1) {
            cpuFlowUnits.add(new DimensionalTemperatureFlowUnit(System.currentTimeMillis()));
        }
        if (heapAllocRateFlowUnits.size() < 1) {
            heapAllocRateFlowUnits.add(new DimensionalTemperatureFlowUnit(System.currentTimeMillis()));
        }
        if (shardSizeFlowUnits.size() < 1) {
            shardSizeFlowUnits.add(new DimensionalTemperatureFlowUnit(System.currentTimeMillis()));
        }
        if (((DimensionalTemperatureFlowUnit)cpuFlowUnits.get(0)).isEmpty() && ((DimensionalTemperatureFlowUnit)heapAllocRateFlowUnits.get(0)).isEmpty() && ((DimensionalTemperatureFlowUnit)shardSizeFlowUnits.get(0)).isEmpty()) {
            return new CompactNodeTemperatureFlowUnit(System.currentTimeMillis());
        }
        ArrayList<NodeLevelDimensionalSummary> nodeDimensionProfiles = new ArrayList<NodeLevelDimensionalSummary>();
        if (!((DimensionalTemperatureFlowUnit)cpuFlowUnits.get(0)).isEmpty()) {
            nodeDimensionProfiles.add(((DimensionalTemperatureFlowUnit)cpuFlowUnits.get(0)).getNodeDimensionProfile());
        }
        if (!((DimensionalTemperatureFlowUnit)heapAllocRateFlowUnits.get(0)).isEmpty()) {
            nodeDimensionProfiles.add(((DimensionalTemperatureFlowUnit)heapAllocRateFlowUnits.get(0)).getNodeDimensionProfile());
        }
        if (!((DimensionalTemperatureFlowUnit)shardSizeFlowUnits.get(0)).isEmpty()) {
            nodeDimensionProfiles.add(((DimensionalTemperatureFlowUnit)shardSizeFlowUnits.get(0)).getNodeDimensionProfile());
        }
        FullNodeTemperatureSummary nodeProfile = this.buildNodeProfile(nodeDimensionProfiles);
        ResourceContext resourceContext = new ResourceContext(Resources.State.UNKNOWN);
        CompactNodeSummary summary = new CompactNodeSummary(nodeProfile.getNodeId(), nodeProfile.getHostAddress());
        summary.fillFromNodeProfile(nodeProfile);
        return new CompactNodeTemperatureFlowUnit(System.currentTimeMillis(), resourceContext, summary, true);
    }

    private FullNodeTemperatureSummary buildNodeProfile(List<NodeLevelDimensionalSummary> dimensionProfiles) {
        InstanceDetails instanceDetails = this.getInstanceDetails();
        FullNodeTemperatureSummary nodeProfile = new FullNodeTemperatureSummary(instanceDetails.getInstanceId().toString(), instanceDetails.getInstanceIp().toString());
        for (NodeLevelDimensionalSummary profile : dimensionProfiles) {
            nodeProfile.updateNodeDimensionProfile(profile);
        }
        return nodeProfile;
    }
}

