/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.temperature;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.MetricFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.temperature.DimensionalTemperatureFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature.NodeLevelDimensionalSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature.ShardProfileSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.HeatZoneAssigner;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.ShardStore;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.TemperatureVector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.metric.temperature.TemperatureMetricsBase;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.metric.temperature.byShard.calculators.AvgShardBasedTemperatureCalculator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.metric.temperature.byShard.calculators.ShardBasedTemperatureCalculator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.metric.temperature.capacity.ShardTotalDiskUsageTemperatureCalculator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.metric.temperature.capacity.calculators.TotalNodeTemperatureCalculator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.metric.temperature.shardIndependent.DiskUsageShardIndependentTemperatureCalculator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.metric.temperature.shardIndependent.calculators.ShardIndependentTemperatureCalculator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Record;
import org.jooq.Result;

public class DimensionalTemperatureCalculator {
    private static final Logger LOG = LogManager.getLogger(DimensionalTemperatureCalculator.class);

    public static DimensionalTemperatureFlowUnit getTemperatureForDimension(ShardStore shardStore, TemperatureDimension metricType, ShardBasedTemperatureCalculator resourceByShardId, AvgShardBasedTemperatureCalculator avgResUsageByAllShards, ShardIndependentTemperatureCalculator resourceShardIndependent, TotalNodeTemperatureCalculator resourcePeakUsage, TemperatureVector.NormalizedValue threshold) {
        List shardIdBasedFlowUnits = resourceByShardId.getFlowUnits();
        List avgResUsageFlowUnits = avgResUsageByAllShards.getFlowUnits();
        List shardIdIndependentFlowUnits = resourceShardIndependent.getFlowUnits();
        List resourcePeakFlowUnits = resourcePeakUsage.getFlowUnits();
        LOG.info("shardIdBasedFlowUnits: {}", shardIdBasedFlowUnits);
        LOG.info("avgResUsageFlowUnits: {}", avgResUsageFlowUnits);
        LOG.info("shardIdIndependentFlowUnits: {}", shardIdIndependentFlowUnits);
        LOG.info("resourcePeakFlowUnits: {}", resourcePeakFlowUnits);
        if (shardIdBasedFlowUnits.size() != 1) {
            if (((MetricFlowUnit)shardIdBasedFlowUnits.get(0)).isEmpty()) {
                LOG.info("Empty shardIdBasedFlowUnits");
                return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
            }
            if (((Record)((MetricFlowUnit)shardIdBasedFlowUnits.get(0)).getData().get(0)).size() != 3) {
                throw new IllegalArgumentException("Size more than expected: " + shardIdBasedFlowUnits);
            }
        }
        if (avgResUsageFlowUnits.size() != 1) {
            if (((MetricFlowUnit)avgResUsageFlowUnits.get(0)).isEmpty()) {
                LOG.info("Empty avgResUsageFlowUnits");
                return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
            }
            if (((MetricFlowUnit)avgResUsageFlowUnits.get(0)).getData().intoArrays().length != 1) {
                throw new IllegalArgumentException("Size more than expected:\n" + ((MetricFlowUnit)avgResUsageFlowUnits.get(0)).getData() + "\n found: " + ((MetricFlowUnit)avgResUsageFlowUnits.get(0)).getData().intoArrays().length);
            }
        }
        if (shardIdIndependentFlowUnits.size() > 1) {
            if (((MetricFlowUnit)shardIdIndependentFlowUnits.get(0)).isEmpty()) {
                LOG.info("Empty shardIdIndependentFlowUnits");
                return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
            }
            if (((MetricFlowUnit)shardIdIndependentFlowUnits.get(0)).getData().intoArrays().length != 1) {
                throw new IllegalArgumentException("Size more than expected: \n" + ((MetricFlowUnit)shardIdIndependentFlowUnits.get(0)).getData());
            }
        }
        if (resourcePeakFlowUnits.size() > 1) {
            if (((MetricFlowUnit)resourcePeakFlowUnits.get(0)).isEmpty()) {
                LOG.info("Empty resourcePeakFlowUnits");
                return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
            }
            if (((MetricFlowUnit)resourcePeakFlowUnits.get(0)).getData().intoArrays().length != 1) {
                throw new IllegalArgumentException("Size more than expected: \n" + ((MetricFlowUnit)resourcePeakFlowUnits.get(0)).getData());
            }
        }
        double avgValOverShards = -1.0;
        try {
            Result<Record> flowUnitData = ((MetricFlowUnit)avgResUsageFlowUnits.get(0)).getData();
            if (flowUnitData == null) {
                return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
            }
            List values = flowUnitData.getValues("shard_avg", Double.class);
            if (values == null || values.get(0) == null) {
                return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
            }
            avgValOverShards = (Double)values.get(0);
        }
        catch (Exception ex) {
            LOG.error("DBError getting shard average: {}.", (Throwable)ex);
            return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
        }
        double totalConsumedInNode = -1.0;
        try {
            Result<Record> flowUnitData = ((MetricFlowUnit)resourcePeakFlowUnits.get(0)).getData();
            if (flowUnitData == null) {
                return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
            }
            List values = flowUnitData.getValues(TemperatureMetricsBase.AGGR_OVER_AGGR_NAME, Double.class);
            if (values == null || values.get(0) == null) {
                return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
            }
            totalConsumedInNode = (Double)values.get(0);
        }
        catch (Exception ex) {
            LOG.error("DBError getting shard average: {}.", (Throwable)ex);
            return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
        }
        TemperatureVector.NormalizedValue avgUsageAcrossShards = TemperatureVector.NormalizedValue.calculate(avgValOverShards, totalConsumedInNode);
        Result<Record> rowsPerShard = ((MetricFlowUnit)shardIdBasedFlowUnits.get(0)).getData();
        NodeLevelDimensionalSummary nodeDimensionProfile = new NodeLevelDimensionalSummary(metricType, avgUsageAcrossShards, totalConsumedInNode);
        nodeDimensionProfile.setNumberOfShards(rowsPerShard.size());
        for (Record record : rowsPerShard) {
            String indexName = (String)record.getValue(ColumnTypes.IndexName.name(), String.class);
            int shardId = (Integer)record.getValue(ColumnTypes.ShardID.name(), Integer.class);
            double usage = (Double)record.getValue(ColumnTypes.sum.name(), Double.class);
            TemperatureVector.NormalizedValue normalizedConsumptionByShard = TemperatureVector.NormalizedValue.calculate(usage, totalConsumedInNode);
            HeatZoneAssigner.Zone heatZoneForShard = HeatZoneAssigner.assign(normalizedConsumptionByShard, avgUsageAcrossShards, threshold);
            ShardProfileSummary shardProfileSummary = shardStore.getOrCreateIfAbsent(indexName, shardId);
            shardProfileSummary.addTemperatureForDimension(metricType, normalizedConsumptionByShard);
            nodeDimensionProfile.addShardToZone(shardProfileSummary, heatZoneForShard);
        }
        return new DimensionalTemperatureFlowUnit(System.currentTimeMillis(), nodeDimensionProfile);
    }

    public static DimensionalTemperatureFlowUnit getTemperatureForDimension(ShardStore shardStore, TemperatureDimension metricType, ShardBasedTemperatureCalculator resourceByShardId, AvgShardBasedTemperatureCalculator avgResUsageByAllShards, ShardTotalDiskUsageTemperatureCalculator shardSizePeakUsage, TemperatureVector.NormalizedValue threshold) {
        DiskUsageShardIndependentTemperatureCalculator diskUsageShardIndependent = new DiskUsageShardIndependentTemperatureCalculator();
        return DimensionalTemperatureCalculator.getTemperatureForDimension(shardStore, metricType, resourceByShardId, avgResUsageByAllShards, diskUsageShardIndependent, shardSizePeakUsage, threshold);
    }

    static enum ColumnTypes {
        IndexName,
        ShardID,
        sum;

    }
}

