/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.temperature;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Rca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Resources;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.temperature.ClusterTemperatureFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.temperature.CompactNodeTemperatureFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature.ClusterTemperatureSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature.CompactClusterLevelNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature.CompactNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.TemperatureVector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.temperature.NodeTemperatureRca;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterTemperatureRca
extends Rca<ClusterTemperatureFlowUnit> {
    private final NodeTemperatureRca nodeTemperatureRca;
    public static final String TABLE_NAME = ClusterTemperatureRca.class.getSimpleName();

    public ClusterTemperatureRca(NodeTemperatureRca nodeTemperatureRca) {
        super(5L);
        this.nodeTemperatureRca = nodeTemperatureRca;
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        throw new IllegalArgumentException(this.name() + "'s generateFlowUnitListFromWire() should not be required.");
    }

    @Override
    public ClusterTemperatureFlowUnit operate() {
        List<CompactNodeTemperatureFlowUnit> flowUnits = this.nodeTemperatureRca.getFlowUnits();
        HashMap<String, CompactClusterLevelNodeSummary> nodeTemperatureSummaryMap = new HashMap<String, CompactClusterLevelNodeSummary>();
        int NUM_NODES = flowUnits.size();
        ClusterTemperatureSummary clusterTemperatureSummary = new ClusterTemperatureSummary(NUM_NODES);
        for (TemperatureDimension dimension : TemperatureDimension.values()) {
            double totalForDimension = 0.0;
            boolean allFlowUnitSummariesNull = true;
            for (CompactNodeTemperatureFlowUnit nodeFlowUnit : flowUnits) {
                CompactNodeSummary summary = nodeFlowUnit.getCompactNodeTemperatureSummary();
                if (summary == null) continue;
                totalForDimension += summary.getTotalConsumedByDimension(dimension);
                allFlowUnitSummariesNull = false;
            }
            if (allFlowUnitSummariesNull) continue;
            double nodeAverageForDimension = totalForDimension / (double)NUM_NODES;
            TemperatureVector.NormalizedValue normalizedAvgForDimension = TemperatureVector.NormalizedValue.calculate(nodeAverageForDimension, totalForDimension);
            clusterTemperatureSummary.createClusterDimensionalTemperature(dimension, normalizedAvgForDimension, totalForDimension);
            this.recalibrateNodeTemperaturesAtClusterLevelUsage(flowUnits, nodeTemperatureSummaryMap, dimension, totalForDimension, nodeAverageForDimension);
        }
        clusterTemperatureSummary.addNodesSummaries(nodeTemperatureSummaryMap);
        return new ClusterTemperatureFlowUnit(System.currentTimeMillis(), new ResourceContext(Resources.State.UNKNOWN), clusterTemperatureSummary);
    }

    private void recalibrateNodeTemperaturesAtClusterLevelUsage(List<CompactNodeTemperatureFlowUnit> flowUnits, Map<String, CompactClusterLevelNodeSummary> nodeTemperatureSummaryMap, TemperatureDimension dimension, double totalForDimension, double avgForTheDimension) {
        for (CompactNodeTemperatureFlowUnit nodeFlowUnit : flowUnits) {
            CompactNodeSummary obtainedNodeTempSummary = nodeFlowUnit.getCompactNodeTemperatureSummary();
            if (obtainedNodeTempSummary == null) continue;
            String key = obtainedNodeTempSummary.getNodeId();
            nodeTemperatureSummaryMap.putIfAbsent(key, new CompactClusterLevelNodeSummary(obtainedNodeTempSummary.getNodeId(), obtainedNodeTempSummary.getHostAddress()));
            CompactClusterLevelNodeSummary constructedCompactNodeTemperatureSummary = nodeTemperatureSummaryMap.get(key);
            double obtainedTotal = obtainedNodeTempSummary.getTotalConsumedByDimension(dimension);
            TemperatureVector.NormalizedValue newClusterBasedValue = TemperatureVector.NormalizedValue.calculate(obtainedTotal, totalForDimension);
            constructedCompactNodeTemperatureSummary.setTemperatureForDimension(dimension, newClusterBasedValue);
            constructedCompactNodeTemperatureSummary.setNumOfShards(dimension, obtainedNodeTempSummary.getNumberOfShardsByDimension(dimension));
            constructedCompactNodeTemperatureSummary.setTotalConsumedByDimension(dimension, obtainedTotal);
        }
    }
}

