/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.jvmsizing;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.FlowUnitMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.configs.OldGenContendedRcaConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Rca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Resources;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.RcaConf;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.util.MemInfoParser;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OldGenContendedRca
extends Rca<ResourceFlowUnit<HotNodeSummary>> {
    private static final Logger LOG = LogManager.getLogger(OldGenContendedRca.class);
    private static final String OLD_GEN_CONTENDED_METRIC = "OldGenContended";
    private static final long GB_TO_B = 0x40000000L;
    private static final long EVAL_INTERVAL_IN_S = 5L;
    private Rca<ResourceFlowUnit<HotResourceSummary>> highOldGenOccupancyRca;
    private Rca<ResourceFlowUnit<HotResourceSummary>> oldGenReclamationRca;
    private int minTotalMemoryThresholdInGB = 200;
    private final long totalMemory;

    public OldGenContendedRca(Rca<ResourceFlowUnit<HotResourceSummary>> highOldGenOccupancyRca, Rca<ResourceFlowUnit<HotResourceSummary>> oldGenReclamationRca) {
        super(5L);
        this.highOldGenOccupancyRca = highOldGenOccupancyRca;
        this.oldGenReclamationRca = oldGenReclamationRca;
        this.totalMemory = MemInfoParser.getTotalMemory();
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        List<FlowUnitMessage> flowUnitMessages = args.getWireHopper().readFromWire(args.getNode());
        this.setFlowUnits(flowUnitMessages.stream().map(ResourceFlowUnit::buildFlowUnitFromWrapper).collect(Collectors.toList()));
    }

    @Override
    public ResourceFlowUnit<HotNodeSummary> operate() {
        List oldGenOccupancyFlowUnits = this.highOldGenOccupancyRca.getFlowUnits();
        List oldGenReclamationFlowUnits = this.oldGenReclamationRca.getFlowUnits();
        long currTime = System.currentTimeMillis();
        if (oldGenOccupancyFlowUnits.size() != 1 || oldGenReclamationFlowUnits.size() != 1) {
            LOG.warn("Was expecting both oldGenOccupancy and oldGenReclamation RCAs to have exactly one flowunit. Found: " + oldGenOccupancyFlowUnits.size() + ", and " + oldGenReclamationFlowUnits.size() + " respectively");
            return new ResourceFlowUnit<HotNodeSummary>(currTime);
        }
        if (this.totalMemory < (long)this.minTotalMemoryThresholdInGB * 0x40000000L) {
            return new ResourceFlowUnit<HotNodeSummary>(currTime);
        }
        ResourceFlowUnit oldGenOccupancyFlowUnit = (ResourceFlowUnit)oldGenOccupancyFlowUnits.get(0);
        ResourceFlowUnit oldGenReclamationFlowUnit = (ResourceFlowUnit)oldGenReclamationFlowUnits.get(0);
        if (!oldGenOccupancyFlowUnit.isEmpty()) {
            boolean isOccupancyUnhealthy = oldGenOccupancyFlowUnit.getResourceContext().isUnhealthy();
            boolean isFullGcIneffective = oldGenReclamationFlowUnit.getResourceContext().isUnhealthy();
            if (isOccupancyUnhealthy && isFullGcIneffective) {
                InstanceDetails instanceDetails = this.getAppContext().getMyInstanceDetails();
                HotNodeSummary summary = new HotNodeSummary(instanceDetails.getInstanceId(), instanceDetails.getInstanceIp());
                summary.appendNestedSummary((HotResourceSummary)oldGenOccupancyFlowUnit.getSummary());
                summary.appendNestedSummary((HotResourceSummary)oldGenReclamationFlowUnit.getSummary());
                ResourceContext context = new ResourceContext(Resources.State.CONTENDED);
                StatsCollector.instance().logMetric(OLD_GEN_CONTENDED_METRIC);
                return new ResourceFlowUnit<HotNodeSummary>(currTime, context, summary);
            }
        }
        return new ResourceFlowUnit<HotNodeSummary>(currTime);
    }

    @Override
    public void readRcaConf(RcaConf conf) {
        super.readRcaConf(conf);
        this.readTotalMemThresholdFromConf(conf);
    }

    private void readTotalMemThresholdFromConf(RcaConf conf) {
        OldGenContendedRcaConfig rcaConfig = conf.getOldGenContendedRcaConfig();
        this.minTotalMemoryThresholdInGB = rcaConfig.getMinTotalMemoryThresholdInGb();
    }
}

