/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.jvmsizing;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatExceptionCode;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.configs.HighOldGenOccupancyRcaConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Metric;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Resources;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindow;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindowData;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.ResourceUtil;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.RcaConf;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.OldGenRca;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HighOldGenOccupancyRca
extends OldGenRca<ResourceFlowUnit<HotResourceSummary>> {
    private static final Logger LOG = LogManager.getLogger(HighOldGenOccupancyRca.class);
    private static final String OLD_GEN_OVER_OCCUPIED_METRIC = "OldGenOverOccupied";
    private static final long EVAL_INTERVAL_IN_S = 5L;
    private static final int B_TO_MB = 0x100000;
    private final Metric heapUsed;
    private final Metric heapMax;
    private final Metric gcType;
    private final SlidingWindow<SlidingWindowData> oldGenUtilizationSlidingWindow = new SlidingWindow(1, TimeUnit.MINUTES);
    private long heapUtilizationThreshold;
    private long rcaEvaluationIntervalInS;
    private long rcaSamplesBeforeEval;
    private long samples;
    private ResourceContext previousContext;
    private HotResourceSummary previousSummary;

    public HighOldGenOccupancyRca(Metric heapMax, Metric heapUsed, Metric gcType) {
        this(heapMax, heapUsed, gcType, 75L, 60L);
    }

    public HighOldGenOccupancyRca(Metric heapMax, Metric heapUsed, Metric gcType, long heapUtilizationThreshold, long rcaEvaluationIntervalInS) {
        super(5L, heapUsed, heapMax, null, gcType);
        this.heapUsed = heapUsed;
        this.heapMax = heapMax;
        this.gcType = gcType;
        this.heapUtilizationThreshold = heapUtilizationThreshold;
        this.rcaEvaluationIntervalInS = rcaEvaluationIntervalInS;
        this.rcaSamplesBeforeEval = rcaEvaluationIntervalInS / 5L;
        this.samples = 0L;
        this.previousContext = new ResourceContext(Resources.State.UNKNOWN);
        this.previousSummary = null;
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        throw new UnsupportedOperationException("generateFlowUnitListFromWire should not be called for node-local rca: " + args.getNode().name());
    }

    @Override
    public ResourceFlowUnit<HotResourceSummary> operate() {
        if (!this.isOldGenCollectorCMS()) {
            return new ResourceFlowUnit<HotResourceSummary>(System.currentTimeMillis());
        }
        ++this.samples;
        this.addToSlidingWindow();
        if (this.samples == this.rcaSamplesBeforeEval) {
            this.samples = 0L;
            return this.evaluateAndEmit();
        }
        return new ResourceFlowUnit<HotResourceSummary>(System.currentTimeMillis(), this.previousContext, this.previousSummary);
    }

    private ResourceFlowUnit<HotResourceSummary> evaluateAndEmit() {
        long currTime = System.currentTimeMillis();
        double averageUtilizationPercentage = this.oldGenUtilizationSlidingWindow.readAvg();
        ResourceContext context = new ResourceContext(Resources.State.HEALTHY);
        HotResourceSummary summary = new HotResourceSummary(ResourceUtil.OLD_GEN_HEAP_USAGE, this.heapUtilizationThreshold, averageUtilizationPercentage, (int)this.rcaEvaluationIntervalInS);
        if (averageUtilizationPercentage >= (double)this.heapUtilizationThreshold) {
            StatsCollector.instance().logMetric(OLD_GEN_OVER_OCCUPIED_METRIC);
            context = new ResourceContext(Resources.State.UNHEALTHY);
        }
        this.previousSummary = summary;
        this.previousContext = context;
        return new ResourceFlowUnit<HotResourceSummary>(currTime, context, summary);
    }

    private void addToSlidingWindow() {
        double oldGenUsed = this.getOldGenUsedOrDefault(0.0);
        double maxOldGen = this.getMaxOldGenSizeOrDefault(Double.MAX_VALUE);
        if (maxOldGen == 0.0) {
            LOG.info("Max Old Gen capacity cannot be 0. Skipping.");
            StatsCollector.instance().logException(StatExceptionCode.INVALID_OLD_GEN_SIZE);
            return;
        }
        this.oldGenUtilizationSlidingWindow.next(new SlidingWindowData(System.currentTimeMillis(), oldGenUsed / maxOldGen * 100.0));
    }

    @Override
    public void readRcaConf(RcaConf conf) {
        HighOldGenOccupancyRcaConfig config = conf.getHighOldGenOccupancyRcaConfig();
        this.rcaEvaluationIntervalInS = config.getEvaluationIntervalInS();
        this.heapUtilizationThreshold = config.getHeapUtilizationThreshold();
        this.rcaSamplesBeforeEval = this.rcaEvaluationIntervalInS / 5L;
    }
}

