/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.hotheap;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Metric;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.MetricFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.hotshard.IndexShardKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Record;
import org.jooq.Result;

public class NodeStatAggregator {
    private static final Logger LOG = LogManager.getLogger(NodeStatAggregator.class);
    private Metric nodeStatMetric;
    private int sum;
    private final HashMap<IndexShardKey, NodeStatValue> shardKeyMap;
    private long lastPurgeTimestamp;
    private static final int PURGE_HASH_TABLE_INTERVAL_IN_MINS = 30;

    public NodeStatAggregator(Metric nodeStatMetric) {
        this.nodeStatMetric = nodeStatMetric;
        this.sum = 0;
        this.lastPurgeTimestamp = 0L;
        this.shardKeyMap = new HashMap();
    }

    public boolean isEmpty() {
        return this.shardKeyMap.isEmpty();
    }

    public String getName() {
        return this.nodeStatMetric.name();
    }

    public int getSum() {
        return this.sum;
    }

    public void collect(long timestamp) {
        for (MetricFlowUnit metric : this.nodeStatMetric.getFlowUnits()) {
            if (metric.isEmpty()) continue;
            Result<Record> result = metric.getData();
            for (Record record : result) {
                try {
                    IndexShardKey shardKey = IndexShardKey.buildIndexShardKey(record);
                    Integer value = (Integer)record.getValue("max", Integer.class);
                    NodeStatValue oldNodeStatValue = this.shardKeyMap.getOrDefault(shardKey, new NodeStatValue(0, 0L));
                    this.shardKeyMap.put(shardKey, new NodeStatValue(value, timestamp));
                    this.sum += value - oldNodeStatValue.getValue();
                }
                catch (Exception e) {
                    LOG.error("Fail to parse node stats {}", (Object)this.getName());
                }
            }
        }
        if (TimeUnit.MILLISECONDS.toMinutes(timestamp - this.lastPurgeTimestamp) > 30L) {
            this.purgeHashTable(timestamp);
        }
    }

    private void purgeHashTable(long timestamp) {
        Iterator<NodeStatValue> iterator = this.shardKeyMap.values().iterator();
        while (iterator.hasNext()) {
            NodeStatValue value = iterator.next();
            long timestampDiff = timestamp - value.getTimestamp();
            if (TimeUnit.MILLISECONDS.toMinutes(timestampDiff) <= 30L) continue;
            this.sum -= value.getValue();
            iterator.remove();
        }
    }

    private static class NodeStatValue {
        private int value;
        private long timestamp;

        public NodeStatValue(int value, long timestamp) {
            this.value = value;
            this.timestamp = timestamp;
        }

        public int getValue() {
            return this.value;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

