/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.hotheap;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.configs.HighHeapUsageOldGenRcaConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Metric;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Resources;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindow;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindowData;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.ResourceUtil;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.TopConsumerSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.RcaConf;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaVerticesMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.OldGenRca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.hotheap.NodeStatAggregator;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HighHeapUsageOldGenRca
extends OldGenRca<ResourceFlowUnit<HotResourceSummary>> {
    private static final Logger LOG = LogManager.getLogger(HighHeapUsageOldGenRca.class);
    private int counter;
    private final List<NodeStatAggregator> nodeStatAggregators;
    private final int rcaPeriod;
    private final double lowerBoundThreshold;
    private final SlidingWindow<SlidingWindowData> gcEventSlidingWindow;
    private final OldGenRca.MinOldGenSlidingWindow minOldGenSlidingWindow;
    private static final int SLIDING_WINDOW_SIZE_IN_MINS = 10;
    private static final double OLD_GEN_USED_THRESHOLD_IN_PERCENTAGE = 0.65;
    private static final double OLD_GEN_GC_THRESHOLD = 1.0;
    private int topK;
    protected Clock clock = Clock.systemUTC();

    public <M extends Metric> HighHeapUsageOldGenRca(int rcaPeriod, double lowerBoundThreshold, M heap_Used, M gc_event, M heap_Max, List<Metric> consumers) {
        super(5L, heap_Used, heap_Max, gc_event, null);
        this.rcaPeriod = rcaPeriod;
        this.lowerBoundThreshold = lowerBoundThreshold >= 0.0 && lowerBoundThreshold <= 1.0 ? lowerBoundThreshold : 1.0;
        this.counter = 0;
        this.gcEventSlidingWindow = new SlidingWindow(10, TimeUnit.MINUTES);
        this.minOldGenSlidingWindow = new OldGenRca.MinOldGenSlidingWindow(10, TimeUnit.MINUTES);
        this.nodeStatAggregators = new ArrayList<NodeStatAggregator>();
        for (Metric consumerMetric : consumers) {
            if (consumerMetric == null) continue;
            this.nodeStatAggregators.add(new NodeStatAggregator(consumerMetric));
        }
        this.topK = 3;
    }

    public <M extends Metric> HighHeapUsageOldGenRca(int rcaPeriod, M heap_Used, M gc_event, M heap_Max, List<Metric> consumers) {
        this(rcaPeriod, 1.0, heap_Used, gc_event, heap_Max, consumers);
    }

    @Override
    public ResourceFlowUnit<HotResourceSummary> operate() {
        ++this.counter;
        double oldGenHeapUsed = this.getOldGenUsedOrDefault(Double.NaN);
        int oldGenGCEvent = this.getFullGcEventsOrDefault(0.0);
        double maxTotalHeapSize = this.getMaxHeapSizeOrDefault(Double.MAX_VALUE);
        long currTimeStamp = this.clock.millis();
        if (!Double.isNaN(oldGenHeapUsed)) {
            LOG.debug("oldGenHeapUsed = {}, oldGenGCEvent = {}, maxOldGenHeapSize = {}", (Object)oldGenHeapUsed, (Object)oldGenGCEvent, (Object)maxTotalHeapSize);
            this.gcEventSlidingWindow.next(new SlidingWindowData(currTimeStamp, oldGenGCEvent));
            this.minOldGenSlidingWindow.next(new SlidingWindowData(currTimeStamp, oldGenHeapUsed));
        }
        for (NodeStatAggregator nodeStatAggregator : this.nodeStatAggregators) {
            nodeStatAggregator.collect(currTimeStamp);
        }
        if (this.counter == this.rcaPeriod) {
            ResourceContext context = null;
            HotResourceSummary summary = null;
            this.counter = 0;
            double currentMinOldGenUsage = this.minOldGenSlidingWindow.readMin();
            if (this.gcEventSlidingWindow.readSum() >= 1.0 && !Double.isNaN(currentMinOldGenUsage) && currentMinOldGenUsage / maxTotalHeapSize > 0.65) {
                LOG.debug("heapUsage is above threshold. OldGGenGCEvent = {}, oldGenUsage percentage = {}", (Object)this.gcEventSlidingWindow.readSum(), (Object)(currentMinOldGenUsage / maxTotalHeapSize));
                context = new ResourceContext(Resources.State.UNHEALTHY);
                PerformanceAnalyzerApp.RCA_VERTICES_METRICS_AGGREGATOR.updateStat(RcaVerticesMetrics.NUM_OLD_GEN_RCA_TRIGGERED, "", 1);
            } else {
                context = new ResourceContext(Resources.State.HEALTHY);
            }
            if (this.gcEventSlidingWindow.readSum() >= 1.0 && !Double.isNaN(currentMinOldGenUsage) && currentMinOldGenUsage / maxTotalHeapSize > 0.65 * this.lowerBoundThreshold) {
                summary = new HotResourceSummary(ResourceUtil.OLD_GEN_HEAP_USAGE, 0.65, currentMinOldGenUsage / maxTotalHeapSize, 600);
                this.addTopConsumers(summary);
            }
            LOG.debug("High Heap Usage RCA Context = " + context.toString());
            return new ResourceFlowUnit<Object>(this.clock.millis(), context, summary);
        }
        LOG.debug("Empty FlowUnit returned for High Heap Usage RCA");
        return new ResourceFlowUnit<HotResourceSummary>(this.clock.millis());
    }

    private void addTopConsumers(HotResourceSummary summary) {
        this.nodeStatAggregators.sort((n1, n2) -> Integer.compare(n2.getSum(), n1.getSum()));
        for (NodeStatAggregator aggregator : this.nodeStatAggregators) {
            if (aggregator.isEmpty()) continue;
            if (summary.getNestedSummaryList().size() >= this.topK) break;
            summary.appendNestedSummary(new TopConsumerSummary(aggregator.getName(), aggregator.getSum()));
        }
    }

    @Override
    public void readRcaConf(RcaConf conf) {
        HighHeapUsageOldGenRcaConfig configObj = conf.getHighHeapUsageOldGenRcaConfig();
        this.topK = configObj.getTopK();
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        throw new IllegalArgumentException(this.name() + "'s generateFlowUnitListFromWire() should not be required.");
    }
}

