/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.hot_node;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.Resource;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Metric;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Rca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Resources;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindow;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindowData;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.MetricFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.TopConsumerSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import java.time.Clock;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.exception.DataTypeException;

public class GenericResourceRca
extends Rca<ResourceFlowUnit<HotResourceSummary>> {
    private static final Logger LOG = LogManager.getLogger(GenericResourceRca.class);
    private static final int SLIDING_WINDOW_IN_MIN = 10;
    private static final int DEFAULT_TOP_K = 3;
    private static final double DEFAULT_LOWER_BOUND_THRESHOLD = 0.0;
    private final SlidingWindow<SlidingWindowData> slidingWindow;
    private final Metric resourceUsageGroupByConsumer;
    private final int rcaPeriod;
    private int counter;
    private final Resource resource;
    private volatile double threshold;
    private volatile double lowerBoundThreshold;
    private volatile int topK;
    protected Clock clock;

    public <M extends Metric> GenericResourceRca(int rcaPeriod, Resource resource, double threshold, M resourceUsageGroupByConsumer) {
        super(5L);
        this.resourceUsageGroupByConsumer = resourceUsageGroupByConsumer;
        this.slidingWindow = new SlidingWindow(10, TimeUnit.MINUTES);
        this.rcaPeriod = rcaPeriod;
        this.counter = 0;
        this.clock = Clock.systemUTC();
        this.threshold = threshold;
        this.lowerBoundThreshold = 0.0;
        this.resource = resource;
        this.topK = 3;
    }

    public void setTopK(int topK) {
        this.topK = Math.max(topK, 0);
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public void setLowerBoundThreshold(double lowerBoundThreshold) {
        this.lowerBoundThreshold = lowerBoundThreshold;
    }

    @Override
    public ResourceFlowUnit<HotResourceSummary> operate() {
        ++this.counter;
        for (MetricFlowUnit flowunit : this.resourceUsageGroupByConsumer.getFlowUnits()) {
            Result<Record> result;
            if (flowunit.isEmpty() || (result = flowunit.getData()) == null) continue;
            boolean recordParsingError = false;
            double totalUsage = 0.0;
            for (Record record : result) {
                int fieldSize = record.size();
                if (fieldSize < 2) {
                    LOG.error("Field size {} is less than 2, the SQL record has wrong data format", (Object)fieldSize);
                    recordParsingError = true;
                    break;
                }
                try {
                    double num = (Double)record.getValue(fieldSize - 1, Double.class);
                    totalUsage += num;
                }
                catch (DataTypeException de) {
                    LOG.error("Fail to data field from SQL record, field index : {}, trace : {}", (Object)(fieldSize - 1), (Object)de.getStackTrace());
                    recordParsingError = true;
                    break;
                }
            }
            if (recordParsingError) continue;
            this.slidingWindow.next(new SlidingWindowData(this.clock.millis(), totalUsage));
        }
        if (this.counter == this.rcaPeriod) {
            ResourceContext context = null;
            HotResourceSummary summary = null;
            this.counter = 0;
            double avgCpuUsage = this.slidingWindow.readAvg();
            context = !Double.isNaN(avgCpuUsage) && avgCpuUsage > this.threshold ? new ResourceContext(Resources.State.CONTENDED) : new ResourceContext(Resources.State.HEALTHY);
            if (!Double.isNaN(avgCpuUsage) && avgCpuUsage >= this.lowerBoundThreshold) {
                summary = new HotResourceSummary(this.resource, this.threshold, avgCpuUsage, 600);
                this.addTopConsumerSummary(summary);
            }
            return new ResourceFlowUnit<Object>(this.clock.millis(), context, summary);
        }
        return new ResourceFlowUnit<HotResourceSummary>(this.clock.millis());
    }

    private void addTopConsumerSummary(HotResourceSummary summary) {
        List flowUnits = this.resourceUsageGroupByConsumer.getFlowUnits();
        if (!flowUnits.isEmpty() && ((MetricFlowUnit)flowUnits.get(0)).getData() != null) {
            for (Record record : ((MetricFlowUnit)flowUnits.get(0)).getData()) {
                if (summary.getNestedSummaryList().size() >= this.topK) break;
                int fieldSize = record.size();
                try {
                    double num = (Double)record.getValue(fieldSize - 1, Double.class);
                    String name = (String)record.getValue(0, String.class);
                    summary.appendNestedSummary(new TopConsumerSummary(name, num));
                }
                catch (DataTypeException de) {
                    LOG.error("Fail to read some field from SQL record, trace : {}", (Object[])de.getStackTrace());
                    break;
                }
            }
        }
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        LOG.error("rca: {} is not supposed to be received from wire", (Object)this.getClass().getSimpleName());
    }
}

