/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cache;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.FlowUnitMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.Resource;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.configs.ShardRequestCacheRcaConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Metric;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Rca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Resources;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.MetricFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.ResourceUtil;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.RcaConf;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaVerticesMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cache.CacheUtil;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Record;
import org.jooq.Result;

public class ShardRequestCacheRca
extends Rca<ResourceFlowUnit<HotNodeSummary>> {
    private static final Logger LOG = LogManager.getLogger(ShardRequestCacheRca.class);
    private final Metric shardRequestCacheEvictions;
    private final Metric shardRequestCacheHits;
    private final Metric shardRequestCacheSizeGroupByOperation;
    private final int rcaPeriod;
    private int counter;
    private double cacheSizeThreshold;
    protected Clock clock;
    private final CacheCollector cacheEvictionCollector;
    private final CacheCollector cacheHitCollector;

    public <M extends Metric> ShardRequestCacheRca(int rcaPeriod, M shardRequestCacheEvictions, M shardRequestCacheHits, M shardRequestCacheSizeGroupByOperation) {
        super(5L);
        this.rcaPeriod = rcaPeriod;
        this.shardRequestCacheEvictions = shardRequestCacheEvictions;
        this.shardRequestCacheHits = shardRequestCacheHits;
        this.shardRequestCacheSizeGroupByOperation = shardRequestCacheSizeGroupByOperation;
        this.counter = 0;
        this.cacheSizeThreshold = 0.9;
        this.clock = Clock.systemUTC();
        this.cacheEvictionCollector = new CacheCollector(ResourceUtil.SHARD_REQUEST_CACHE_EVICTION, shardRequestCacheEvictions, 300);
        this.cacheHitCollector = new CacheCollector(ResourceUtil.SHARD_REQUEST_CACHE_HIT, shardRequestCacheHits, 300);
    }

    @VisibleForTesting
    public void setClock(Clock clock) {
        this.clock = clock;
    }

    @Override
    public ResourceFlowUnit operate() {
        ++this.counter;
        long currTimestamp = this.clock.millis();
        this.cacheEvictionCollector.collect(currTimestamp);
        this.cacheHitCollector.collect(currTimestamp);
        if (this.counter >= this.rcaPeriod) {
            ResourceContext context;
            InstanceDetails instanceDetails = this.getInstanceDetails();
            HotNodeSummary nodeSummary = new HotNodeSummary(instanceDetails.getInstanceId(), instanceDetails.getInstanceIp());
            double shardRequestCacheMaxSizeInBytes = CacheUtil.getCacheMaxSize(this.getAppContext(), new NodeKey(instanceDetails), ResourceUtil.SHARD_REQUEST_CACHE_MAX_SIZE);
            Boolean exceedsSizeThreshold = CacheUtil.isSizeThresholdExceeded(this.shardRequestCacheSizeGroupByOperation, shardRequestCacheMaxSizeInBytes, this.cacheSizeThreshold);
            if (this.cacheEvictionCollector.isUnhealthy(currTimestamp) && this.cacheHitCollector.isUnhealthy(currTimestamp) && exceedsSizeThreshold.booleanValue()) {
                context = new ResourceContext(Resources.State.UNHEALTHY);
                nodeSummary.appendNestedSummary(this.cacheEvictionCollector.generateSummary(currTimestamp));
                PerformanceAnalyzerApp.RCA_VERTICES_METRICS_AGGREGATOR.updateStat(RcaVerticesMetrics.NUM_SHARD_REQUEST_CACHE_RCA_TRIGGERED, instanceDetails.getInstanceId().toString(), 1);
            } else {
                context = new ResourceContext(Resources.State.HEALTHY);
            }
            this.counter = 0;
            return new ResourceFlowUnit<HotNodeSummary>(currTimestamp, context, nodeSummary, !instanceDetails.getIsMaster());
        }
        return new ResourceFlowUnit(currTimestamp);
    }

    @Override
    public void readRcaConf(RcaConf conf) {
        ShardRequestCacheRcaConfig configObj = conf.getShardRequestCacheRcaConfig();
        this.cacheSizeThreshold = configObj.getShardRequestCacheSizeThreshold();
        long cacheCollectorTimePeriodInSec = TimeUnit.SECONDS.toMillis(configObj.getShardRequestCollectorTimePeriodInSec());
        this.cacheHitCollector.setCollectorTimePeriod(cacheCollectorTimePeriodInSec);
        this.cacheEvictionCollector.setCollectorTimePeriod(cacheCollectorTimePeriodInSec);
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        List<FlowUnitMessage> flowUnitMessages = args.getWireHopper().readFromWire(args.getNode());
        ArrayList flowUnitList = new ArrayList();
        LOG.debug("rca: Executing fromWire: {}", (Object)this.getClass().getSimpleName());
        for (FlowUnitMessage flowUnitMessage : flowUnitMessages) {
            flowUnitList.add(ResourceFlowUnit.buildFlowUnitFromWrapper(flowUnitMessage));
        }
        this.setFlowUnits(flowUnitList);
    }

    private static class CacheCollector {
        private final Resource cache;
        private final Metric cacheMetrics;
        private boolean hasMetric;
        private long metricTimestamp;
        private long metricTimePeriodInMillis;

        public CacheCollector(Resource cache, Metric cacheMetrics, int metricTimePeriodInSec) {
            this.cache = cache;
            this.cacheMetrics = cacheMetrics;
            this.hasMetric = false;
            this.metricTimestamp = 0L;
            this.metricTimePeriodInMillis = TimeUnit.SECONDS.toMillis(metricTimePeriodInSec);
        }

        public void setCollectorTimePeriod(long metricTimePeriodInMillis) {
            this.metricTimePeriodInMillis = metricTimePeriodInMillis;
        }

        public void collect(long currTimestamp) {
            for (MetricFlowUnit flowUnit : this.cacheMetrics.getFlowUnits()) {
                if (flowUnit.isEmpty()) continue;
                Result<Record> records = flowUnit.getData();
                double metricCount = records.stream().mapToDouble(record -> (Double)record.getValue("max", Double.class)).sum();
                if (!Double.isNaN(metricCount)) {
                    if (metricCount > 0.0) {
                        if (!this.hasMetric) {
                            this.metricTimestamp = currTimestamp;
                        }
                        this.hasMetric = true;
                        continue;
                    }
                    this.hasMetric = false;
                    continue;
                }
                LOG.error("Failed to parse metric from cache {}", (Object)this.cache.toString());
            }
        }

        public boolean isUnhealthy(long currTimestamp) {
            return this.hasMetric && currTimestamp - this.metricTimestamp >= this.metricTimePeriodInMillis;
        }

        private HotResourceSummary generateSummary(long currTimestamp) {
            return new HotResourceSummary(this.cache, TimeUnit.MILLISECONDS.toSeconds(this.metricTimePeriodInMillis), TimeUnit.MILLISECONDS.toSeconds(currTimestamp - this.metricTimestamp), 0);
        }
    }
}

