/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cache;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.FlowUnitMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.Resource;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.configs.FieldDataCacheRcaConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Metric;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Rca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Resources;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.MetricFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.ResourceUtil;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.RcaConf;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaVerticesMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cache.CacheUtil;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FieldDataCacheRca
extends Rca<ResourceFlowUnit<HotNodeSummary>> {
    private static final Logger LOG = LogManager.getLogger(FieldDataCacheRca.class);
    private final Metric fieldDataCacheEvictions;
    private final Metric fieldDataCacheSizeGroupByOperation;
    private final int rcaPeriod;
    private int counter;
    private double cacheSizeThreshold;
    protected Clock clock;
    private final CacheEvictionCollector cacheEvictionCollector;

    public <M extends Metric> FieldDataCacheRca(int rcaPeriod, M fieldDataCacheEvictions, M fieldDataCacheSizeGroupByOperation) {
        super(5L);
        this.rcaPeriod = rcaPeriod;
        this.fieldDataCacheEvictions = fieldDataCacheEvictions;
        this.fieldDataCacheSizeGroupByOperation = fieldDataCacheSizeGroupByOperation;
        this.counter = 0;
        this.cacheSizeThreshold = 0.8;
        this.clock = Clock.systemUTC();
        this.cacheEvictionCollector = new CacheEvictionCollector(ResourceUtil.FIELD_DATA_CACHE_EVICTION, fieldDataCacheEvictions, 300);
    }

    @VisibleForTesting
    public void setClock(Clock clock) {
        this.clock = clock;
    }

    @Override
    public ResourceFlowUnit<HotNodeSummary> operate() {
        ++this.counter;
        long currTimestamp = this.clock.millis();
        this.cacheEvictionCollector.collect(currTimestamp);
        if (this.counter >= this.rcaPeriod) {
            ResourceContext context;
            InstanceDetails instanceDetails = this.getInstanceDetails();
            HotNodeSummary nodeSummary = new HotNodeSummary(instanceDetails.getInstanceId(), instanceDetails.getInstanceIp());
            double fieldDataCacheMaxSizeInBytes = CacheUtil.getCacheMaxSize(this.getAppContext(), new NodeKey(instanceDetails), ResourceUtil.FIELD_DATA_CACHE_MAX_SIZE);
            Boolean exceedsSizeThreshold = CacheUtil.isSizeThresholdExceeded(this.fieldDataCacheSizeGroupByOperation, fieldDataCacheMaxSizeInBytes, this.cacheSizeThreshold);
            if (this.cacheEvictionCollector.isUnhealthy(currTimestamp) && exceedsSizeThreshold.booleanValue()) {
                context = new ResourceContext(Resources.State.UNHEALTHY);
                nodeSummary.appendNestedSummary(this.cacheEvictionCollector.generateSummary(currTimestamp));
                PerformanceAnalyzerApp.RCA_VERTICES_METRICS_AGGREGATOR.updateStat(RcaVerticesMetrics.NUM_FIELD_DATA_CACHE_RCA_TRIGGERED, instanceDetails.getInstanceId().toString(), 1);
            } else {
                context = new ResourceContext(Resources.State.HEALTHY);
            }
            this.counter = 0;
            return new ResourceFlowUnit<HotNodeSummary>(currTimestamp, context, nodeSummary, !instanceDetails.getIsMaster());
        }
        return new ResourceFlowUnit<HotNodeSummary>(currTimestamp);
    }

    @Override
    public void readRcaConf(RcaConf conf) {
        FieldDataCacheRcaConfig configObj = conf.getFieldDataCacheRcaConfig();
        this.cacheSizeThreshold = configObj.getFieldDataCacheSizeThreshold();
        long cacheCollectorTimePeriodInSec = TimeUnit.SECONDS.toMillis(configObj.getFieldDataCollectorTimePeriodInSec());
        this.cacheEvictionCollector.setCollectorTimePeriod(cacheCollectorTimePeriodInSec);
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        List<FlowUnitMessage> flowUnitMessages = args.getWireHopper().readFromWire(args.getNode());
        ArrayList flowUnitList = new ArrayList();
        LOG.debug("rca: Executing fromWire: {}", (Object)this.getClass().getSimpleName());
        for (FlowUnitMessage flowUnitMessage : flowUnitMessages) {
            flowUnitList.add(ResourceFlowUnit.buildFlowUnitFromWrapper(flowUnitMessage));
        }
        this.setFlowUnits(flowUnitList);
    }

    private static class CacheEvictionCollector {
        private final Resource cache;
        private final Metric cacheEvictionMetrics;
        private boolean hasEvictions;
        private long evictionTimestamp;
        private long metricTimePeriodInMillis;

        private CacheEvictionCollector(Resource cache, Metric cacheEvictionMetrics, int metricTimePeriodInMillis) {
            this.cache = cache;
            this.cacheEvictionMetrics = cacheEvictionMetrics;
            this.hasEvictions = false;
            this.evictionTimestamp = 0L;
            this.metricTimePeriodInMillis = TimeUnit.SECONDS.toMillis(metricTimePeriodInMillis);
        }

        public void setCollectorTimePeriod(long metricTimePeriodInMillis) {
            this.metricTimePeriodInMillis = metricTimePeriodInMillis;
        }

        public void collect(long currTimestamp) {
            for (MetricFlowUnit flowUnit : this.cacheEvictionMetrics.getFlowUnits()) {
                if (flowUnit.isEmpty() || flowUnit.getData() == null) continue;
                double evictionCount = flowUnit.getData().stream().mapToDouble(record -> (Double)record.getValue("max", Double.class)).sum();
                if (!Double.isNaN(evictionCount)) {
                    if (evictionCount > 0.0) {
                        if (!this.hasEvictions) {
                            this.evictionTimestamp = currTimestamp;
                        }
                        this.hasEvictions = true;
                        continue;
                    }
                    this.hasEvictions = false;
                    continue;
                }
                LOG.error("Failed to parse metric from cache {}", (Object)this.cache.toString());
            }
        }

        public boolean isUnhealthy(long currTimestamp) {
            return this.hasEvictions && currTimestamp - this.evictionTimestamp >= this.metricTimePeriodInMillis;
        }

        private HotResourceSummary generateSummary(long currTimestamp) {
            return new HotResourceSummary(this.cache, TimeUnit.MILLISECONDS.toSeconds(this.metricTimePeriodInMillis), TimeUnit.MILLISECONDS.toSeconds(currTimestamp - this.evictionTimestamp), 0);
        }
    }
}

