/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cache;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.AppContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.Resource;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Metric;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.MetricFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Record;
import org.jooq.Result;

public class CacheUtil {
    private static final Logger LOG = LogManager.getLogger(CacheUtil.class);
    public static final long KB_TO_BYTES = 1024L;
    public static final long MB_TO_BYTES = 0x100000L;
    public static final long GB_TO_BYTES = 0x40000000L;

    public static Double getTotalSizeInKB(Metric cacheSizeGroupByOperation) {
        double totalSizeInKB = 0.0;
        if (cacheSizeGroupByOperation.getFlowUnits().size() > 0) {
            MetricFlowUnit flowUnit = (MetricFlowUnit)cacheSizeGroupByOperation.getFlowUnits().get(0);
            if (flowUnit.isEmpty() || flowUnit.getData() == null) {
                return totalSizeInKB;
            }
            if (flowUnit.getData().size() > 0) {
                Result<Record> records = flowUnit.getData();
                double size = records.stream().mapToDouble(record -> (Double)record.getValue("sum", Double.class)).sum();
                totalSizeInKB += CacheUtil.getSizeInKB(size).doubleValue();
            }
        }
        if (!Double.isNaN(totalSizeInKB)) {
            return totalSizeInKB;
        }
        throw new IllegalArgumentException("invalid value: {} in getTotalSizeInKBNaN");
    }

    public static Double getSizeInKB(double sizeinBytes) {
        if (!Double.isNaN(sizeinBytes)) {
            return sizeinBytes / 1024.0;
        }
        throw new IllegalArgumentException("invalid value: {} in getSizeInKBNaN");
    }

    public static double getCacheMaxSize(AppContext appContext, NodeKey esNode, Resource cacheResource) {
        try {
            return appContext.getNodeConfigCache().get(esNode, cacheResource);
        }
        catch (IllegalArgumentException e) {
            LOG.error("error in fetching: {} from Node Config Cache. Possibly the resource hasn't been added to cache yet.", (Object)cacheResource.toString());
            return 0.0;
        }
    }

    public static Boolean isSizeThresholdExceeded(Metric cacheSizeGroupByOperation, double cacheMaxSizeinBytes, double threshold_percentage) {
        try {
            double cacheSizeInKB = CacheUtil.getTotalSizeInKB(cacheSizeGroupByOperation);
            double cacheMaxSizeInKB = CacheUtil.getSizeInKB(cacheMaxSizeinBytes);
            return cacheSizeInKB != 0.0 && cacheMaxSizeInKB != 0.0 && cacheSizeInKB > cacheMaxSizeInKB * threshold_percentage;
        }
        catch (Exception e) {
            LOG.error("error in calculating isSizeThresholdExceeded");
            return Boolean.FALSE;
        }
    }
}

