/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatExceptionCode;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.AllMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Metric;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Rca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindow;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindowData;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.MetricFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.persist.SQLParsingUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;

public abstract class OldGenRca<T extends ResourceFlowUnit<?>>
extends Rca<T> {
    private static final Logger LOG = LogManager.getLogger(OldGenRca.class);
    private static final double CONVERT_BYTES_TO_MEGABYTES = Math.pow(1024.0, 2.0);
    private static final String CMS_COLLECTOR = "ConcurrentMarkSweep";
    protected final Metric heap_Used;
    protected final Metric heap_Max;
    protected final Metric gc_event;
    protected final Metric gc_type;

    public OldGenRca(long evaluationIntervalSeconds, Metric heapUsed, Metric heapMax, Metric gcEvent, Metric gcType) {
        super(evaluationIntervalSeconds);
        this.heap_Max = heapMax;
        this.heap_Used = heapUsed;
        this.gc_event = gcEvent;
        this.gc_type = gcType;
    }

    protected double getMaxHeapSizeOrDefault(double defaultValue) {
        if (this.heap_Max == null) {
            StatsCollector.instance().logException(StatExceptionCode.MISCONFIGURED_OLD_GEN_RCA_HEAP_MAX_MISSING);
            throw new IllegalStateException("RCA: " + this.name() + "was not configured in the graph to take heap_Max as a metric. Please check the analysis graph!");
        }
        double maxHeapSize = defaultValue;
        List heapMaxMetrics = this.heap_Max.getFlowUnits();
        for (MetricFlowUnit heapMaxMetric : heapMaxMetrics) {
            if (heapMaxMetric.isEmpty()) continue;
            double ret = SQLParsingUtil.readDataFromSqlResult(heapMaxMetric.getData(), AllMetrics.HeapDimension.MEM_TYPE.getField(), AllMetrics.GCType.HEAP.toString(), "max");
            if (Double.isNaN(ret)) {
                LOG.error("Failed to parse metric in FlowUnit from {}", (Object)this.heap_Max.getClass().getName());
                continue;
            }
            maxHeapSize = ret / CONVERT_BYTES_TO_MEGABYTES;
        }
        return maxHeapSize;
    }

    protected double getMaxOldGenSizeOrDefault(double defaultValue) {
        if (this.heap_Max == null) {
            StatsCollector.instance().logException(StatExceptionCode.MISCONFIGURED_OLD_GEN_RCA_HEAP_MAX_MISSING);
            throw new IllegalStateException("RCA: " + this.name() + "was not configured in the graph to take heap_Max as a metric. Please check the analysis graph!");
        }
        double maxOldGenHeapSize = defaultValue;
        List heapMaxMetrics = this.heap_Max.getFlowUnits();
        for (MetricFlowUnit heapMaxMetric : heapMaxMetrics) {
            if (heapMaxMetric.isEmpty()) continue;
            double ret = SQLParsingUtil.readDataFromSqlResult(heapMaxMetric.getData(), AllMetrics.HeapDimension.MEM_TYPE.getField(), AllMetrics.GCType.OLD_GEN.toString(), "max");
            if (Double.isNaN(ret)) {
                LOG.error("Failed to parse metric in FlowUnit from {}", (Object)this.heap_Max.getClass().getName());
                continue;
            }
            maxOldGenHeapSize = ret / CONVERT_BYTES_TO_MEGABYTES;
        }
        return maxOldGenHeapSize;
    }

    protected int getFullGcEventsOrDefault(double defaultValue) {
        if (this.gc_event == null) {
            StatsCollector.instance().logException(StatExceptionCode.MISCONFIGURED_OLD_GEN_RCA_GC_EVENTS_MISSING);
            throw new IllegalStateException("RCA: " + this.name() + "was not configured in the graph to take gc_event as a metric. Please check the analysis graph!");
        }
        double fullGcEvents = defaultValue;
        List gcEventMetrics = this.gc_event.getFlowUnits();
        for (MetricFlowUnit gcEventMetric : gcEventMetrics) {
            if (gcEventMetric.isEmpty()) continue;
            double ret = SQLParsingUtil.readDataFromSqlResult(gcEventMetric.getData(), AllMetrics.HeapDimension.MEM_TYPE.getField(), AllMetrics.GCType.TOT_FULL_GC.toString(), "max");
            if (Double.isNaN(ret)) {
                LOG.error("Failed to parse metric in FlowUnit from {}", (Object)this.gc_event.getClass().getName());
                continue;
            }
            fullGcEvents = ret;
        }
        return (int)fullGcEvents;
    }

    protected double getOldGenUsedOrDefault(double defaultValue) {
        if (this.heap_Used == null) {
            StatsCollector.instance().logException(StatExceptionCode.MISCONFIGURED_OLD_GEN_RCA_HEAP_USED_MISSING);
            throw new IllegalStateException("RCA: " + this.name() + "was not configured in the graph to take heap_Used as a metric. Please check the analysis graph!");
        }
        List heapUsedMetrics = this.heap_Used.getFlowUnits();
        double oldGenHeapUsed = defaultValue;
        for (MetricFlowUnit heapUsedMetric : heapUsedMetrics) {
            if (heapUsedMetric.isEmpty()) continue;
            double ret = SQLParsingUtil.readDataFromSqlResult(heapUsedMetric.getData(), AllMetrics.HeapDimension.MEM_TYPE.getField(), AllMetrics.GCType.OLD_GEN.toString(), "max");
            if (Double.isNaN(ret)) {
                LOG.error("Failed to parse metric in FlowUnit from {}", (Object)this.heap_Used.getClass().getName());
                continue;
            }
            oldGenHeapUsed = ret / CONVERT_BYTES_TO_MEGABYTES;
        }
        return oldGenHeapUsed;
    }

    protected boolean isOldGenCollectorCMS() {
        if (this.gc_type == null) {
            throw new IllegalStateException("RCA: " + this.name() + "was not configured in the graph to take GC_Type as a metric. Please check the analysis graph!");
        }
        List gcTypeFlowUnits = this.gc_type.getFlowUnits();
        Field<String> memTypeField = AllMetrics.GCInfoDimension.MEMORY_POOL.getField();
        Field<String> collectorField = AllMetrics.GCInfoDimension.COLLECTOR_NAME.getField();
        for (MetricFlowUnit gcTypeFlowUnit : gcTypeFlowUnits) {
            if (gcTypeFlowUnit.isEmpty()) continue;
            Result<Record> records = gcTypeFlowUnit.getData();
            for (Record record : records) {
                String memType = (String)record.get(memTypeField);
                if (!AllMetrics.GCType.OLD_GEN.toString().equals(memType)) continue;
                return CMS_COLLECTOR.equals(record.get(collectorField));
            }
        }
        return true;
    }

    public static class MinOldGenSlidingWindow
    extends SlidingWindow<SlidingWindowData> {
        public MinOldGenSlidingWindow(int SLIDING_WINDOW_SIZE_IN_TIMESTAMP, TimeUnit timeUnit) {
            super(SLIDING_WINDOW_SIZE_IN_TIMESTAMP, timeUnit);
        }

        @Override
        public void next(SlidingWindowData e) {
            while (!this.windowDeque.isEmpty() && ((SlidingWindowData)this.windowDeque.peekFirst()).getValue() >= e.getValue()) {
                this.windowDeque.pollFirst();
            }
            this.windowDeque.addFirst(e);
            while (!this.windowDeque.isEmpty() && TimeUnit.MILLISECONDS.toSeconds(e.getTimeStamp() - ((SlidingWindowData)this.windowDeque.peekLast()).getTimeStamp()) > this.SLIDING_WINDOW_SIZE) {
                this.windowDeque.pollLast();
            }
        }

        public double readMin() {
            if (!this.windowDeque.isEmpty()) {
                return ((SlidingWindowData)this.windowDeque.peekLast()).getValue();
            }
            return Double.NaN;
        }
    }
}

