/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.ResourceEnum;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Rca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Resources;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaVerticesMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HighHeapUsageClusterRca
extends Rca<ResourceFlowUnit<HotClusterSummary>> {
    public static final String RCA_TABLE_NAME = HighHeapUsageClusterRca.class.getSimpleName();
    private static final Logger LOG = LogManager.getLogger(HighHeapUsageClusterRca.class);
    private static final int UNHEALTHY_FLOWUNIT_THRESHOLD = 3;
    private static final int CACHE_EXPIRATION_TIMEOUT = 10;
    private final Rca<ResourceFlowUnit<HotNodeSummary>> hotNodeRca;
    private final LoadingCache<String, ImmutableList<ResourceFlowUnit<HotNodeSummary>>> nodeStateCache;
    private final int rcaPeriod;
    private int counter;

    public <R extends Rca> HighHeapUsageClusterRca(int rcaPeriod, R hotNodeRca) {
        super(5L);
        this.hotNodeRca = hotNodeRca;
        this.rcaPeriod = rcaPeriod;
        this.counter = 0;
        this.nodeStateCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, ImmutableList<ResourceFlowUnit<HotNodeSummary>>>(){

            public ImmutableList<ResourceFlowUnit<HotNodeSummary>> load(String key) {
                return ImmutableList.copyOf(new ArrayList());
            }
        });
    }

    private List<HotNodeSummary> getUnhealthyNodeList() {
        ArrayList<HotNodeSummary> unhealthyNodeList = new ArrayList<HotNodeSummary>();
        ConcurrentMap currentMap = this.nodeStateCache.asMap();
        for (InstanceDetails nodeDetails : this.getDataNodeInstances()) {
            ImmutableList nodeStateList = (ImmutableList)currentMap.get(nodeDetails.getInstanceId().toString());
            if (nodeStateList == null) continue;
            ArrayList<HotResourceSummary> oldGenSummaries = new ArrayList<HotResourceSummary>();
            ArrayList<HotResourceSummary> youngGenSummaries = new ArrayList<HotResourceSummary>();
            for (ResourceFlowUnit flowUnit : nodeStateList) {
                if (flowUnit.getResourceContext().getState() != Resources.State.UNHEALTHY) continue;
                HotNodeSummary currentNodSummary = (HotNodeSummary)flowUnit.getSummary();
                for (HotResourceSummary resourceSummary : currentNodSummary.getHotResourceSummaryList()) {
                    if (resourceSummary.getResource().getResourceEnum() == ResourceEnum.YOUNG_GEN) {
                        youngGenSummaries.add(resourceSummary);
                        continue;
                    }
                    if (resourceSummary.getResource().getResourceEnum() != ResourceEnum.OLD_GEN) continue;
                    oldGenSummaries.add(resourceSummary);
                }
            }
            if (youngGenSummaries.size() < 3 && oldGenSummaries.size() < 3) continue;
            HotNodeSummary nodeSummary = new HotNodeSummary(nodeDetails.getInstanceId(), nodeDetails.getInstanceIp());
            if (youngGenSummaries.size() >= 3) {
                nodeSummary.appendNestedSummary((HotResourceSummary)youngGenSummaries.get(0));
            }
            if (oldGenSummaries.size() >= 3) {
                nodeSummary.appendNestedSummary((HotResourceSummary)oldGenSummaries.get(0));
            }
            unhealthyNodeList.add(nodeSummary);
        }
        return unhealthyNodeList;
    }

    private void readComputeWrite(String nodeId, ResourceFlowUnit<HotNodeSummary> flowUnit) throws ExecutionException {
        ArrayDeque<ResourceFlowUnit<HotNodeSummary>> nodeStateDeque = new ArrayDeque<ResourceFlowUnit<HotNodeSummary>>((Collection)this.nodeStateCache.get((Object)nodeId));
        nodeStateDeque.addFirst(flowUnit);
        if (nodeStateDeque.size() > 3) {
            nodeStateDeque.removeLast();
        }
        this.nodeStateCache.put((Object)nodeId, (Object)ImmutableList.copyOf(nodeStateDeque));
    }

    @Override
    public ResourceFlowUnit<HotClusterSummary> operate() {
        List hotNodeRcaFlowUnits = this.hotNodeRca.getFlowUnits();
        ++this.counter;
        for (ResourceFlowUnit hotNodeRcaFlowUnit : hotNodeRcaFlowUnits) {
            if (hotNodeRcaFlowUnit.isEmpty()) continue;
            String nodeId = ((HotNodeSummary)hotNodeRcaFlowUnit.getSummary()).getNodeID().toString();
            try {
                this.readComputeWrite(nodeId, hotNodeRcaFlowUnit);
            }
            catch (ExecutionException e) {
                LOG.debug("ExecutionException occurs when retrieving key {}", (Object)nodeId);
            }
        }
        if (this.counter == this.rcaPeriod) {
            List<HotNodeSummary> unhealthyNodeList = this.getUnhealthyNodeList();
            this.counter = 0;
            ResourceContext context = null;
            HotClusterSummary summary = null;
            LOG.debug("Unhealthy node id list : {}", unhealthyNodeList);
            if (unhealthyNodeList.size() > 0) {
                context = new ResourceContext(Resources.State.UNHEALTHY);
                summary = new HotClusterSummary(this.getAllClusterInstances().size(), unhealthyNodeList.size());
                for (HotNodeSummary unhealthyNodeSummary : unhealthyNodeList) {
                    summary.appendNestedSummary(unhealthyNodeSummary);
                }
                PerformanceAnalyzerApp.RCA_VERTICES_METRICS_AGGREGATOR.updateStat(RcaVerticesMetrics.NUM_HIGH_HEAP_CLUSTER_RCA_TRIGGERED, "", 1);
            } else {
                context = new ResourceContext(Resources.State.HEALTHY);
            }
            return new ResourceFlowUnit<Object>(System.currentTimeMillis(), context, summary, true);
        }
        LOG.debug("Empty FlowUnit returned for {}", (Object)this.getClass().getName());
        return new ResourceFlowUnit<HotClusterSummary>(System.currentTimeMillis());
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        throw new IllegalArgumentException(this.name() + "'s generateFlowUnitListFromWire() should not be required.");
    }
}

